/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.panorama_screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.juancarloscp52.panorama_screen.mixin.PanoramaRendererAccessor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RotatingCubeMapRenderer {
    private CubeMap cubeMap = TitleScreen.f_96716_;
    private static RotatingCubeMapRenderer INSTANCE;
    private float time = 0.0f;
    private static final ResourceLocation PANORAMA_OVERLAY;
    private boolean doBackgroundFade;
    private long backgroundFadeStart;
    private ResourceLocation overlay = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");

    private RotatingCubeMapRenderer() {
    }

    public static RotatingCubeMapRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RotatingCubeMapRenderer();
        }
        return INSTANCE;
    }

    public void addPanoramaTime(float delta) {
        this.time += delta;
    }

    public void render(GuiGraphics guiGraphics) {
        this.render(guiGraphics, 1.0f, false);
    }

    public void render(GuiGraphics guiGraphics, float alpha, boolean titleScreen) {
        this.cubeMap.m_108849_(Minecraft.m_91087_(), Mth.m_14031_((float)(this.time * 0.001f)) * 5.0f + 25.0f, -this.time * 0.1f, alpha);
        if (!titleScreen) {
            PoseStack matrices = new PoseStack();
            RenderSystem.enableBlend();
            float f = this.doBackgroundFade ? (float)(Util.m_137550_() - this.backgroundFadeStart) / 1000.0f : 1.0f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.doBackgroundFade ? (float)Mth.m_14167_((float)Mth.m_14036_((float)f, (float)0.0f, (float)1.0f)) : 1.0f));
            guiGraphics.m_280411_(this.overlay, 0, 0, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_(), 0.0f, 0.0f, 16, 128, 16, 128);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void update(PanoramaRenderer renderer, ResourceLocation panoramaOverlay, boolean doBackgroundFade, long backgroundFadeStart) {
        this.cubeMap = ((PanoramaRendererAccessor)renderer).getCubeMap();
        this.overlay = panoramaOverlay;
        this.doBackgroundFade = doBackgroundFade;
        this.backgroundFadeStart = backgroundFadeStart;
    }

    public void updateOverlayId(ResourceLocation panoramaOverlay) {
        this.overlay = panoramaOverlay;
    }

    static {
        PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    }
}

