/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.data.PartialOrigin;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.C2SChooseOrigin;
import io.github.edwinmindcraft.origins.common.network.C2SChooseRandomOrigin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ChooseOriginScreen
extends OriginDisplayScreen {
    private static final Comparator<Holder<Origin>> COMPARATOR = Comparator.comparingInt(a -> ((Origin)a.m_203334_()).getImpact().getImpactValue()).thenComparingInt(a -> ((Origin)a.m_203334_()).getOrder());
    private final List<Holder<OriginLayer>> layerList;
    private final int currentLayerIndex;
    private int currentOrigin = 0;
    private final List<Holder<Origin>> originSelection;
    private int maxSelection;
    private Origin randomOrigin;

    public ChooseOriginScreen(List<Holder<OriginLayer>> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((Component)Component.m_237115_((String)"origins.screen.choose_origin"), showDirtBackground);
        Holder<Origin> newOrigin;
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Holder<Origin>>(10);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Holder<OriginLayer> currentLayer = layerList.get(currentLayerIndex);
        ((OriginLayer)currentLayer.m_203334_()).origins((Player)Objects.requireNonNull(player)).forEach(arg_0 -> this.lambda$new$2((Player)player, arg_0));
        this.originSelection.sort(COMPARATOR);
        this.maxSelection = this.originSelection.size();
        if (((OriginLayer)currentLayer.m_203334_()).allowRandom() && ((OriginLayer)currentLayer.m_203334_()).randomOrigins((Player)player).size() > 0) {
            ++this.maxSelection;
        }
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        }
        this.showOrigin(newOrigin, layerList.get(currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()).m_203334_() == this.randomOrigin);
    }

    private void openNextLayerScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean m_6913_() {
        return false;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 182) / 2;
        if (this.maxSelection > 1) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
                Holder<Origin> newOrigin;
                this.currentOrigin = (this.currentOrigin - 1 + this.maxSelection) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()).m_203334_() == this.randomOrigin);
            }).m_252987_(this.guiLeft - 40, this.f_96544_ / 2 - 10, 20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
                Holder<Origin> newOrigin;
                this.currentOrigin = (this.currentOrigin + 1) % this.maxSelection;
                this.showOrigin(newOrigin, this.layerList.get(this.currentLayerIndex), (newOrigin = this.getCurrentOriginInternal()).m_203334_() == this.randomOrigin);
            }).m_252987_(this.guiLeft + 176 + 20, this.f_96544_ / 2 - 10, 20, 20).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"origins.gui.select"), b -> {
            ResourceLocation layer = ((Optional)this.layerList.get(this.currentLayerIndex).m_203439_().map(Optional::of, arg_0 -> OriginsAPI.getLayersRegistry(null).m_7854_(arg_0))).map(ResourceKey::m_135782_).orElseThrow();
            if (this.currentOrigin == this.originSelection.size()) {
                OriginsCommon.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChooseRandomOrigin(layer));
            } else {
                Optional key = (Optional)this.getCurrentOrigin().m_203439_().map(Optional::of, arg_0 -> OriginsAPI.getOriginsRegistry(null).m_7854_(arg_0));
                if (key.isPresent()) {
                    OriginsCommon.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SChooseOrigin(layer, ((ResourceKey)key.get()).m_135782_()));
                } else {
                    Origins.LOGGER.error("Unregistered origin found for layer {}: {}", (Object)layer, this.getCurrentOrigin());
                }
            }
            this.openNextLayerScreen();
        }).m_252987_(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20).m_253136_());
    }

    @Override
    protected Component getTitleText() {
        Component titleText = ((OriginLayer)this.getCurrentLayer().get()).title().choose();
        if (titleText != null) {
            return titleText;
        }
        return Component.m_237110_((String)"origins.gui.choose_origin.title", (Object[])new Object[]{((OriginLayer)this.getCurrentLayer().get()).name()});
    }

    private Holder<Origin> getCurrentOriginInternal() {
        if (this.currentOrigin == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return Holder.m_205709_((Object)this.randomOrigin);
        }
        return this.originSelection.get(this.currentOrigin);
    }

    private void initRandomOrigin() {
        this.randomOrigin = PartialOrigin.builder().icon(new ItemStack((ItemLike)ModItems.ORB_OF_ORIGIN.get())).impact(Impact.NONE).order(Integer.MAX_VALUE).loadingOrder(Integer.MAX_VALUE).build().create(Origins.identifier("random"));
        MutableComponent text = Component.m_237113_((String)"");
        List<Holder<Origin>> randoms = ((OriginLayer)this.layerList.get(this.currentLayerIndex).m_203334_()).randomOrigins((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_)).stream().filter(Objects::nonNull).sorted(COMPARATOR).toList();
        randoms.forEach(x -> text.m_7220_(((Origin)x.m_203334_()).getName()).m_130946_("\n"));
        this.setRandomOriginText((Component)text);
    }

    @Override
    public void m_280273_(@NotNull GuiGraphics graphics) {
        if (this.showDirtBackground) {
            super.m_280039_(graphics);
        } else {
            super.m_280273_(graphics);
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    private /* synthetic */ void lambda$new$2(Player player, Holder origin) {
        if (origin.m_203633_() && ((Origin)origin.m_203334_()).isChoosable()) {
            ItemStack displayItem = ((Origin)origin.m_203334_()).getIcon();
            if (!(displayItem.m_41720_() != Items.f_42680_ || displayItem.m_41782_() && Objects.requireNonNull(displayItem.m_41783_()).m_128441_("SkullOwner"))) {
                displayItem.m_41784_().m_128359_("SkullOwner", player.m_5446_().getString());
            }
            this.originSelection.add((Holder<Origin>)origin);
        }
    }
}

