/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.transformer;

import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.source.FileResolution;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.data.ChildNodeList;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.statement.CompoundStatement;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.query.index.ExternalDeclarationIndex;
import io.github.douira.glsl_transformer.ast.query.index.IdentifierIndex;
import io.github.douira.glsl_transformer.ast.query.index.SuperclassNodeIndex;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.HintedMatcher;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.JobParameters;
import io.github.douira.glsl_transformer.ast.transform.SingleASTTransformer;
import io.github.douira.glsl_transformer.parser.ParseShape;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.shaderpack.preprocessor.JcppProcessor;
import top.leonx.irisflw.transformer.ShaderPatcherBase;

public class GlslTransformerShaderPatcher
extends ShaderPatcherBase {
    private SingleASTTransformer<ContextParameter> transformer = new SingleASTTransformer<ContextParameter>(){
        {
            this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
        }

        public TranslationUnit parseTranslationUnit(Root rootInstance, String input) {
            Matcher matcher = versionPattern.matcher(input);
            if (!matcher.find()) {
                throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
            }
            Version version = Version.fromNumber((int)Integer.parseInt(matcher.group(1)));
            if (version.number >= 200) {
                version = Version.GLSL33;
            }
            GlslTransformerShaderPatcher.this.transformer.getLexer().version = version;
            return super.parseTranslationUnit(rootInstance, input);
        }
    };
    private SingleASTTransformer<ContextParameter> flwTransformer;
    public static final AutoHintedMatcher<Expression> glTextureMatrix0 = new AutoHintedMatcher("gl_TextureMatrix[0]", ParseShape.EXPRESSION);
    public static final AutoHintedMatcher<Expression> glTextureMatrix1 = new AutoHintedMatcher("gl_TextureMatrix[1]", ParseShape.EXPRESSION);
    public static final AutoHintedMatcher<Expression> glTextureMatrix2 = new AutoHintedMatcher("gl_TextureMatrix[2]", ParseShape.EXPRESSION);
    public static final AutoHintedMatcher<ExternalDeclaration> atTangentAttribute = new AutoHintedMatcher("attribute vec4 at_tangent;", ParseShape.EXTERNAL_DECLARATION);
    public static final AutoHintedMatcher<ExternalDeclaration> mcEntityAttribute = new AutoHintedMatcher("attribute vec4 mc_Entity;", ParseShape.EXTERNAL_DECLARATION);
    private static final ParseShape<GLSLParser.CompoundStatementContext, CompoundStatement> CompoundStatementShape = new ParseShape(GLSLParser.CompoundStatementContext.class, GLSLParser::compoundStatement, ASTBuilder::visitCompoundStatement);
    private static final Pattern boxCoordDetector = Pattern.compile("BoxCoord");
    private static final Pattern versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);

    public GlslTransformerShaderPatcher(Template<? extends VertexData> template, FileResolution header) {
        super(template, header);
        this.transformer.setTransformation(this::transform);
        this.flwTransformer = new SingleASTTransformer();
        this.flwTransformer.setRootSupplier(new RootSupplier(SuperclassNodeIndex::withOrdered, IdentifierIndex::withOnlyExact, ExternalDeclarationIndex::withOnlyExactOrdered));
        this.flwTransformer.getLexer().version = Version.GLSL33;
    }

    private void transform(TranslationUnit tree, Root root, ContextParameter parameter) {
        StringBuilder beforeDeclarationContent = new StringBuilder();
        VertexData vertexTemplate = (VertexData)this.template.get((Object)parameter.ctx.file);
        this.genHeadSource(beforeDeclarationContent, parameter.ctx);
        this.genCommonSource(beforeDeclarationContent, parameter.ctx, vertexTemplate);
        String predefineContent = JcppProcessor.glslPreprocessSource((String)beforeDeclarationContent.toString(), List.of(new StringPair("VERTEX_SHADER", "1")));
        ChildNodeList declarationMembers = this.flwTransformer.parseSeparateTranslationUnit(predefineContent).getChildren();
        tree.injectNodes(ASTInjectionPoint.BEFORE_DECLARATIONS, (Collection)declarationMembers);
        StringBuilder createVertexBuilder = new StringBuilder();
        createVertexBuilder.append("{\n");
        this.generateCreateVertex(vertexTemplate, createVertexBuilder);
        createVertexBuilder.append("vec3 skewedNormal = v.normal+vec3(0.5,0.5,0.5);\n_flw_tangent = vec4(normalize(skewedNormal - v.normal*dot(skewedNormal,v.normal)).xyz,1.0);\n");
        createVertexBuilder.append("_flw_patched_vertex_pos = FLWVertex(v);\n");
        createVertexBuilder.append("\n}");
        String prependMainFuncContent = JcppProcessor.glslPreprocessSource((String)createVertexBuilder.toString(), List.of(new StringPair("VERTEX_SHADER", "1")));
        CompoundStatement compoundStatement = (CompoundStatement)this.flwTransformer.parseNodeSeparate(this.flwTransformer.getRootSupplier(), CompoundStatementShape, prependMainFuncContent);
        compoundStatement.getRoot().rename("i", "_flw_instance");
        ChildNodeList prependMainFuncStatements = compoundStatement.getStatements();
        tree.prependMainFunctionBody((Collection)prependMainFuncStatements);
        root.replaceReferenceExpressions(this.transformer, "gl_Vertex", "inverse(gl_ProjectionMatrix*gl_ModelViewMatrix)*_flw_patched_vertex_pos");
        root.replaceReferenceExpressions(this.transformer, "gl_MultiTexCoord0", "vec4(v.texCoords,0,1)");
        root.replaceReferenceExpressions(this.transformer, "gl_Normal", "v.normal");
        root.replaceReferenceExpressions(this.transformer, "gl_Color", "v.color");
        root.replaceExpressionMatches(this.transformer, (HintedMatcher)new AutoHintedMatcher("ftransform()", ParseShape.EXPRESSION), "_flw_patched_vertex_pos");
        root.processMatches(this.transformer, atTangentAttribute, ASTNode::detachAndDelete);
        root.replaceReferenceExpressions(this.transformer, "at_tangent", "_flw_tangent");
        root.processMatches(this.transformer, mcEntityAttribute, ASTNode::detachAndDelete);
        root.replaceReferenceExpressions(this.transformer, "mc_Entity", "vec4(0)");
        if (boxCoordDetector.matcher(predefineContent).find()) {
            root.replaceReferenceExpressionsReport(this.transformer, "gl_MultiTexCoord1", "(vec4(max(v.light,texture3D(uLightVolume,BoxCoord).rg)*240.0,0,1))");
        } else {
            root.replaceReferenceExpressionsReport(this.transformer, "gl_MultiTexCoord1", "(vec4(v.light*240.0,0,1))");
        }
    }

    @Override
    public String patch(String irisSource, ShaderPatcherBase.Context key) {
        return (String)this.transformer.transform((Object)irisSource, (Object)new ContextParameter(key));
    }

    public static class ContextParameter
    implements JobParameters {
        public ShaderPatcherBase.Context ctx;

        public ContextParameter(ShaderPatcherBase.Context ctx) {
            this.ctx = ctx;
        }
    }
}

