/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.hekate;

import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import com.obscuria.obscureapi.network.AnimationPlayMessage;
import com.obscuria.obscureapi.network.AnimationStopMessage;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public class Animation {
    private final byte ID;
    private int tick;
    private int duration;

    public Animation(int id) {
        this.ID = (byte)id;
    }

    public void tick() {
        if (this.duration > 0) {
            ++this.tick;
        }
        if (this.tick >= this.duration) {
            this.tick = 0;
            this.duration = 0;
        }
    }

    public void play(Entity entity, int duration) {
        this.play(entity, 0, duration, 256);
    }

    public void play(Entity entity, int tick, int duration) {
        this.play(entity, tick, duration, 256);
    }

    public void play(Entity entity, int tick, int duration, int distance) {
        if (entity == null || entity.m_9236_().f_46443_) {
            return;
        }
        this.localPlay(tick, duration);
        ObscureAPI.PACKET_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (double)distance, entity.m_9236_().m_46472_())), (Object)new AnimationPlayMessage(entity.m_19879_(), this.getID(), tick, duration));
    }

    public void stop(Entity entity) {
        this.stop(entity, 256);
    }

    public void stop(Entity entity, int distance) {
        if (entity == null || entity.m_9236_().f_46443_) {
            return;
        }
        this.localStop();
        ObscureAPI.PACKET_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (double)distance, entity.m_9236_().m_46472_())), (Object)new AnimationStopMessage(entity.m_19879_(), this.getID()));
    }

    public void localPlay(int tick, int duration) {
        this.tick = tick;
        this.duration = duration;
    }

    public void localStop() {
        this.tick = 0;
        this.duration = 0;
    }

    public boolean sound(Entity entity, int tick, Supplier<SoundEvent> sound, SoundSource source, float volume, float pitch) {
        if (this.tick != tick) {
            return false;
        }
        entity.m_9236_().m_6269_(null, entity, sound.get(), source, volume, pitch);
        return true;
    }

    public byte getID() {
        return this.ID;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean hasPlayed() {
        return this.isPlaying() && this.getTick() == this.getDuration() - 1;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf((float)this.tick / (float)this.duration)).floatValue();
    }

    public float getProgress(float partialTicks) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(((float)this.tick + partialTicks) / (float)this.duration)).floatValue();
    }

    public boolean isPlaying() {
        return this.duration > 0 && this.tick < this.duration;
    }
}

