/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.common.classes;

import com.obscuria.obscureapi.api.common.classes.Bonus;
import com.obscuria.obscureapi.api.common.classes.ObscureClass;
import com.obscuria.obscureapi.api.common.classes.ObscureType;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import com.obscuria.obscureapi.registry.ObscureAPIMobEffects;
import com.obscuria.obscureapi.util.ClassUtils;
import com.obscuria.obscureapi.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import org.jetbrains.annotations.Contract;

public class Ability {
    private final Class<? extends Item> ITEM;
    private final String DESCRIPTION;
    private final Cost COST;
    private final Style STYLE;
    private final Action ACTION;
    private final List<Variable> VARIABLES;

    private Ability(Class<? extends Item> item, String description, Style style, Cost cost, List<Variable> variables, Action action) {
        this.ITEM = item;
        this.DESCRIPTION = description;
        this.STYLE = style;
        this.COST = cost;
        this.VARIABLES = variables;
        this.ACTION = action;
    }

    @Nonnull
    @Contract(value="_, _ -> new")
    public static Builder create(String modID, String desc) {
        return new Builder(modID, desc);
    }

    public boolean use(ItemStack stack, LivingEntity entity, @Nullable LivingEntity target, @Nullable UseOnContext context) {
        if (!this.canUse(stack, entity)) {
            return false;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 1; !this.VARIABLES.isEmpty() && i <= this.VARIABLES.size(); ++i) {
            values.add(this.getVariable(entity, i));
        }
        if (this.ACTION.apply(stack, entity, target, context, values)) {
            this.postUse(stack, entity);
            return true;
        }
        return false;
    }

    public boolean canUse(ItemStack stack, LivingEntity entity) {
        return this.COST.test(stack, entity, this.getCost(entity));
    }

    public void postUse(ItemStack stack, LivingEntity entity) {
        this.COST.use(stack, entity, this.getCost(entity));
    }

    public String getDescriptionId() {
        return this.DESCRIPTION;
    }

    public Style getStyle() {
        return this.STYLE;
    }

    public int getCost(LivingEntity entity) {
        if (entity == null || this.COST.TYPE == Cost.Type.NONE) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (this.COST.TYPE == Cost.Type.COOLDOWN && entity.m_21023_((MobEffect)ObscureAPIMobEffects.RUSH.get())) {
            mod2 += -10 - 10 * Objects.requireNonNull(entity.m_21124_((MobEffect)ObscureAPIMobEffects.RUSH.get())).m_19564_();
        }
        if (ClassUtils.isClassItem(this.ITEM)) {
            ObscureClass obscureClass = ClassUtils.getItemClass(this.ITEM);
            ObscureType obscureType = ClassUtils.getItemType(this.ITEM);
            List<Bonus> ARMOR_HEAD = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.HEAD)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.HEAD)) : null;
            List<Bonus> ARMOR_CHEST = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.CHEST)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.CHEST)) : null;
            List<Bonus> ARMOR_LEGS = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.LEGS)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.LEGS)) : null;
            List<Bonus> ARMOR_FEET = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.FEET)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.FEET)) : null;
            List<Bonus> HAND = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.MAINHAND)) && !(entity.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof ArmorItem) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.MAINHAND)) : null;
            mod1 += this.calculateBonus(ARMOR_HEAD, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_CHEST, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_LEGS, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_FEET, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(HAND, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.AMOUNT);
            mod2 += this.calculateBonus(ARMOR_HEAD, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_CHEST, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_LEGS, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_FEET, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(HAND, obscureClass, obscureType, this.COST.toBonus(), Bonus.Operation.PERCENT);
        }
        mod2 = Math.max(mod2, -80);
        return (int)Math.max((double)Math.round((double)(this.COST.VALUE + mod1) + (double)this.COST.VALUE * ((double)mod2 / 100.0)), 1.0);
    }

    public int getVariable(LivingEntity entity, int index) {
        if (entity == null) {
            return 0;
        }
        int variable = this.getVariable(index);
        if (variable <= 0) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (entity.m_21023_((MobEffect)ObscureAPIMobEffects.FURY.get())) {
            mod2 += 10 + 10 * Objects.requireNonNull(entity.m_21124_((MobEffect)ObscureAPIMobEffects.FURY.get())).m_19564_();
        }
        if (ClassUtils.isClassItem(this.ITEM)) {
            ObscureClass obscureClass = ClassUtils.getItemClass(this.ITEM);
            ObscureType obscureType = ClassUtils.getItemType(this.ITEM);
            List<Bonus> ARMOR_HEAD = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.HEAD)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.HEAD)) : null;
            List<Bonus> ARMOR_CHEST = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.CHEST)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.CHEST)) : null;
            List<Bonus> ARMOR_LEGS = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.LEGS)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.LEGS)) : null;
            List<Bonus> ARMOR_FEET = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.FEET)) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.FEET)) : null;
            List<Bonus> HAND = ClassUtils.hasBonuses(entity.m_6844_(EquipmentSlot.MAINHAND)) && !(entity.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof ArmorItem) ? ClassUtils.getVisibleBonuses(entity.m_6844_(EquipmentSlot.MAINHAND)) : null;
            mod1 += this.calculateBonus(ARMOR_HEAD, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_CHEST, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_LEGS, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_FEET, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(HAND, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.AMOUNT);
            mod2 += this.calculateBonus(ARMOR_HEAD, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_CHEST, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_LEGS, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_FEET, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(HAND, obscureClass, obscureType, Bonus.Type.POWER, Bonus.Operation.PERCENT);
        }
        return (int)Math.max((double)Math.round((double)(variable + mod1) + (double)variable * ((double)mod2 / 100.0)), 1.0);
    }

    public int getVariable(int index) {
        return ExceptionFilter.getNoNull(0, () -> this.VARIABLES.get(index - 1).value());
    }

    public String getVariableType(int index) {
        return ExceptionFilter.getNoNull("", () -> this.VARIABLES.get(index - 1).type());
    }

    public String getCostString(LivingEntity entity) {
        int cost = this.COST.VALUE;
        int mod2 = this.getCost(entity);
        String costString = TextUtils.translation("obscure_api.ability.cost." + this.COST.getName());
        String costAmount = cost < mod2 ? "\u00a7c" + mod2 : (cost > mod2 ? "\u00a72" + mod2 : Integer.valueOf(mod2));
        costString = costString.replace("#", costAmount);
        return costString + (String)(cost < mod2 ? " \u00a78+" + Math.round(((double)mod2 / 1.0 / (double)cost - 1.0) * 100.0) + "%" : (cost > mod2 ? " \u00a78-" + Math.round((1.0 - (double)mod2 / 1.0 / (double)cost) * 100.0) + "%" : ""));
    }

    public String getVariableString(LivingEntity entity, int index) {
        int mod2;
        int variable = this.getVariable(index);
        return "" + (Serializable)(variable < (mod2 = this.getVariable(entity, index)) ? "\u00a72" + mod2 : (variable > mod2 ? "\u00a7c" + mod2 : Integer.valueOf(mod2)));
    }

    public String getVariableTypeString(int index) {
        String modifier = this.getVariableType(index);
        return modifier.equals("") ? "" : TextUtils.translation("obscure_api.ability.modifier." + modifier);
    }

    private int calculateBonus(List<Bonus> list, ObscureClass itemClass, ObscureType itemType, Bonus.Type bonus, Bonus.Operation operation) {
        int mod2 = 0;
        if (list != null && !list.isEmpty()) {
            for (Bonus entry : list) {
                if (!entry.canBeApplied(itemClass, itemType, bonus, operation)) continue;
                mod2 += entry.getValue();
            }
        }
        return mod2;
    }

    public static enum Style {
        COMMON("\u00a7f", "\u00a77"),
        ATTRIBUTE("\u00a7f", "\u00a79"),
        EPIC("\u00a7d", "\u00a75"),
        LEGENDARY("\u00a7e", "\u00a76"),
        MYTHIC("\u00a7c", "\u00a7c");

        public final String TITLE;
        public final String LINE;

        private Style(String title, String line) {
            this.TITLE = title;
            this.LINE = line;
        }
    }

    public static class Cost {
        final int VALUE;
        final Type TYPE;

        public Cost(int value, Type type) {
            this.VALUE = value;
            this.TYPE = type;
        }

        public boolean test(ItemStack stack, LivingEntity entity, int cost) {
            return this.TYPE.CONDITION.test(stack, entity, cost);
        }

        public void use(ItemStack stack, LivingEntity entity, int cost) {
            this.TYPE.USE.use(stack, entity, cost);
        }

        public String getName() {
            return this.TYPE.NAME;
        }

        @Nonnull
        @Contract(pure=true)
        public String getDescriptionId() {
            return "ability.cost." + this.getName();
        }

        public Bonus.Type toBonus() {
            if (this.TYPE.equals((Object)Type.COOLDOWN)) {
                return Bonus.Type.COOLDOWN;
            }
            return Bonus.Type.POWER;
        }

        public static enum Type {
            NONE("none", (stack, entity, cost) -> true, (stack, entity, cost) -> {}),
            DURABILITY("durability", (stack, entity, cost) -> stack.m_41776_() - stack.m_41773_() > cost, (stack, entity, cost) -> stack.m_41622_(cost, entity, e -> {})),
            HEALTH("health", (stack, entity, cost) -> entity.m_21223_() > (float)cost, (stack, entity, cost) -> entity.m_21153_(entity.m_21223_() - (float)cost)),
            COOLDOWN("cooldown", (stack, entity, cost) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    return !player.m_36335_().m_41519_(stack.m_41720_());
                }
                return true;
            }, (stack, entity, cost) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_36335_().m_41524_(stack.m_41720_(), cost * 20);
                }
            }),
            EXP("exp", (stack, entity, cost) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    return player.f_36079_ >= cost;
                }
                return true;
            }, (stack, entity, cost) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.f_36079_ -= cost;
                }
            }),
            LEVEL("level", (stack, entity, cost) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    return player.f_36078_ >= cost;
                }
                return true;
            }, (stack, entity, cost) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.f_36078_ -= cost;
                }
            });

            private final String NAME;
            private final UseCondition CONDITION;
            private final PostUseAction USE;

            private Type(String name, UseCondition condition, PostUseAction use) {
                this.NAME = name;
                this.CONDITION = condition;
                this.USE = use;
            }
        }

        @FunctionalInterface
        public static interface UseCondition {
            public boolean test(ItemStack var1, LivingEntity var2, int var3);
        }

        @FunctionalInterface
        public static interface PostUseAction {
            public void use(ItemStack var1, LivingEntity var2, int var3);
        }
    }

    @FunctionalInterface
    public static interface Action {
        public boolean apply(ItemStack var1, LivingEntity var2, @Nullable LivingEntity var3, @Nullable UseOnContext var4, List<Integer> var5);
    }

    public static class Builder {
        private final String modID;
        private final String description;
        private Cost cost = new Cost(0, Cost.Type.NONE);
        private Style style = Style.COMMON;
        private Action action = (stack, entity, target, context, values) -> true;
        private final List<Variable> variables = new ArrayList<Variable>();

        private Builder(String modID, String description) {
            this.modID = modID;
            this.description = description;
        }

        public Builder cost(int value) {
            this.cost = new Cost(value, Cost.Type.NONE);
            return this;
        }

        public Builder cost(Cost.Type type, int value) {
            this.cost = new Cost(value, type);
            return this;
        }

        public Builder var(int value) {
            this.variables.add(new Variable(value, ""));
            return this;
        }

        public Builder var(int value, String type) {
            this.variables.add(new Variable(value, type));
            return this;
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Ability build(Class<? extends Item> item) {
            return new Ability(item, "ability." + this.modID + "." + this.description, this.style, this.cost, this.variables, this.action);
        }
    }

    protected record Variable(int value, String type) {
    }
}

