/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.neapolitan.core.other.NeapolitanLootTables;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanMobEffects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LootTableTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class NeapolitanAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[]{(EntityType)NeapolitanEntityTypes.CHIMPANZEE.get()};
    private static final EntityType<?>[] MOBS_TO_KILL = new EntityType[]{(EntityType)NeapolitanEntityTypes.PLANTAIN_SPIDER.get()};

    public NeapolitanAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("neapolitan", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        MobEffectsPredicate predicate = MobEffectsPredicate.m_56552_();
        NeapolitanMobEffects.MOB_EFFECTS.getEntries().forEach(mobEffect -> predicate.m_56553_((MobEffect)mobEffect.get()));
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, predicate), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        Collection items = NeapolitanItems.HELPER.getDeferredRegister().getEntries();
        items.forEach(item -> {
            if (((Item)item.get()).m_41472_()) {
                balancedDiet.addCriterion(ForgeRegistries.ITEMS.getKey((Object)((Item)item.get())).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)item.get())));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAllAnimals = CriteriaModifier.builder((String)this.modId);
        for (EntityType<?> entityType : BREEDABLE_ANIMALS) {
            breedAllAnimals.addCriterion(ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_(), (CriterionTriggerInstance)BredAnimalsTrigger.TriggerInstance.m_18667_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType)));
        }
        this.entry("husbandry/bred_all_animals").selects(new String[]{"husbandry/bred_all_animals"}).addModifier((ObjectModifier)breedAllAnimals.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("husbandry/plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("strawberry_bush", (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get()))).addCriterion("mint", (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)((Block)NeapolitanBlocks.MINT.get()))).addCriterion("adzuki_soil", (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)((Block)NeapolitanBlocks.ADZUKI_SOIL.get()))).addIndexedRequirements(0, false, new String[]{"strawberry_bush", "mint", "adzuki_soil"}).build(), new ICondition[0]);
        this.entry("adventure/salvage_sherd").selects(new String[]{"adventure/salvage_sherd"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("banana_plant_common", (CriterionTriggerInstance)LootTableTrigger.TriggerInstance.m_54618_((ResourceLocation)NeapolitanLootTables.BANANA_PLANT_ARCHAEOLOGY_COMMON)).addCriterion("banana_plant_rare", (CriterionTriggerInstance)LootTableTrigger.TriggerInstance.m_54618_((ResourceLocation)NeapolitanLootTables.BANANA_PLANT_ARCHAEOLOGY_RARE)).addIndexedRequirements(0, false, new String[]{"banana_plant_common", "banana_plant_rare"}).build(), new ICondition[0]);
        String entry = "armor_trimmed_" + NeapolitanItems.PRIMAL_ARMOR_TRIM_SMITHING_TEMPLATE.getId();
        this.entry("adventure/trim_with_any_armor_pattern").selects(new String[]{"adventure/trim_with_any_armor_pattern"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion(entry, (CriterionTriggerInstance)RecipeCraftedTrigger.TriggerInstance.m_280097_((ResourceLocation)NeapolitanItems.PRIMAL_ARMOR_TRIM_SMITHING_TEMPLATE.getId())).addIndexedRequirements(0, false, new String[]{entry}).build(), new ICondition[0]);
        CriteriaModifier.Builder killAMob = CriteriaModifier.builder((String)this.modId);
        CriteriaModifier.Builder killAllMobs = CriteriaModifier.builder((String)this.modId);
        ArrayList names = Lists.newArrayList();
        for (EntityType<?> entityType : MOBS_TO_KILL) {
            String name = ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_();
            KilledTrigger.TriggerInstance triggerInstance = KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
            killAMob.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            killAllMobs.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            names.add(name);
        }
        this.entry("adventure/kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)killAMob.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)killAllMobs.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
    }
}

