/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.item;

import com.teamabnormals.neapolitan.common.block.BeanstalkThornsBlock;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.ArrayList;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class AdzukiBeansItem
extends Item {
    private final boolean magic;

    public AdzukiBeansItem(boolean magic, Item.Properties builder) {
        super(builder);
        this.magic = magic;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        Direction face = context.m_43719_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        RandomSource random = world.m_213780_();
        ArrayList<Direction> offsetDirections = new ArrayList<Direction>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == face.m_122434_()) continue;
            for (Direction direction : Direction.values()) {
                if (direction.m_122434_() != axis) continue;
                offsetDirections.add(direction);
            }
        }
        if (!this.magic) {
            if ((state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50440_)) && world.m_8055_(pos.m_7494_()).m_60795_() && face == Direction.UP) {
                if (!world.m_5776_()) {
                    world.m_46597_(pos, ((Block)NeapolitanBlocks.ADZUKI_SOIL.get()).m_49966_());
                }
                world.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, stack);
                }
                if (player != null && !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
        ArrayList<BlockPos> beanstalkPositions = new ArrayList<BlockPos>();
        BlockPos offsetPos = pos.m_121945_(face);
        if (state.m_247087_()) {
            offsetPos = pos;
        }
        world.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!world.m_5776_() && pos.m_123342_() >= world.m_141937_()) {
            for (Direction direction : offsetDirections) {
                beanstalkPositions.add(offsetPos.m_121945_(direction));
                BlockPos cornerPos = offsetPos.m_121945_(direction).m_121945_(AdzukiBeansItem.rotate(face.m_122434_(), direction));
                if (random.m_188503_(3) != 0) continue;
                beanstalkPositions.add(cornerPos);
            }
            Direction startingDirection = (Direction)offsetDirections.get(random.m_188503_(4));
            block3: for (int i = 0; i < 3 + random.m_188503_(4); ++i) {
                for (int j = 0; j < 3 + random.m_188503_(3); ++j) {
                    if (j != 0) {
                        offsetPos = offsetPos.m_121945_(face);
                    }
                    if (!world.m_8055_(offsetPos).m_247087_()) break block3;
                    beanstalkPositions.add(offsetPos);
                }
                startingDirection = AdzukiBeansItem.rotate(face.m_122434_(), startingDirection);
                offsetPos = offsetPos.m_121945_(startingDirection);
            }
            int placed = 0;
            for (BlockPos blockPos : beanstalkPositions) {
                if (!AdzukiBeansItem.attemptPlaceBeanstalk(world, blockPos, face)) continue;
                ++placed;
            }
            if (placed > 0 && player != null && !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            for (BlockPos blockPos : beanstalkPositions) {
                for (Direction direction : Direction.values()) {
                    BlockPos thornPos = blockPos.m_121945_(direction);
                    BlockState beanState = (BlockState)((BlockState)((Block)NeapolitanBlocks.BEANSTALK_THORNS.get()).m_49966_().m_61124_((Property)BeanstalkThornsBlock.FACING, (Comparable)direction)).m_61124_((Property)BeanstalkThornsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(thornPos).m_76152_() == Fluids.f_76193_));
                    if (!world.m_8055_(blockPos).m_60713_((Block)NeapolitanBlocks.BEANSTALK.get()) || !world.m_8055_(thornPos).m_247087_() || random.m_188503_(4) != 0 || !beanState.m_60710_((LevelReader)world, thornPos)) continue;
                    world.m_46597_(thornPos, beanState);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    private static boolean attemptPlaceBeanstalk(Level world, BlockPos pos, Direction direction) {
        if (world.m_8055_(pos).m_247087_()) {
            return world.m_46597_(pos, (BlockState)((Block)NeapolitanBlocks.BEANSTALK.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
        }
        return false;
    }

    private static Direction rotate(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return switch (face) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.NORTH;
                case Direction.EAST -> Direction.SOUTH;
                default -> throw new IllegalStateException("Unable to get rotated facing of " + face);
            };
        }
        if (axis == Direction.Axis.Z) {
            return switch (face) {
                case Direction.UP -> Direction.EAST;
                case Direction.DOWN -> Direction.WEST;
                case Direction.WEST -> Direction.UP;
                case Direction.EAST -> Direction.DOWN;
                default -> throw new IllegalStateException("Unable to get rotated facing of " + face);
            };
        }
        if (axis == Direction.Axis.X) {
            return switch (face) {
                case Direction.UP -> Direction.NORTH;
                case Direction.DOWN -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.UP;
                case Direction.NORTH -> Direction.DOWN;
                default -> throw new IllegalStateException("Unable to get rotated facing of " + face);
            };
        }
        return face;
    }
}

