/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.goal;

import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class ChimpPlayNoteBlockGoal
extends MoveToBlockGoal {
    private final Chimpanzee chimpanzee;
    private int timePlayed;
    private int noteTime;

    public ChimpPlayNoteBlockGoal(Chimpanzee chimpanzeeIn, double speed, int length) {
        super((PathfinderMob)chimpanzeeIn, speed, length, 6);
        this.chimpanzee = chimpanzeeIn;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        if (!this.chimpanzee.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING)) {
            return false;
        }
        if (this.chimpanzee.m_217043_().m_188503_(600) != 0) {
            return false;
        }
        return this.m_25626_();
    }

    public boolean m_8045_() {
        if (this.timePlayed > 320 && this.chimpanzee.m_217043_().m_188503_(250) == 0) {
            return false;
        }
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        if (!(this.timePlayed <= 0 || this.m_25625_() && this.chimpanzee.isSitting())) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.noteTime = 20;
    }

    public void m_8041_() {
        super.m_8041_();
        this.timePlayed = 0;
        this.chimpanzee.setDefaultAction();
        if (this.chimpanzee.canStandUp()) {
            this.chimpanzee.setSitting(false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        this.chimpanzee.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_() + 0.5, (double)this.f_25602_.m_123343_() + 0.5, (float)(this.chimpanzee.m_8085_() + 20), (float)this.chimpanzee.m_8132_());
        if (this.m_25625_() && this.chimpanzee.m_21573_().m_26571_() && this.chimpanzee.getAction().canBeInterrupted()) {
            this.chimpanzee.setAction(ChimpanzeeAction.DRUMMING);
            this.chimpanzee.setSitting(true);
            if (--this.noteTime <= 0) {
                if (ForgeEventFactory.getMobGriefingEvent((Level)this.chimpanzee.m_9236_(), (Entity)this.chimpanzee)) {
                    BlockState state = this.chimpanzee.m_9236_().m_8055_(this.f_25602_);
                    int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
                    note = Mth.m_14045_((int)(note + this.chimpanzee.m_217043_().m_188503_(7) - 3), (int)0, (int)24);
                    this.chimpanzee.m_9236_().m_7731_(this.f_25602_, (BlockState)state.m_61124_((Property)NoteBlock.f_55013_, (Comparable)Integer.valueOf(note)), 3);
                }
                this.chimpanzee.m_9236_().m_7696_(this.f_25602_, Blocks.f_50065_, 0, 0);
                this.noteTime = 8 + this.chimpanzee.m_217043_().m_188503_(5);
            }
            ++this.timePlayed;
        }
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return worldIn.m_46859_(pos.m_7494_()) && worldIn.m_46859_(pos.m_7494_().m_7494_()) && worldIn.m_8055_(pos).m_60734_() == Blocks.f_50065_ && !this.isBlockBeingPlayed((Level)worldIn, pos);
    }

    private boolean isBlockBeingPlayed(Level worldIn, BlockPos pos) {
        return !worldIn.m_6443_(Chimpanzee.class, new AABB(pos.m_7494_()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.DRUMMING)).isEmpty();
    }
}

