/*
 * Decompiled with CFR 0.152.
 */
package naqaden.namepain.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.time.MonthDay;
import naqaden.namepain.Util;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    private static final ForgeConfigSpec.Builder SPEC_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG_SPEC = Config.specBuilder(SPEC_BUILDER);
    public static BoolEntry applyToPlayers;
    public static BoolEntry playersAlwaysNamed;
    public static BoolEntry seeYourName;
    public static BoolEntry applyToMobs;
    public static BoolEntry seeInjuredNames;
    public static BoolEntry injuredAlwaysNamed;
    public static BoolEntry tamesAlwaysNamed;
    public static BoolEntry horsesAlwaysNamed;
    public static BoolEntry villagersAlwaysNamed;
    public static BoolEntry golemsAlwaysNamed;
    public static BoolEntry applyToScores;
    public static BoolEntry stripFormat;
    public static BoolEntry seeFrameNames;
    public static BoolEntry namesWithoutHUD;
    public static IntEntry visibleRange;
    public static IntEntry nameMaxR;
    public static IntEntry nameMaxG;
    public static IntEntry nameMaxB;
    public static IntEntry nameMaxA;
    public static IntEntry nameMinR;
    public static IntEntry nameMinG;
    public static IntEntry nameMinB;
    public static IntEntry nameMinA;
    public static IntEntry plateMaxR;
    public static IntEntry plateMaxG;
    public static IntEntry plateMaxB;
    public static IntEntry plateMaxA;
    public static IntEntry plateMinR;
    public static IntEntry plateMinG;
    public static IntEntry plateMinB;
    public static IntEntry plateMinA;
    public static BoolEntry doValentines;
    public static BoolEntry doAprilFools;
    public static Class<?> playerClass;
    public static int visibleRangeSq;
    public static float nameMaxV;
    public static float nameMinV;
    public static float plateMaxV;
    public static float plateMinV;

    public static void load() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("namepain-client.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        CONFIG_SPEC.setConfig((CommentedConfig)configData);
    }

    private static ForgeConfigSpec specBuilder(ForgeConfigSpec.Builder builder) {
        applyToPlayers = new BoolEntry("applyToPlayers", false, true);
        playersAlwaysNamed = new BoolEntry("playersAlwaysNamed", true, true);
        seeYourName = new BoolEntry("seeYourName", false, false);
        applyToMobs = new BoolEntry("applyToMobs", false, true);
        seeInjuredNames = new BoolEntry("seeInjuredNames", false, false);
        injuredAlwaysNamed = new BoolEntry("injuredAlwaysNamed", false, false);
        tamesAlwaysNamed = new BoolEntry("tamesAlwaysNamed", false, true);
        horsesAlwaysNamed = new BoolEntry("horsesAlwaysNamed", false, false);
        villagersAlwaysNamed = new BoolEntry("villagersAlwaysNamed", false, true);
        golemsAlwaysNamed = new BoolEntry("golemsAlwaysNamed", false, true);
        applyToScores = new BoolEntry("applyToScores", false, false);
        stripFormat = new BoolEntry("stripFormat", false, false);
        seeFrameNames = new BoolEntry("seeFrameNames", true, true);
        namesWithoutHUD = new BoolEntry("namesWithoutHUD", false, false);
        visibleRange = new IntEntry("visibleRange", 64, 64, 0, 64);
        int rgba_min = 0;
        int rgba_max = 255;
        nameMaxR = new IntEntry("nameMaxR", 255, 255, rgba_min, rgba_max);
        nameMaxG = new IntEntry("nameMaxG", 255, 255, rgba_min, rgba_max);
        nameMaxB = new IntEntry("nameMaxB", 255, 255, rgba_min, rgba_max);
        nameMaxA = new IntEntry("nameMaxA", 255, 255, rgba_min, rgba_max);
        nameMinR = new IntEntry("nameMinR", 255, 255, rgba_min, rgba_max);
        nameMinG = new IntEntry("nameMinG", 255, 0, rgba_min, rgba_max);
        nameMinB = new IntEntry("nameMinB", 255, 0, rgba_min, rgba_max);
        nameMinA = new IntEntry("nameMinA", 255, 255, rgba_min, rgba_max);
        plateMaxR = new IntEntry("plateMaxR", 0, 0, rgba_min, rgba_max);
        plateMaxG = new IntEntry("plateMaxG", 0, 0, rgba_min, rgba_max);
        plateMaxB = new IntEntry("plateMaxB", 0, 0, rgba_min, rgba_max);
        plateMaxA = new IntEntry("plateMaxA", 64, 64, rgba_min, rgba_max);
        plateMinR = new IntEntry("plateMinR", 0, 192, rgba_min, rgba_max);
        plateMinG = new IntEntry("plateMinG", 0, 0, rgba_min, rgba_max);
        plateMinB = new IntEntry("plateMinB", 0, 0, rgba_min, rgba_max);
        plateMinA = new IntEntry("plateMinA", 64, 64, rgba_min, rgba_max);
        doValentines = new BoolEntry("doValentines", false, true, Config.isValentines());
        doAprilFools = new BoolEntry("doAprilFools", false, true, Config.isAprilFools());
        ForgeConfigSpec spec = builder.build();
        Config.cacheConfig();
        return spec;
    }

    public static void cacheConfig() {
        applyToPlayers.update();
        playersAlwaysNamed.update();
        playerClass = seeYourName.update() ? AbstractClientPlayer.class : RemotePlayer.class;
        applyToMobs.update();
        seeInjuredNames.update();
        injuredAlwaysNamed.update();
        tamesAlwaysNamed.update();
        horsesAlwaysNamed.update();
        villagersAlwaysNamed.update();
        golemsAlwaysNamed.update();
        applyToScores.update();
        stripFormat.update();
        seeFrameNames.update();
        namesWithoutHUD.update();
        visibleRangeSq = (int)Math.pow(visibleRange.update(), 2.0);
        nameMaxA.update();
        nameMaxV = Util.getVibrancy(nameMaxR.update(), nameMaxG.update(), nameMaxB.update());
        nameMinA.update();
        nameMinV = Util.getVibrancy(nameMinR.update(), nameMinG.update(), nameMinB.update());
        plateMaxA.update();
        plateMaxV = Util.getVibrancy(plateMaxR.update(), plateMaxG.update(), plateMaxB.update());
        plateMinA.update();
        plateMinV = Util.getVibrancy(plateMinR.update(), plateMinG.update(), plateMinB.update());
        doValentines.update();
        doAprilFools.update();
    }

    @SubscribeEvent
    public static void onPause(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof ModListScreen) {
            Config.load();
            Config.cacheConfig();
        }
    }

    public static boolean isValentines() {
        return MonthDay.now().getMonthValue() == 2 && MonthDay.now().getDayOfMonth() == 14;
    }

    public static boolean isAprilFools() {
        return MonthDay.now().getMonthValue() == 4 && MonthDay.now().getDayOfMonth() == 1;
    }

    public static class BoolEntry {
        String name;
        boolean vanilla;
        boolean defawlt;
        boolean visible;
        ForgeConfigSpec.BooleanValue value;
        boolean cache;

        BoolEntry(String name, boolean vanilla, boolean defawlt) {
            this(name, vanilla, defawlt, true);
        }

        BoolEntry(String name, boolean vanilla, boolean defawlt, boolean visible) {
            this.name = name;
            this.vanilla = vanilla;
            this.defawlt = defawlt;
            this.visible = visible;
            this.value = visible ? SPEC_BUILDER.define(name, defawlt) : null;
        }

        public boolean update() {
            this.cache = this.visible ? (Boolean)this.value.get() : this.vanilla;
            return this.cache;
        }

        public boolean get() {
            return this.cache;
        }

        public String key() {
            return "config.namepain." + this.name;
        }
    }

    public static class IntEntry {
        String name;
        int vanilla;
        int defawlt;
        int min;
        int max;
        boolean visible;
        ForgeConfigSpec.IntValue value;
        int cache;

        IntEntry(String name, int vanilla, int defawlt, int min, int max) {
            this(name, vanilla, defawlt, min, max, true);
        }

        IntEntry(String name, int vanilla, int defawlt, int min, int max, boolean visible) {
            this.name = name;
            this.vanilla = vanilla;
            this.defawlt = defawlt;
            this.min = min;
            this.max = max;
            this.visible = visible;
            this.value = visible ? SPEC_BUILDER.defineInRange(name, defawlt, min, max) : null;
        }

        public int update() {
            this.cache = this.visible ? (Integer)this.value.get() : this.vanilla;
            return this.cache;
        }

        public int get() {
            return this.cache;
        }

        public String key() {
            return "config.namepain." + this.name;
        }
    }
}

