/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageJumpToAbilitySection {

    public static class MessageJumpToAbilitySectionClientToServer {
        private int index;
        private int sectionIndex;

        public MessageJumpToAbilitySectionClientToServer() {
        }

        public MessageJumpToAbilitySectionClientToServer(int index, int sectionIndex) {
            this.index = index;
            this.sectionIndex = sectionIndex;
        }

        public static void serialize(MessageJumpToAbilitySectionClientToServer message, FriendlyByteBuf buf) {
            buf.m_130130_(message.index);
            buf.m_130130_(message.sectionIndex);
        }

        public static MessageJumpToAbilitySectionClientToServer deserialize(FriendlyByteBuf buf) {
            MessageJumpToAbilitySectionClientToServer message = new MessageJumpToAbilitySectionClientToServer();
            message.index = buf.m_130242_();
            message.sectionIndex = buf.m_130242_();
            return message;
        }

        public static class Handler
        implements BiConsumer<MessageJumpToAbilitySectionClientToServer, Supplier<NetworkEvent.Context>> {
            @Override
            public void accept(MessageJumpToAbilitySectionClientToServer message, Supplier<NetworkEvent.Context> contextSupplier) {
                NetworkEvent.Context context = contextSupplier.get();
                ServerPlayer player = context.getSender();
                context.enqueueWork(() -> {
                    AbilityCapability.IAbilityCapability abilityCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.ABILITY_CAPABILITY);
                    if (abilityCapability != null) {
                        AbilityType<?, ?> abilityType = abilityCapability.getAbilityTypesOnEntity((LivingEntity)player)[message.index];
                        Ability instance = abilityCapability.getAbilityMap().get(abilityType);
                        if (instance.isUsing()) {
                            instance.jumpToSection(message.sectionIndex);
                        }
                    }
                });
                context.setPacketHandled(true);
            }
        }
    }

    public static class MessageJumpToAbilitySectionServerToClient {
        private int entityID;
        private int index;
        private int sectionIndex;

        public MessageJumpToAbilitySectionServerToClient() {
        }

        public MessageJumpToAbilitySectionServerToClient(int entityID, int index, int sectionIndex) {
            this.entityID = entityID;
            this.index = index;
            this.sectionIndex = sectionIndex;
        }

        public static void serialize(MessageJumpToAbilitySectionServerToClient message, FriendlyByteBuf buf) {
            buf.m_130130_(message.entityID);
            buf.m_130130_(message.index);
            buf.m_130130_(message.sectionIndex);
        }

        public static MessageJumpToAbilitySectionServerToClient deserialize(FriendlyByteBuf buf) {
            MessageJumpToAbilitySectionServerToClient message = new MessageJumpToAbilitySectionServerToClient();
            message.entityID = buf.m_130242_();
            message.index = buf.m_130242_();
            message.sectionIndex = buf.m_130242_();
            return message;
        }

        public static class Handler
        implements BiConsumer<MessageJumpToAbilitySectionServerToClient, Supplier<NetworkEvent.Context>> {
            @Override
            public void accept(MessageJumpToAbilitySectionServerToClient message, Supplier<NetworkEvent.Context> contextSupplier) {
                NetworkEvent.Context context = contextSupplier.get();
                context.enqueueWork(() -> {
                    AbilityCapability.IAbilityCapability abilityCapability;
                    LivingEntity entity = (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                    if (entity != null && (abilityCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.ABILITY_CAPABILITY)) != null) {
                        AbilityType<?, ?> abilityType = abilityCapability.getAbilityTypesOnEntity(entity)[message.index];
                        Ability instance = abilityCapability.getAbilityMap().get(abilityType);
                        if (instance.isUsing()) {
                            instance.jumpToSection(message.sectionIndex);
                        }
                    }
                });
                context.setPacketHandled(true);
            }
        }
    }
}

