/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.bluff;

import com.bobmowzie.mowziesmobs.client.particle.AdvancedTerrainParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.TerrainParticleData;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.DieAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.HurtAbility;
import com.bobmowzie.mowziesmobs.server.ai.UseAbilityAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityFissure;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EntityBluff
extends MowzieGeckoEntity {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] feetPos;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] corePos;
    private GroundPathNavigation groundNav;
    private MoveControl groundMoveControl;
    private FlyingPathNavigation flyingNav;
    private FlyingMoveControl flyingMoveControl;
    public static final AbilityType<EntityBluff, HurtAbility<EntityBluff>> HURT_ABILITY = new AbilityType<EntityBluff, HurtAbility>("bluff_hurt", (type, entity) -> new HurtAbility<EntityBluff>(type, (EntityBluff)entity, RawAnimation.begin().thenPlay("hurt"), 7, 0));
    public static final AbilityType<EntityBluff, DieAbility<EntityBluff>> DIE_ABILITY = new AbilityType<EntityBluff, DieAbility>("bluff_die", (type, entity) -> new DieAbility<EntityBluff>(type, (EntityBluff)entity, RawAnimation.begin().thenPlay("death"), 50));
    public static final AbilityType<EntityBluff, BluffAttackAbility> ATTACK_ABILITY = new AbilityType<EntityBluff, BluffAttackAbility>("bluff_attack", BluffAttackAbility::new);

    public EntityBluff(EntityType<? extends MowzieEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 14;
        this.groundMoveControl = this.f_21342_;
        this.flyingMoveControl = new FlyingMoveControl((Mob)this, 10, true);
        if (world.f_46443_) {
            this.feetPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.corePos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    public AbilityType getHurtAbility() {
        return HURT_ABILITY;
    }

    @Override
    public AbilityType getDeathAbility() {
        return DIE_ABILITY;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)MMSounds.ENTITY_BLUFF_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        this.m_5496_((SoundEvent)MMSounds.ENTITY_BLUFF_DEATH.get(), 1.0f, 1.1f);
        return null;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MMSounds.ENTITY_BLUFF_IDLE.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityBluff>(this, ATTACK_ABILITY));
        this.f_21345_.m_25352_(1, new UseAbilityAI<EntityBluff>(this, DIE_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntityBluff>(this, HURT_ABILITY, false));
        this.f_21345_.m_25352_(3, (Goal)new BluffNoPathGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BluffAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this, new Class[0]){

            protected boolean m_26150_(@Nullable LivingEntity entity, TargetingConditions conditions) {
                return !(entity instanceof EntityBluff) && super.m_26150_(entity, conditions);
            }
        }.m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, EntitySculptor.class, true));
    }

    @Override
    protected <E extends GeoEntity> void loopingAnimations(AnimationState<E> event) {
        super.loopingAnimations(event);
        event.getController().transitionLength(5);
    }

    @Override
    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[]{HURT_ABILITY, DIE_ABILITY, ATTACK_ABILITY};
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22280_, (double)0.23f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected PathNavigation m_6037_(Level level) {
        this.groundNav = new GroundPathNavigation((Mob)this, level){

            protected boolean m_7632_() {
                return super.m_7632_() || EntityBluff.this.f_21344_ == EntityBluff.this.flyingNav;
            }
        };
        this.flyingNav = new FlyingPathNavigation((Mob)this, level);
        return this.groundNav;
    }

    public void setFlying(boolean flying) {
        if (flying) {
            this.f_21342_ = this.flyingMoveControl;
            this.f_21344_ = this.flyingNav;
            this.m_20242_(true);
        } else {
            this.f_21342_ = this.groundMoveControl;
            this.f_21344_ = this.groundNav;
            this.m_20242_(false);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
        if (this.getActiveAbilityType() == DIE_ABILITY && this.getActiveAbility().getTicksInUse() < 14) {
            this.f_20883_ = this.f_20885_ = this.f_19859_;
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 4; ++i) {
                    if (!(this.f_19796_.m_188501_() < 0.1f)) continue;
                    AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.m_20208_(0.4f), this.m_20186_() + 1.0, this.m_20262_(0.4f), 0.0, this.f_19796_.m_188501_() / 15.0f, 0.0, true, 0.0, 0.0, 0.0, 0.0, 1.3 + (double)(this.f_19796_.m_188501_() * 1.0f), 0.63671875, 0.96484375, 0.2890625, 0.5, 0.9, 17.0f + this.f_19796_.m_188501_() * 10.0f, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{1.0f, 0.0f}, new float[]{0.0f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.MOTION_Y, new ParticleComponent.KeyTrack(new float[]{0.1f, 0.0f}, new float[]{0.0f, 1.0f}), false)});
                }
            }
        }
        if (this.m_9236_().f_46443_ && this.m_6084_()) {
            BlockState state;
            if (this.feetPos != null && this.feetPos.length > 0) {
                this.feetPos[0] = this.m_20182_().m_82520_(0.0, (double)0.05f, 0.0);
                if (this.f_19797_ % 4 == 0) {
                    AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), this.feetPos[0].m_7096_(), this.feetPos[0].m_7098_(), this.feetPos[0].m_7094_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 1.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 20.0, true, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.feetPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(1.0f, 7.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.KeyTrack.startAndEnd(0.0f, 1.5f), true)});
                }
            }
            if (EffectGeomancy.isBlockUseable(state = this.m_9236_().m_8055_(this.m_20097_())) && this.feetPos != null && this.feetPos.length > 0 && this.f_19797_ % 2 == 0) {
                Vec3 pos = new Vec3(1.0, 0.0, 0.0).m_82524_((float)(this.f_19796_.m_188500_() * Math.PI * 2.0)).m_82490_((double)this.f_19796_.m_188501_());
                float phaseOffset = this.f_19796_.m_188501_();
                float scale = (float)this.f_19796_.m_188583_() * 0.2f + 0.3f;
                AdvancedTerrainParticle.spawnTerrainParticle(this.m_9236_(), (ParticleType<TerrainParticleData>)((ParticleType)ParticleHandler.TERRAIN.get()), this.m_20185_() + pos.m_7096_(), this.m_20186_() + pos.m_7098_() + 1.0, this.m_20189_() + pos.m_7094_(), 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 25.0f + this.f_19796_.m_188501_() * 5.0f, state, new ParticleComponent[]{new ParticleComponent.Orbit(this.feetPos, ParticleComponent.KeyTrack.startAndEnd(0.0f + phaseOffset, 0.8f + phaseOffset), ParticleComponent.KeyTrack.startAndEnd(this.f_19796_.m_188501_() * 0.75f, 0.1f + this.f_19796_.m_188501_()), ParticleComponent.constant(0.0f), ParticleComponent.constant(1.0f), ParticleComponent.constant(0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.KeyTrack.startAndEnd(0.0f, 1.1f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, scale, scale, 0.0f}, new float[]{0.0f, 0.1f, 0.9f, 1.0f}), false)});
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (source == this.m_269291_().m_268989_()) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        super.m_8107_();
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.BLUFF;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        return super.m_5545_(world, reason) && this.getEntitiesNearby(EntitySculptor.class, 8.0, 8.0, 8.0, 8.0).isEmpty() && world.m_46791_() != Difficulty.PEACEFUL;
    }

    protected void m_7840_(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public static class BluffNoPathGoal
    extends Goal {
        private final EntityBluff bluff;

        public BluffNoPathGoal(EntityBluff bluff) {
            this.bluff = bluff;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.bluff.m_5448_();
            if (target == null) {
                return false;
            }
            if (!this.bluff.m_20096_()) {
                return false;
            }
            Path path = this.bluff.groundNav.m_6570_((Entity)target, 0);
            return path == null || path.m_77395_() == null || path.m_77395_().m_164701_().m_82520_(0.5, 0.5, 0.5).m_82557_(path.m_77406_().m_252807_()) > 4.0;
        }

        public boolean m_8045_() {
            LivingEntity target = this.bluff.m_5448_();
            if (target == null) {
                return false;
            }
            Path path = this.bluff.groundNav.m_6570_((Entity)target, 0);
            return path == null || path.m_77395_() == null || path.m_77395_().m_164701_().m_82520_(0.5, 0.5, 0.5).m_82557_(path.m_77406_().m_252807_()) > 4.0;
        }

        public void m_8056_() {
            super.m_8056_();
            this.bluff.setFlying(true);
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.bluff.m_5448_();
            if (target != null) {
                this.bluff.m_21573_().m_5624_((Entity)target, 1.2);
                this.bluff.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.bluff.m_21573_().m_26573_();
            this.bluff.setFlying(false);
        }
    }

    static class BluffAttackGoal
    extends Goal {
        private final EntityBluff bluff;
        private final double speedModifier = 1.0;
        private int attackIntervalMin = 80;
        private final float attackMaxRadiusSqr = 144.0f;
        private final float attackMinRadiusSqr = 36.0f;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private boolean isStrafing;
        private int strafingTime = -1;

        public BluffAttackGoal(EntityBluff bluff) {
            this.bluff = bluff;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.bluff.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.bluff.m_6779_(livingentity);
        }

        public void m_8056_() {
            super.m_8056_();
            this.bluff.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.bluff.m_21561_(false);
            this.seeTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.bluff.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.bluff.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.bluff.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                Objects.requireNonNull(this);
                if (!(d0 > 144.0) && this.seeTime >= 20) {
                    this.bluff.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.bluff.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.bluff.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.isStrafing = !this.isStrafing;
                    }
                    if ((double)this.bluff.m_217043_().m_188501_() < 0.3) {
                        boolean bl3 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.bluff.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    Objects.requireNonNull(this);
                    if (d0 > 144.0) {
                        this.strafingBackwards = false;
                    } else {
                        Objects.requireNonNull(this);
                        if (d0 < 36.0) {
                            this.strafingBackwards = true;
                        }
                    }
                    if (this.isStrafing) {
                        this.bluff.m_21566_().m_24988_(this.strafingBackwards ? -0.3f : 0.3f, this.strafingClockwise ? 0.3f : -0.3f);
                    } else {
                        this.bluff.m_21566_().m_24988_(0.0f, 0.0f);
                    }
                    this.bluff.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                }
                this.bluff.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                if (--this.attackTime <= 0 && this.seeTime >= -60 && d0 < 144.0) {
                    this.bluff.sendAbilityMessage(ATTACK_ABILITY);
                    this.attackTime = this.attackIntervalMin + this.bluff.f_19796_.m_188503_(40);
                }
            }
        }
    }

    public static class BluffAttackAbility
    extends Ability<EntityBluff> {
        private static int STARTUP_DURATION = 9;
        private Vec3 prevTargetPos;
        public static AbilitySection[] SECTION_TRACK = new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 11), new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.MISC), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 34)};
        private static final RawAnimation ATTACK_START_ANIMATION = RawAnimation.begin().then("attack_start", Animation.LoopType.HOLD_ON_LAST_FRAME);
        private static final RawAnimation ATTACK_END_ANIMATION = RawAnimation.begin().then("attack_end", Animation.LoopType.HOLD_ON_LAST_FRAME);

        public BluffAttackAbility(AbilityType abilityType, EntityBluff user) {
            super(abilityType, user, SECTION_TRACK);
        }

        @Override
        public void start() {
            super.start();
            ((EntityBluff)this.getUser()).setFlying(false);
            LivingEntity entityTarget = ((EntityBluff)this.getUser()).m_5448_();
            if (entityTarget != null) {
                this.prevTargetPos = entityTarget.m_20182_().m_82520_(0.0, (double)entityTarget.m_20206_() / 2.0, 0.0);
            }
            this.playAnimation(ATTACK_START_ANIMATION);
            ((EntityBluff)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_BLUFF_ATTACK.get(), 1.0f, 1.2f);
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            LivingEntity entityTarget = ((EntityBluff)this.getUser()).m_5448_();
            if (entityTarget != null) {
                ((EntityBluff)this.getUser()).m_21563_().m_24960_((Entity)entityTarget, 30.0f, 30.0f);
                ((EntityBluff)this.getUser()).m_146922_(((EntityBluff)this.getUser()).m_6080_());
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                ((EntityBluff)this.getUser()).m_20334_(0.0, 0.0, 0.0);
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.MISC || this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                double fallSpeed = ((EntityBluff)this.getUser()).m_20184_().f_82480_;
                fallSpeed -= 2.0;
                fallSpeed = Math.max(fallSpeed, -7.0);
                ((EntityBluff)this.getUser()).m_20334_(0.0, fallSpeed, 0.0);
                ((EntityBluff)this.getUser()).f_19812_ = true;
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.MISC && ((EntityBluff)this.getUser()).m_20096_()) {
                this.jumpToSection(2);
            }
        }

        @Override
        public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                e.getController().transitionLength(4);
            }
            return super.animationPredicate(e, perspective);
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                ((EntityBluff)this.getUser()).m_5496_((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM.get(0)).get(), 1.0f, 1.2f);
                if (!this.getLevel().m_5776_()) {
                    this.shootFissureAtTarget(((EntityBluff)this.getUser()).m_5448_(), this.prevTargetPos, 0.1f);
                    List entitiesHit = this.getLevel().m_6249_(this.getUser(), ((EntityBluff)this.getUser()).m_20191_().m_82400_(0.4), e -> e != this.getUser());
                    double damage = 10.0;
                    AttributeInstance attrib = ((EntityBluff)this.getUser()).m_21051_(Attributes.f_22281_);
                    if (attrib != null) {
                        damage = attrib.m_22135_();
                    }
                    damage *= ((Double)ConfigHandler.COMMON.MOBS.BLUFF.combatConfig.attackMultiplier.get()).doubleValue();
                    for (Entity entity : entitiesHit) {
                        if (entity instanceof EntityBluff) continue;
                        entity.m_6469_(((EntityBluff)this.getUser()).m_269291_().m_269333_(this.getUser()), (float)damage);
                    }
                }
                this.playAnimation(ATTACK_END_ANIMATION);
                if (this.getLevel().m_5776_()) {
                    BlockState blockBeneath = ((EntityBluff)this.getUser()).m_9236_().m_8055_(((EntityBluff)this.getUser()).m_20097_());
                    for (int i = 0; i < 30; i = (int)((byte)(i + 1))) {
                        this.getLevel().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockBeneath), ((EntityBluff)this.getUser()).m_20185_(), (double)((float)((EntityBluff)this.getUser()).m_146904_() + 0.1f), ((EntityBluff)this.getUser()).m_20189_(), (double)(((EntityBluff)this.getUser()).f_19796_.m_188501_() * 3.0f - 1.5f), 2.2, (double)(((EntityBluff)this.getUser()).f_19796_.m_188501_() * 3.0f - 1.5f));
                    }
                }
            }
        }

        public void shootFissureAtTarget(LivingEntity target, Vec3 prevTargetPos, float timeScale) {
            Vec3 shootVec;
            EntityFissure fissure = new EntityFissure((EntityType<? extends EntityFissure>)((EntityType)EntityHandler.FISSURE.get()), this.getLevel());
            fissure.m_5602_((Entity)this.getUser());
            fissure.m_146884_(((EntityBluff)this.getUser()).m_20182_());
            if (target != null) {
                float speed = 2.0f / (float)EntityFissure.TICKS_PER_PIECE;
                Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0);
                double timeToReach = fissure.m_20182_().m_82546_(targetPos).m_82553_() / (double)speed;
                Vec3 targetMovement = targetPos.m_82546_(prevTargetPos).m_82490_(timeToReach * (double)timeScale * 1.0 / 4.0);
                targetMovement = targetMovement.m_82542_(1.0, 0.0, 1.0);
                Vec3 futureTargetPos = targetPos.m_82549_(targetMovement);
                Vec3 projectileMid = fissure.m_20182_().m_82520_(0.0, (double)fissure.m_20206_() / 2.0, 0.0);
                shootVec = futureTargetPos.m_82546_(projectileMid).m_82541_();
            } else {
                shootVec = ((EntityBluff)this.getUser()).m_20156_();
            }
            fissure.shoot(shootVec.f_82479_, shootVec.f_82481_);
            this.getLevel().m_7967_((Entity)fissure);
        }
    }
}

