/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.moboptimizer;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="moboptimizer", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobOptimizerConfig {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.DoubleValue MAX_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue SEARCH_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue CELL_SIZE;
    public static final ForgeConfigSpec.IntValue TICK_INTERVAL;

    public static void registerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    static {
        ForgeConfigSpec.Builder serverBuilder = new ForgeConfigSpec.Builder();
        MAX_DISTANCE = serverBuilder.comment("Maximum distance to disable AI for mobs").defineInRange("maxDistance", 100.0, 100.0, 500.0);
        SEARCH_DISTANCE = serverBuilder.comment("Search distance around players for checking mob AI").defineInRange("searchDistance", 150.0, 150.0, 600.0);
        TICK_INTERVAL = serverBuilder.comment("Tick interval for checking mob AI status").defineInRange("tickInterval", 50, 50, 600);
        CELL_SIZE = serverBuilder.comment("Size of the cell for grouping mobs").defineInRange("cellSize", 16.0, 16.0, 32.0);
        SERVER_CONFIG = serverBuilder.build();
    }
}

