/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.moboptimizer;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.talesstudio.moboptimizer.MobAIHandler;
import net.talesstudio.moboptimizer.MobOptimizerConfig;
import org.slf4j.Logger;

@Mod(value="moboptimizer")
public class MobOptimizer {
    public static final String MODID = "moboptimizer";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MobOptimizer() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MobOptimizerConfig.registerConfig();
        modEventBus.addListener(this::commonSetup);
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> MobAIHandler::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Start setup for MobOptimizer.");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server start");
    }

    @Mod.EventBusSubscriber(modid="moboptimizer", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Start client's options for MobOptimizer.");
        }
    }
}

