/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.bow;

import com.github.mim1q.minecells.effect.BleedingStatusEffect;
import com.github.mim1q.minecells.entity.damage.MineCellsDamageSource;
import com.github.mim1q.minecells.entity.nonliving.projectile.CustomArrowEntity;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import com.github.mim1q.minecells.world.MineCellsExplosion;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;

public class CustomArrowType {
    private static final HashMap<String, CustomArrowType> arrowTypes = new HashMap();
    public static final CustomArrowType DEFAULT = CustomArrowType.create("default");
    public static final CustomArrowType MARKSMAN = CustomArrowType.create("marksman", it -> {
        it.speed = 3.0f;
        it.defaultDamage = 5.0f;
        it.additionalCritDamage = 11.0f;
        it.shouldCrit = context -> {
            double distanceSq = context.shotFromPos.method_1025(context.hitPos);
            return distanceSq > 576.0;
        };
    });
    public static final CustomArrowType INFANTRY = CustomArrowType.create("infantry", it -> {
        it.defaultDamage = 6.0f;
        it.additionalCritDamage = 6.0f;
        it.shouldCrit = context -> {
            double distanceSq = context.shotFromPos.method_1025(context.hitPos);
            return distanceSq < 100.0;
        };
    });
    public static final CustomArrowType ICE = CustomArrowType.create("ice", it -> {
        it.defaultDamage = 4.0f;
        it.onEntityHit = context -> context.target.method_6092(new class_1293(MineCellsStatusEffects.FROZEN, 100));
        it.particle = class_2398.field_28013;
        it.ammo = () -> MineCellsItems.ICE_ARROW;
    });
    public static final CustomArrowType EXPLOSIVE_BOLT = CustomArrowType.create("explosive_bolt", it -> {
        it.defaultDamage = 0.0f;
        it.onBlockHit = context -> {
            MineCellsExplosion.explode(context.world, (class_1297)context.arrow, (class_1309)context.shooter, context.hitPos, 10.0f, 4.0f, Objects::nonNull);
            context.arrow.method_31472();
        };
        it.onEntityHit = context -> {
            MineCellsExplosion.explode(context.world, (class_1297)context.arrow, (class_1309)context.shooter, context.hitPos, 10.0f, 4.0f, Objects::nonNull);
            context.arrow.method_31472();
        };
        it.particle = class_2398.field_11251;
        it.ammo = () -> MineCellsItems.EXPLOSIVE_BOLT;
    });
    public static final CustomArrowType QUICK = CustomArrowType.create("quick", it -> {
        it.speed = 2.2f;
        it.defaultDamage = 6.0f;
        it.drawTime = 6;
        it.spread = 3.0f;
        it.damageSourceFactory = (world, arrow, shooter) -> MineCellsDamageSource.HEAVY_BOLT.get(world, (class_1297)shooter);
    });
    public static final CustomArrowType NERVES_OF_STEEL = CustomArrowType.create("nerves_of_steel", it -> {
        it.drawTime = 10;
        it.defaultDamage = 5.0f;
        it.additionalCritDamage = 9.0f;
        it.shouldCrit = context -> {
            class_2487 nbt = context.bow().method_7948();
            return nbt.method_10577("crit");
        };
    });
    public static final CustomArrowType HEAVY_BOLT = CustomArrowType.create("heavy_bolt", it -> {
        it.defaultDamage = 4.0f;
        it.drawTime = 35;
        it.speed = 0.6f;
        it.maxAge = 10;
        it.spread = 45.0f;
        it.damageSourceFactory = (world, arrow, shooter) -> MineCellsDamageSource.HEAVY_BOLT.get(world, (class_1297)shooter);
    });
    public static final CustomArrowType MULTIPLE_NOCKS = CustomArrowType.create("multiple_nocks", it -> {});
    public static final CustomArrowType ENDLESS = CustomArrowType.create("endless", it -> {
        it.ammo = () -> null;
    });
    public static final CustomArrowType FIREBRANDS = CustomArrowType.create("firebrands", it -> {
        it.defaultDamage = 4.0f;
        it.speed = 1.0f;
        it.onEntityHit = context -> context.target.method_5639(5);
        it.onBlockHit = context -> {
            CustomArrowType.placeFire(context);
            context.arrow.method_31472();
        };
        it.particle = class_2398.field_11240;
        it.cooldown = 20;
    });
    public static final CustomArrowType THROWING_KNIFE = CustomArrowType.create("throwing_knife", it -> {
        it.defaultDamage = 4.0f;
        it.speed = 1.75f;
        it.spread = 0.5f;
        it.onEntityHit = context -> BleedingStatusEffect.apply(context.target, 80);
        it.cooldown = 5;
        it.ammo = () -> MineCellsItems.THROWING_KNIFE;
        it.damageSourceFactory = (world, arrow, shooter) -> MineCellsDamageSource.HEAVY_BOLT.get(world, (class_1297)shooter);
    });
    private final String name;
    private float defaultDamage = 5.0f;
    private float additionalCritDamage = 0.0f;
    private int drawTime = 20;
    private float speed = 2.0f;
    private int maxAge = 1200;
    private float spread = 1.0f;
    private class_2394 particle = null;
    private Consumer<ArrowEntityHitContext> onEntityHit = context -> {};
    private Consumer<ArrowBlockHitContext> onBlockHit = context -> {};
    private Function<ArrowEntityHitContext, Boolean> shouldCrit = context -> false;
    private DamageSourceFactory damageSourceFactory = (world, arrow, shooter) -> world.method_48963().method_48800((class_1297)arrow, shooter);
    private int cooldown = 0;
    private Supplier<class_1792> ammo = () -> class_1802.field_8107;
    private final String translationKey;

    private static void placeFire(ArrowBlockHitContext context) {
        class_2338 blockPos = context.hitBlockPos().method_10081(context.hitFace().method_10163());
        class_2680 fireState = class_2246.field_10036.method_9605(new class_1750(context.shooter(), context.shooter().method_6058(), context.bow(), new class_3965(context.hitPos(), context.hitFace(), context.hitBlockPos(), false)));
        if (context.world.method_8320(blockPos).method_45474()) {
            context.world.method_8501(blockPos, fireState);
        }
    }

    private CustomArrowType(String name) {
        this.name = name;
        this.translationKey = "entity.minecells.custom_arrow." + name;
    }

    public void onEntityHit(ArrowEntityHitContext context) {
        this.onEntityHit.accept(context);
    }

    public void onBlockHit(ArrowBlockHitContext context) {
        this.onBlockHit.accept(context);
    }

    public int getDrawTime() {
        return this.drawTime;
    }

    public boolean shouldCrit(ArrowEntityHitContext context) {
        return this.shouldCrit.apply(context);
    }

    public float getDamage() {
        return this.defaultDamage;
    }

    public float getAdditionalCritDamage() {
        return this.additionalCritDamage;
    }

    public String getName() {
        return this.name;
    }

    public class_2394 getParticle() {
        return this.particle;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public float getSpread() {
        return this.spread;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public Optional<class_1792> getAmmoItem() {
        return Optional.ofNullable(this.ammo.get());
    }

    public class_1282 getDamageSource(class_1937 world, CustomArrowEntity arrow, class_1309 shooter) {
        return this.damageSourceFactory.create(world, arrow, shooter);
    }

    public class_2561 getTranslation() {
        return class_2561.method_43471((String)this.translationKey);
    }

    protected static CustomArrowType create(String name, Consumer<CustomArrowType> setup) {
        CustomArrowType arrowType = new CustomArrowType(name);
        setup.accept(arrowType);
        arrowTypes.put(name, arrowType);
        return arrowType;
    }

    protected static CustomArrowType create(String name) {
        return CustomArrowType.create(name, it -> {});
    }

    public static CustomArrowType get(String name) {
        return arrowTypes.getOrDefault(name, DEFAULT);
    }

    public static Set<String> getAllNames() {
        return arrowTypes.keySet();
    }

    public record ArrowBlockHitContext(class_3218 world, class_1799 bow, class_1657 shooter, class_243 shotFromPos, class_2338 hitBlockPos, class_243 hitPos, class_2350 hitFace, CustomArrowEntity arrow) {
    }

    @FunctionalInterface
    public static interface DamageSourceFactory {
        public class_1282 create(class_1937 var1, CustomArrowEntity var2, class_1309 var3);
    }

    public record ArrowEntityHitContext(class_3218 world, class_1799 bow, class_1657 shooter, class_1309 target, class_243 shotFromPos, class_243 hitPos, CustomArrowEntity arrow) {
    }
}

