/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.nonliving;

import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.joml.Vector3f;

public class TentacleWeaponEntity
extends class_1297 {
    private class_243 startingPos;
    private class_1657 owner;
    private boolean pulling = false;
    private static final class_2940<Boolean> RETRACTING = class_2945.method_12791(TentacleWeaponEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Vector3f> TARGET_POS = class_2945.method_12791(TentacleWeaponEntity.class, (class_2941)class_2943.field_42237);
    private final AnimationProperty length = new AnimationProperty(0.0f, MathUtils::easeOutQuad);

    public TentacleWeaponEntity(class_1299<TentacleWeaponEntity> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;
    }

    public static TentacleWeaponEntity create(class_1937 world, class_1657 owner, class_243 targetPos) {
        TentacleWeaponEntity entity = (TentacleWeaponEntity)MineCellsEntities.TENTACLE_WEAPON.method_5883(world);
        if (entity == null) {
            return null;
        }
        entity.owner = owner;
        entity.method_23327(owner.method_23317(), owner.method_23318() + 1.5, owner.method_23321());
        entity.setTargetPos(targetPos);
        entity.startingPos = entity.method_19538();
        entity.method_5873((class_1297)owner, true);
        return entity;
    }

    public void method_5773() {
        super.method_5773();
        if (this.isRetracting()) {
            this.length.setupTransitionTo(0.0f, 10.0f);
        } else {
            this.length.setupTransitionTo(1.0f, 10.0f);
        }
        if (this.method_37908().field_9236) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    public void tickClient() {
    }

    public void tickServer() {
        if (this.owner == null || !this.method_5765()) {
            this.method_31472();
            return;
        }
        if (this.isRetracting()) {
            float length = this.getLength(0.0f);
            if (length >= 0.01f) {
                this.pullOwner();
            }
            this.owner.field_6017 = 0.0f;
            if (length <= 0.01f && this.field_6012 > 30) {
                this.method_31472();
            }
        } else {
            List entitiesHit = this.method_37908().method_8333((class_1297)this, class_238.method_30048((class_243)this.getEndPos(this.getLength(1.0f)), (double)0.75, (double)0.75, (double)0.75), entity -> entity != this.owner);
            Iterator iterator = entitiesHit.iterator();
            if (iterator.hasNext()) {
                class_1297 entity2 = (class_1297)iterator.next();
                this.method_5783(MineCellsSounds.TENTACLE_RELEASE, 0.5f, 1.0f);
                entity2.method_5643(this.method_37908().method_48963().method_48802(this.owner), 4.0f);
                this.setRetracting(true);
                this.pulling = true;
                return;
            }
            if (this.getLength(1.0f) >= 0.99f) {
                class_2338 targetBlockPos = class_2338.method_49638((class_2374)this.getTargetPos());
                class_2680 state = this.method_37908().method_8320(targetBlockPos);
                if (!state.method_26220((class_1922)this.method_37908(), targetBlockPos).method_1110()) {
                    this.pulling = true;
                    this.method_5783(MineCellsSounds.TENTACLE_RELEASE, 0.5f, 1.0f);
                }
                this.setRetracting(true);
            }
        }
    }

    private void pullOwner() {
        if (!this.pulling) {
            return;
        }
        class_243 ownerPos = this.owner.method_19538();
        class_243 targetPos = this.getTargetPos().method_1031(0.0, 2.5, 0.0);
        class_243 direction = targetPos.method_1020(ownerPos).method_1021(0.15);
        this.owner.method_18799(direction);
        this.owner.field_6037 = true;
    }

    public float getLength(float tickDelta) {
        return this.length.update((float)this.field_6012 + tickDelta);
    }

    public class_243 getEndPos(float length) {
        return this.getTargetPos().method_1020(this.startingPos).method_1021((double)length).method_1019(this.startingPos);
    }

    public class_243 getStartingPos() {
        return this.startingPos;
    }

    protected void method_5693() {
        this.field_6011.method_12784(RETRACTING, (Object)false);
        this.field_6011.method_12784(TARGET_POS, (Object)new Vector3f((float)this.method_23317(), (float)this.method_23318(), (float)this.method_23321()));
    }

    private class_243 getTargetPos() {
        Vector3f pos = (Vector3f)this.field_6011.method_12789(TARGET_POS);
        return new class_243((double)pos.x(), (double)pos.y(), (double)pos.z());
    }

    private void setTargetPos(class_243 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)new Vector3f((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350));
    }

    public boolean isRetracting() {
        return (Boolean)this.field_6011.method_12789(RETRACTING);
    }

    public void setRetracting(boolean retracting) {
        this.field_6011.method_12778(RETRACTING, (Object)retracting);
    }

    protected void method_5749(class_2487 nbt) {
        this.setTargetPos(new class_243(nbt.method_10574("TargetX"), nbt.method_10574("TargetY"), nbt.method_10574("TargetZ")));
        this.startingPos = new class_243(nbt.method_10574("StartingX"), nbt.method_10574("StartingY"), nbt.method_10574("StartingZ"));
        this.setRetracting(nbt.method_10577("Retracting"));
        this.pulling = nbt.method_10577("Pulling");
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10549("TargetX", this.getTargetPos().field_1352);
        nbt.method_10549("TargetY", this.getTargetPos().field_1351);
        nbt.method_10549("TargetZ", this.getTargetPos().field_1350);
        nbt.method_10549("StartingX", this.startingPos.field_1352);
        nbt.method_10549("StartingY", this.startingPos.field_1351);
        nbt.method_10549("StartingZ", this.startingPos.field_1350);
        nbt.method_10556("Retracting", this.isRetracting());
        nbt.method_10556("Pulling", this.pulling);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.startingPos = new class_243(packet.method_11175(), packet.method_11174(), packet.method_11176());
    }
}

