/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.boss;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.MineCellsBlockTags;
import com.github.mim1q.minecells.entity.SewersTentacleEntity;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedAuraGoal;
import com.github.mim1q.minecells.entity.ai.goal.conjunctivius.ConjunctiviusBarrageGoal;
import com.github.mim1q.minecells.entity.ai.goal.conjunctivius.ConjunctiviusMoveAroundGoal;
import com.github.mim1q.minecells.entity.ai.goal.conjunctivius.ConjunctiviusTargetGoal;
import com.github.mim1q.minecells.entity.boss.MineCellsBossEntity;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import com.github.mim1q.minecells.util.client.ClientUtil;
import dev.mim1q.gimm1q.interpolation.AnimatedProperty;
import dev.mim1q.gimm1q.interpolation.Easing;
import dev.mim1q.gimm1q.interpolation.EasingUtils;
import dev.mim1q.gimm1q.screenshake.ScreenShakeUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1452;
import net.minecraft.class_1588;
import net.minecraft.class_161;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_638;
import net.minecraft.class_8103;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ConjunctiviusEntity
extends MineCellsBossEntity {
    public final AnimationProperty spikeOffset = new AnimationProperty(5.0f, MathUtils::easeInOutQuad);
    public static final class_2940<Boolean> DASH_CHARGING = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DASH_RELEASING = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> AURA_CHARGING = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> AURA_RELEASING = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> BARRAGE_ACTIVE = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_2338> ANCHOR_TOP = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<class_2338> ANCHOR_LEFT = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<class_2338> ANCHOR_RIGHT = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<Integer> STAGE = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> TARGET_ID = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Vector3f> DASH_TARGET = class_2945.method_12791(ConjunctiviusEntity.class, (class_2941)class_2943.field_42237);
    private class_243 spawnPos = class_243.field_1353;
    private class_2350 direction;
    private float spawnRot = 180.0f;
    private class_3341 roomBox = null;
    private int dashCooldown = 0;
    private int auraCooldown = 0;
    public int barrageCooldown = 0;
    public boolean moving = false;
    private int stageTicks = 1;
    private int lastStage = 0;
    private final HashMap<class_1309, Integer> hitEntities = new HashMap();
    private AnimatedProperty.EasingFunction eyeEasing = Easing::lerp;
    private class_243 eyeOffset = class_243.field_1353;
    private class_243 lastEyeOffset = class_243.field_1353;
    private int blinkTimer = 0;
    private final AnimatedProperty eyeBlink = new AnimatedProperty(0.0f, MathUtils::lerp);
    private int lastTargetId = -1;

    public ConjunctiviusEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new ConjunctiviusMoveControl(this);
        this.field_6189 = new class_1407((class_1308)this, this.method_37908());
        this.method_5875(true);
        this.field_5985 = true;
        this.field_6194 = 5000;
        this.field_5960 = true;
        this.method_5710(180.0f, 0.0f);
        this.field_6283 = 180.0f;
        this.field_6220 = 180.0f;
        this.field_5982 = 180.0f;
        this.field_6241 = 180.0f;
        this.field_6259 = 180.0f;
        this.bossBar.method_14091(false);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.spawnPos = class_243.method_24953((class_2382)this.method_24515());
        this.roomBox = this.createBox();
        this.direction = class_2350.field_11043;
        this.spawnRot = this.direction.method_10144();
        class_2338 topAnchor = this.method_24515().method_10069(0, 9, 0);
        class_2338 leftAnchor = this.method_24515().method_10069(11, 0, 0);
        class_2338 rightAnchor = this.method_24515().method_10069(-11, 0, 0);
        this.setAnchors(topAnchor, leftAnchor, rightAnchor);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected class_3341 createBox() {
        class_2338 startPos = this.method_24515();
        int minX = startPos.method_10263() - 11;
        int maxX = startPos.method_10263() + 11;
        int minY = startPos.method_10264() - 10;
        int maxY = startPos.method_10264() + 9;
        int minZ = startPos.method_10260() - 25;
        int maxZ = startPos.method_10260() + 2;
        return new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DASH_RELEASING, (Object)false);
        this.field_6011.method_12784(DASH_CHARGING, (Object)false);
        this.field_6011.method_12784(AURA_RELEASING, (Object)false);
        this.field_6011.method_12784(AURA_CHARGING, (Object)false);
        this.field_6011.method_12784(BARRAGE_ACTIVE, (Object)false);
        this.field_6011.method_12784(ANCHOR_TOP, (Object)this.method_24515());
        this.field_6011.method_12784(ANCHOR_LEFT, (Object)this.method_24515());
        this.field_6011.method_12784(ANCHOR_RIGHT, (Object)this.method_24515());
        this.field_6011.method_12784(STAGE, (Object)0);
        this.field_6011.method_12784(TARGET_ID, (Object)-1);
        this.field_6011.method_12784(DASH_TARGET, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_35113(it -> true);
        this.field_6185.method_35113(it -> true);
        ConjunctiviusAuraGoal auraGoal = new ConjunctiviusAuraGoal(this, s -> {
            s.cooldownGetter = () -> this.auraCooldown;
            s.cooldownSetter = cooldown -> {
                this.auraCooldown = cooldown;
            };
            s.stateSetter = this::switchAuraState;
            s.chargeSound = MineCellsSounds.SHOCKER_CHARGE;
            s.releaseSound = MineCellsSounds.SHOCKER_RELEASE;
            s.soundVolume = 2.0f;
            s.damage = this.getDamage(1.0f);
            s.radius = 8.0;
            s.defaultCooldown = 400;
            s.actionTick = 30;
            s.chance = 0.05f;
            s.length = 60;
        });
        ConjunctiviusDashGoal dashGoal = new ConjunctiviusDashGoal(this, s -> {
            s.cooldownGetter = () -> this.dashCooldown;
            s.cooldownSetter = cooldown -> {
                this.dashCooldown = cooldown;
            };
            s.stateSetter = this::switchDashState;
            s.chargeSound = MineCellsSounds.CONJUNCTIVIUS_DASH_CHARGE;
            s.releaseSound = MineCellsSounds.CONJUNCTIVIUS_DASH_RELEASE;
            s.soundVolume = 2.0f;
            s.defaultCooldown = this.getStageAdjustedValue(300, 250, 200, 150);
            s.actionTick = this.getStageAdjustedValue(40, 35, 30, 30);
            s.chance = 0.1f;
            s.length = this.getStageAdjustedValue(105, 90, 83, 65);
        }, this.getStageAdjustedValue(50, 45, 40, 30));
        this.field_6201.method_6277(4, (class_1352)dashGoal);
        this.field_6201.method_6277(9, (class_1352)auraGoal);
        this.field_6201.method_6277(10, (class_1352)new ConjunctiviusMoveAroundGoal(this));
        this.addStageGoals(this.getStage());
        this.field_6185.method_6277(0, (class_1352)new ConjunctiviusTargetGoal(this));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1452.class, false));
    }

    public void addStageGoals(int stage) {
        if (stage >= 3) {
            this.field_6201.method_6277(2, (class_1352)new ConjunctiviusBarrageGoal.Targeted(this, s -> {
                s.chance = 0.2f;
                s.length = this.getStageAdjustedValue(60, 80, 100, 120);
                s.interval = this.getStageAdjustedValue(8, 6, 5, 4);
                s.cooldown = this.getStageAdjustedValue(320, 280, 240, 200);
            }));
            this.field_6201.method_6277(2, (class_1352)new ConjunctiviusBarrageGoal.Around(this, s -> {
                s.chance = 0.05f;
                s.length = this.getStageAdjustedValue(20, 26, 32, 37);
                s.interval = this.getStageAdjustedValue(8, 6, 5, 4);
                s.cooldown = 40;
                s.speed = 0.1f;
                s.count = () -> this.field_5974.method_39332(2, 5);
                s.minPause = this.getStageAdjustedValue(10, 8, 6, 4);
                s.maxPause = this.getStageAdjustedValue(20, 16, 12, 8);
            }));
        }
    }

    @Override
    public void method_5773() {
        this.field_6283 = this.spawnRot;
        this.field_6220 = this.spawnRot;
        this.method_36456(this.spawnRot);
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.calculateEyeOffset();
            if (this.getDashState() != TimedActionGoal.State.IDLE || this.getAuraState() == TimedActionGoal.State.RELEASE) {
                this.spikeOffset.setupTransitionTo(0.0f, 10.0f, Easing::easeInQuad);
            } else {
                this.spikeOffset.setupTransitionTo(5.0f, 30.0f, Easing::easeInOutQuad);
            }
            this.spawnParticles();
            int blinkTime = this.getBlinkTicks();
            this.blinkTimer = blinkTime > 0 ? Math.max(blinkTime, this.blinkTimer) : Math.max(0, this.blinkTimer - 1);
            if (this.blinkTimer > 0) {
                this.eyeBlink.transitionTo(4.0f, 1.5f);
            } else {
                this.eyeBlink.transitionTo(0.0f, 4.0f);
            }
        } else {
            for (class_1297 e : this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(0.2))) {
                Integer lastHit;
                if (!(e instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)e;
                if (e instanceof SewersTentacleEntity || this.field_6012 - (lastHit = this.hitEntities.getOrDefault(livingEntity, 0)) < 40) continue;
                livingEntity.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), this.getDamage(0.5f));
                this.hitEntities.put(livingEntity, this.field_6012);
            }
            class_2338.method_25996((class_2338)this.method_24515(), (int)3, (int)4, (int)3).forEach(blockPos -> {
                if (this.method_37908().method_8320(blockPos).method_26164(MineCellsBlockTags.CONJUNCTIVIUS_BREAKABLE)) {
                    this.method_37908().method_22352(blockPos, true);
                }
            });
            if (!this.method_37908().method_8320(this.method_24515().method_10087(2)).method_26215()) {
                this.method_5784(class_1313.field_6308, new class_243(0.0, 0.1, 0.0));
            }
            if (this.field_6012 % 20 == 0) {
                boolean closestPlayerNearby = this.method_37908().method_18460((class_1297)this, 32.0) != null;
                List playersInArea = this.method_37908().method_18464(class_4051.field_18092, (class_1309)this, class_238.method_19316((class_3341)this.roomBox).method_1014(2.0));
                this.bossBar.method_14091(closestPlayerNearby && !playersInArea.isEmpty());
                this.switchStages(this.getStage());
                if (!this.isInFullStage()) {
                    List tentacles = this.method_37908().method_8390(SewersTentacleEntity.class, class_238.method_19316((class_3341)this.roomBox.method_35410(10)), Objects::nonNull);
                    if (this.stageTicks > 30 && tentacles.isEmpty() && this.getStage() != 0) {
                        this.setStage(this.getStage() + 1);
                    } else if (this.getStage() != 0) {
                        this.method_6092(new class_1293(MineCellsStatusEffects.PROTECTED, 30, 0, false, false));
                    }
                }
            }
        }
        int stage = this.getStage();
        if (stage != this.lastStage) {
            this.stageTicks = 0;
        }
        this.lastStage = stage;
        ++this.stageTicks;
    }

    private void calculateEyeOffset() {
        class_1297 entity;
        this.lastEyeOffset = this.eyeOffset;
        class_243 targetPos = ClientUtil.getClientCameraPos();
        Integer targetId = (Integer)this.field_6011.method_12789(TARGET_ID);
        if (targetId != -1 && (entity = this.method_37908().method_8469(targetId.intValue())) != null) {
            targetPos = entity.method_19538();
        }
        class_243 entityPos = this.method_19538().method_1031(0.0, 2.5, 0.0);
        class_243 diff = targetPos.method_1020(entityPos);
        float rotation = this.field_6283;
        class_243 rotatedDiff = MathUtils.vectorRotateY(diff, rotation * ((float)Math.PI / 180) + 1.5707964f);
        float xOffset = (float)(-rotatedDiff.field_1352);
        float yOffset = (float)(-rotatedDiff.field_1351);
        float distance = 1.0f - ((float)rotatedDiff.field_1350 - 2.5f) / 30.0f;
        distance = class_3532.method_15363((float)distance, (float)0.25f, (float)1.0f);
        xOffset *= distance * 0.5f;
        yOffset *= distance * 0.5f;
        if (this.getEyeState() == EyeState.SHAKING) {
            xOffset += (this.field_5974.method_43057() - 0.5f) * 2.0f;
            yOffset += (this.field_5974.method_43057() - 0.5f) * 2.0f;
            this.eyeEasing = Easing::easeOutBack;
        } else {
            this.eyeEasing = Easing::lerp;
        }
        xOffset = class_3532.method_15363((float)xOffset, (float)-6.0f, (float)6.0f);
        yOffset = class_3532.method_15363((float)yOffset, (float)-4.0f, (float)4.0f);
        this.eyeOffset = new class_243((double)xOffset, (double)yOffset, 0.0);
    }

    public class_243 getEyeOffset(float tickDelta) {
        return EasingUtils.interpolateVec((class_243)this.lastEyeOffset, (class_243)this.eyeOffset, (float)tickDelta, (AnimatedProperty.EasingFunction)this.eyeEasing);
    }

    private int getBlinkTicks() {
        Integer targetId = (Integer)this.field_6011.method_12789(TARGET_ID);
        if (targetId != this.lastTargetId) {
            this.lastTargetId = targetId;
            return 4;
        }
        if (this.field_6235 == this.field_6254 - 1) {
            return 3;
        }
        if (this.field_6012 % 400 == 0) {
            return 5;
        }
        if (this.field_6213 > 40 || this.getStage() == 0) {
            return 1;
        }
        return 0;
    }

    public int getEyelidFrame(float progress) {
        return (int)this.eyeBlink.update(progress);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        this.field_6011.method_12778(TARGET_ID, (Object)(target == null ? -1 : target.method_5628()));
    }

    protected void method_6108() {
        if (this.method_37908().method_8608()) {
            int interval;
            int n = interval = this.field_6213 >= 55 ? 1 : 10;
            if (this.field_6213 % interval == 0) {
                this.method_37908().method_8406((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318() + 2.5, this.method_23321(), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.field_6213 == 1) {
                this.method_5783(MineCellsSounds.CONJUNCTIVIUS_DYING, 2.0f, 1.0f);
                ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)0.5f, (int)80, (double)30.0, (double)40.0, (String)"minecells:conjunctivius_death");
            }
            if (this.field_6213 == 60) {
                ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)1.0f, (int)40, (double)30.0, (double)40.0, (String)"minecells:conjunctivius_death");
                this.method_5783(MineCellsSounds.CONJUNCTIVIUS_DEATH, 2.0f, 1.0f);
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
        ++this.field_6213;
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (this.method_37908().field_9236 || this.method_37908().method_8503() == null) {
            return;
        }
        MinecraftServer server = this.method_37908().method_8503();
        class_161 advancement = server.method_3851().method_12896(MineCells.createId("conjunctivius"));
        if (advancement == null) {
            return;
        }
        this.method_37908().method_18464(class_4051.field_18092, (class_1309)this, class_238.method_19316((class_3341)this.getRoomBox().method_35410(10))).forEach(player -> ((class_3222)player).method_14236().method_12878(advancement, "conjunctivius_killed"));
    }

    protected void switchStages(int stage) {
        if (stage == 0 && this.method_5968() != null) {
            this.setStage(1);
            return;
        }
        float healthPercent = this.method_6032() / this.method_6063();
        if (stage == 1 && healthPercent <= 0.8f) {
            this.spawnTentacles();
            this.setStage(2);
            return;
        }
        if (stage == 3 && healthPercent <= 0.55f) {
            this.spawnTentacles();
            this.setStage(4);
            return;
        }
        if (stage == 5 && healthPercent <= 0.3f) {
            this.spawnTentacles();
            this.setStage(6);
        }
    }

    protected void spawnTentacles() {
        int playerAmount = this.method_37908().method_18464(class_4051.field_18092, (class_1309)this, class_238.method_19316((class_3341)this.roomBox).method_1014(4.0)).size();
        for (int i = 0; i < 2 + 2 * playerAmount; ++i) {
            SewersTentacleEntity tentacle = (SewersTentacleEntity)MineCellsEntities.SEWERS_TENTACLE.method_5883(this.method_37908());
            if (tentacle == null) continue;
            tentacle.setVariant(this.getStage() == 1 ? 0 : (this.getStage() == 3 ? 1 : 2));
            tentacle.method_33574(this.getTentaclePos());
            tentacle.setSpawnedByBoss(true);
            this.method_37908().method_8649((class_1297)tentacle);
        }
    }

    private class_243 getTentaclePos() {
        class_2338 center = this.roomBox.method_22874().method_10069(this.field_5974.method_43048(16) - 8, 0, this.field_5974.method_43048(16) - 8);
        return class_243.method_24953((class_2382)center);
    }

    protected void spawnParticles() {
        class_243 pos = this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0);
        if (this.getAuraState() == TimedActionGoal.State.CHARGE) {
            ParticleUtils.addAura((class_638)this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 2, 7.5, -0.01);
        } else if (this.getAuraState() == TimedActionGoal.State.RELEASE) {
            ParticleUtils.addAura((class_638)this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 50, 7.0, 0.01);
            ParticleUtils.addAura((class_638)this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 10, 1.0, 0.5);
        }
        if ((this.getEyeState() == EyeState.SHAKING || this.field_6012 % 5 == 0) && this.field_5974.method_43057() < 0.33f) {
            ParticleUtils.addInBox((class_638)this.method_37908(), (class_2394)class_2398.field_18306, class_238.method_30048((class_243)this.method_19538().method_1031(0.0, 0.25, 0.0), (double)2.0, (double)0.5, (double)2.0), this.getEyeState() == EyeState.SHAKING ? 3 : 1, class_243.field_1353);
        }
        int stage = this.getStage();
        if (this.isInFullStage() || stage == 0) {
            return;
        }
        if (this.stageTicks == 1) {
            class_243 offset = switch (stage) {
                case 2 -> new class_243(2.2, -0.85, 0.0);
                case 4 -> new class_243(-2.2, -0.85, 0.0);
                default -> new class_243(0.0, 1.75, 0.0);
            };
            class_243 target = switch (stage) {
                case 2 -> class_243.method_24953((class_2382)this.getRightAnchor());
                case 4 -> class_243.method_24953((class_2382)this.getLeftAnchor());
                default -> class_243.method_24953((class_2382)this.getTopAnchor());
            };
            this.spawnChainBreakingParticles(offset, target);
        }
    }

    private void spawnChainBreakingParticles(class_243 offset, class_243 target) {
        class_2388 particle = new class_2388(class_2398.field_11217, MineCellsBlocks.BIG_CHAIN.method_9564());
        class_243 diff = target.method_1020(this.method_19538().method_1019(offset));
        double length = diff.method_1033();
        int i = 0;
        while ((double)i < length) {
            class_243 pos = this.method_19538().method_1019(offset).method_1019(diff.method_1021((double)i / length));
            this.method_37908().method_8406((class_2394)particle, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    @Override
    protected void decrementCooldowns() {
        this.dashCooldown = Math.max(0, this.dashCooldown - 1);
        this.auraCooldown = Math.max(0, this.auraCooldown - 1);
        this.barrageCooldown = Math.max(0, this.barrageCooldown - 1);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42247)) {
            return super.method_5643(source, amount * 0.5f);
        }
        return super.method_5643(source, amount);
    }

    protected void switchDashState(TimedActionGoal.State state, boolean value) {
        switch (state) {
            case CHARGE: {
                this.field_6011.method_12778(DASH_CHARGING, (Object)value);
                break;
            }
            case RELEASE: {
                this.field_6011.method_12778(DASH_RELEASING, (Object)value);
            }
        }
    }

    protected void switchAuraState(TimedActionGoal.State state, boolean value) {
        switch (state) {
            case CHARGE: {
                this.field_6011.method_12778(AURA_CHARGING, (Object)value);
                break;
            }
            case RELEASE: {
                this.field_6011.method_12778(AURA_RELEASING, (Object)value);
            }
        }
    }

    public TimedActionGoal.State getDashState() {
        return this.getStateFromTrackedData(DASH_CHARGING, DASH_RELEASING);
    }

    public TimedActionGoal.State getAuraState() {
        return this.getStateFromTrackedData(AURA_CHARGING, AURA_RELEASING);
    }

    public void setAnchors(class_2338 top, class_2338 left, class_2338 right) {
        this.field_6011.method_12778(ANCHOR_TOP, (Object)top);
        this.field_6011.method_12778(ANCHOR_LEFT, (Object)left);
        this.field_6011.method_12778(ANCHOR_RIGHT, (Object)right);
    }

    public class_2338 getTopAnchor() {
        return (class_2338)this.field_6011.method_12789(ANCHOR_TOP);
    }

    public class_2338 getLeftAnchor() {
        return (class_2338)this.field_6011.method_12789(ANCHOR_LEFT);
    }

    public class_2338 getRightAnchor() {
        return (class_2338)this.field_6011.method_12789(ANCHOR_RIGHT);
    }

    public int getStage() {
        return (Integer)this.field_6011.method_12789(STAGE);
    }

    public boolean isInFullStage() {
        int stage = this.getStage();
        return stage == 1 || stage == 3 || stage == 5 || stage == 7;
    }

    public boolean canAttack() {
        return this.isInFullStage() && this.stageTicks > 40;
    }

    public void setStage(int stage) {
        if (stage != this.getStage()) {
            this.method_5783(MineCellsSounds.CONJUNCTIVIUS_SHOUT, 2.0f, 1.0f);
            ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)1.0f, (int)50, (double)20.0, (double)40.0, (String)"minecells:conjunctivius_roar");
            this.field_6011.method_12778(STAGE, (Object)stage);
            this.method_5959();
        }
    }

    public EyeState getEyeState() {
        boolean stageBeginning;
        boolean bl = stageBeginning = this.stageTicks > 0 && this.stageTicks < 30;
        if (stageBeginning || !this.method_5805()) {
            return EyeState.SHAKING;
        }
        if (((Boolean)this.field_6011.method_12789(BARRAGE_ACTIVE)).booleanValue()) {
            return EyeState.GREEN;
        }
        if (this.getDashState() != TimedActionGoal.State.IDLE) {
            return EyeState.YELLOW;
        }
        return EyeState.PINK;
    }

    public <T> T getStageAdjustedValue(T stage1, T stage3, T stage5, T stage7) {
        int stage = this.getStage();
        return switch (stage) {
            case 3, 4 -> stage3;
            case 5, 6 -> stage5;
            case 7 -> stage7;
            default -> stage1;
        };
    }

    public static class_5132.class_5133 createConjunctiviusAttributes() {
        return ConjunctiviusEntity.method_26918().method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_23716, 400.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23725, 6.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23722, 5.0);
    }

    public class_3341 getRoomBox() {
        return this.roomBox;
    }

    public class_243 getSpawnPos() {
        return this.spawnPos;
    }

    public class_243 getDashTarget() {
        return new class_243((Vector3f)this.field_6011.method_12789(DASH_TARGET));
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034() || this.method_5787()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.85));
        }
    }

    public void method_5814(double x, double y, double z) {
        class_3341 box = this.getRoomBox();
        if (box == null) {
            super.method_5814(x, y, z);
            return;
        }
        super.method_5814(class_3532.method_15350((double)x, (double)box.method_35415(), (double)box.method_35418()), class_3532.method_15350((double)y, (double)box.method_35416(), (double)box.method_35419()), class_3532.method_15350((double)z, (double)box.method_35417(), (double)box.method_35420()));
    }

    public boolean method_6101() {
        return false;
    }

    public int method_5986() {
        return 360;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("dashCooldown", this.dashCooldown);
        nbt.method_10539("spawnPos", new int[]{(int)this.spawnPos.field_1352, (int)this.spawnPos.field_1351, (int)this.spawnPos.field_1350});
        if (this.roomBox != null) {
            nbt.method_10539("roomBox", new int[]{this.roomBox.method_35415(), this.roomBox.method_35416(), this.roomBox.method_35417(), this.roomBox.method_35418(), this.roomBox.method_35419(), this.roomBox.method_35420()});
        }
        nbt.method_10548("spawnRot", this.spawnRot);
        nbt.method_10539("anchors", new int[]{this.getTopAnchor().method_10263(), this.getTopAnchor().method_10264(), this.getTopAnchor().method_10260(), this.getLeftAnchor().method_10263(), this.getLeftAnchor().method_10264(), this.getLeftAnchor().method_10260(), this.getRightAnchor().method_10263(), this.getRightAnchor().method_10264(), this.getRightAnchor().method_10260()});
        nbt.method_10569("stage", ((Integer)this.field_6011.method_12789(STAGE)).intValue());
        nbt.method_10569("stageTicks", this.stageTicks);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.dashCooldown = nbt.method_10550("dashCooldown");
        if (nbt.method_10545("spawnPos") && nbt.method_10561("spawnPos").length == 3) {
            int[] posArray = nbt.method_10561("spawnPos");
            this.spawnPos = new class_243((double)posArray[0], (double)posArray[1], (double)posArray[2]);
        }
        if (nbt.method_10545("roomBox") && nbt.method_10561("roomBox").length == 6) {
            int[] boxArray = nbt.method_10561("roomBox");
            this.roomBox = new class_3341(boxArray[0], boxArray[1], boxArray[2], boxArray[3], boxArray[4], boxArray[5]);
        }
        this.spawnRot = nbt.method_10583("spawnRot");
        this.direction = class_2350.method_10150((double)this.spawnRot);
        if (nbt.method_10545("anchors") && nbt.method_10561("anchors").length == 9) {
            int[] anchors = nbt.method_10561("anchors");
            class_2338 anchorTop = new class_2338(anchors[0], anchors[1], anchors[2]);
            class_2338 anchorLeft = new class_2338(anchors[3], anchors[4], anchors[5]);
            class_2338 anchorRight = new class_2338(anchors[6], anchors[7], anchors[8]);
            this.setAnchors(anchorTop, anchorLeft, anchorRight);
        }
        this.setStage(nbt.method_10550("stage"));
        this.stageTicks = nbt.method_10550("stageTicks");
    }

    protected class_3414 method_6011(class_1282 source) {
        return MineCellsSounds.CONJUNCTIVIUS_HIT;
    }

    protected static class ConjunctiviusMoveControl
    extends class_1335 {
        public ConjunctiviusMoveControl(ConjunctiviusEntity entity) {
            super((class_1308)entity);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - this.field_6371.method_23317(), this.field_6369 - this.field_6371.method_23318(), this.field_6367 - this.field_6371.method_23321());
                double d = vec3d.method_1033();
                if (!this.willCollide(vec3d = vec3d.method_1029(), class_3532.method_15384((double)d))) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                }
            }
        }

        private boolean willCollide(class_243 direction, int steps) {
            class_238 box = this.field_6371.method_5829().method_35575(this.field_6371.method_23318() - 1.0);
            for (int i = 1; i < steps; ++i) {
                box = box.method_997(direction);
                if (this.field_6371.method_37908().method_8587((class_1297)this.field_6371, box)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class ConjunctiviusAuraGoal
    extends TimedAuraGoal<ConjunctiviusEntity> {
        public ConjunctiviusAuraGoal(ConjunctiviusEntity entity, Consumer<TimedAuraGoal.TimedAuraSettings> settings) {
            super(entity, settings, null);
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && ((ConjunctiviusEntity)this.entity).canAttack() && !((ConjunctiviusEntity)this.entity).moving && ((ConjunctiviusEntity)this.entity).dashCooldown > this.length && !((ConjunctiviusEntity)this.entity).method_37908().method_18464(class_4051.field_18092, this.entity, ((ConjunctiviusEntity)this.entity).method_5829().method_1014(6.0)).isEmpty();
        }
    }

    protected static class ConjunctiviusDashGoal
    extends TimedActionGoal<ConjunctiviusEntity> {
        private class_243 startPos;
        private class_243 targetPos;
        private final int restTime;

        public ConjunctiviusDashGoal(ConjunctiviusEntity entity, Consumer<TimedActionGoal.TimedActionSettings> settings, int restTime) {
            super(entity, settings, (E it) -> it.canAttack() && !it.moving && it.method_5968() != null);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.startPos = entity.method_19538();
            this.targetPos = entity.method_19538();
            this.restTime = restTime;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.startPos = ((ConjunctiviusEntity)this.entity).method_19538();
            class_1309 target = ((ConjunctiviusEntity)this.entity).method_5968();
            this.targetPos = target == null ? this.startPos : target.method_19538();
            ((ConjunctiviusEntity)this.entity).method_5841().method_12778(DASH_TARGET, (Object)new Vector3f((float)this.targetPos.field_1352, (float)this.targetPos.field_1351 + 1.0f, (float)this.targetPos.field_1350));
        }

        @Override
        protected void release() {
            Object object;
            float delta = (float)(this.ticks() - this.actionTick) / (float)(this.length - this.actionTick - this.restTime);
            class_243 tickPos = EasingUtils.interpolateVec((class_243)this.startPos, (class_243)this.targetPos, (float)delta, Easing::easeInOutCubic);
            if (this.ticks() <= this.length - this.restTime + 2) {
                List entities = ((ConjunctiviusEntity)this.entity).method_37908().method_8335((class_1297)this.entity, ((ConjunctiviusEntity)this.entity).method_5829().method_1014(0.75));
                object = entities.iterator();
                while (object.hasNext()) {
                    class_1297 e = (class_1297)object.next();
                    if (!(e instanceof class_1309)) continue;
                    class_1309 livingEntity = (class_1309)e;
                    livingEntity.method_5643(((ConjunctiviusEntity)this.entity).method_37908().method_48963().method_48812(this.entity), ((ConjunctiviusEntity)this.entity).getDamage(2.0f));
                    ((ConjunctiviusEntity)this.entity).hitEntities.put(livingEntity, ((ConjunctiviusEntity)this.entity).field_6012);
                }
            }
            if (this.ticks() == this.length - this.restTime && (object = ((ConjunctiviusEntity)this.entity).method_37908()) instanceof class_3218) {
                class_3218 serverWorld = (class_3218)object;
                serverWorld.method_14199((class_2394)class_2398.field_11221, this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350, 2, 2.0, 2.0, 2.0, 0.0);
                ScreenShakeUtils.shakeAround((class_3218)serverWorld, (class_243)tickPos, (float)1.0f, (int)30, (double)20.0, (double)40.0, (String)"minecells:conjunctivius_smash");
                serverWorld.method_8396(null, ((ConjunctiviusEntity)this.entity).method_24515(), class_3417.field_15152, class_3419.field_15251, 2.0f, 1.0f);
            }
            ((ConjunctiviusEntity)this.entity).method_33574(tickPos);
        }

        @Override
        public void method_6270() {
            super.method_6270();
            if (((ConjunctiviusEntity)this.entity).getSpawnPos() != null) {
                ((ConjunctiviusEntity)this.entity).method_18799(((ConjunctiviusEntity)this.entity).getSpawnPos().method_1020(((ConjunctiviusEntity)this.entity).method_19538()).method_1029());
            }
        }
    }

    public static enum EyeState {
        SHAKING(-1),
        PINK(0),
        YELLOW(1),
        GREEN(2),
        BLUE(3);

        public final int index;

        private EyeState(int index) {
            this.index = index;
        }
    }
}

