/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.AbstractCaveGenerationStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CakeCaveStructurePiece
extends AbstractCaveGenerationStructurePiece {
    private static final Block[] ROAD_BLOCKS = new Block[]{(Block)ACBlockRegistry.RED_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get(), (Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.ORANGE_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIME_ROCK_CANDY.get()};
    private VoronoiGenerator voronoiGenerator;
    private static final float SCALE_RIVER_NOISE_BY = 1000.0f;
    private static final float RIVER_WIDTH_SQ = 1000.0f;
    private static final float RIVER_BANK_WIDTH_SQ = 3000.0f;

    public CakeCaveStructurePiece(BlockPos chunkCorner, BlockPos holeCenter, int bowlHeight, int bowlRadius) {
        super((StructurePieceType)ACStructurePieceRegistry.CAKE_CAVE.get(), chunkCorner, holeCenter, bowlHeight, bowlRadius);
    }

    public CakeCaveStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.CAKE_CAVE.get(), tag);
    }

    public CakeCaveStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (this.voronoiGenerator == null) {
            this.voronoiGenerator = new VoronoiGenerator(level.m_7328_());
            this.voronoiGenerator.setOffsetAmount(1.0);
            this.voronoiGenerator.setDistanceType(VoronoiGenerator.DistanceType.euclidean);
        }
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveAbove = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveBelow = new BlockPos.MutableBlockPos();
        carve.m_122178_(cornerX, cornerY, cornerZ);
        carveAbove.m_122178_(cornerX, cornerY, cornerZ);
        carveBelow.m_122178_(cornerX, cornerY, cornerZ);
        boolean flag = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                MutableBoolean doFloor = new MutableBoolean(false);
                for (int y = 15; y >= 0; --y) {
                    carve.m_122178_(cornerX + x, Mth.m_14045_((int)(cornerY + y), (int)level.m_141937_(), (int)level.m_151558_()), cornerZ + z);
                    carveAbove.m_122178_(carve.m_123341_(), carve.m_123342_() + 1, carve.m_123343_());
                    if (!this.inCircle((BlockPos)carve) || this.checkedGetBlock(level, (BlockPos)carve).m_60713_(Blocks.f_50752_)) continue;
                    this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_50627_.m_49966_());
                    flag = true;
                    this.surroundCornerOfLiquid(level, carve);
                    carveBelow.m_122178_(carve.m_123341_(), carve.m_123342_() - 1, carve.m_123343_());
                    doFloor.setTrue();
                }
                if (!doFloor.isTrue()) continue;
                BlockState floor = this.checkedGetBlock(level, (BlockPos)carveBelow);
                if (!floor.m_60795_()) {
                    this.decorateFloor(level, random, carveBelow.m_7949_());
                }
                doFloor.setFalse();
            }
        }
    }

    private void surroundCornerOfLiquid(WorldGenLevel level, BlockPos.MutableBlockPos center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            offset.m_122190_((Vec3i)center);
            offset.m_122173_(dir);
            BlockState state = this.checkedGetBlock(level, (BlockPos)offset);
            if (state.m_60819_().m_76178_()) continue;
            if (state.m_60819_().getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get()) {
                double riveriness = this.getRiveriness((BlockPos)offset);
                if (!(riveriness > 500.0)) continue;
                this.checkedSetBlock(level, (BlockPos)offset, ((Block)ACBlockRegistry.CAKE_LAYER.get()).m_49966_());
                continue;
            }
            this.checkedSetBlock(level, (BlockPos)offset, ((Block)ACBlockRegistry.CAKE_LAYER.get()).m_49966_());
        }
    }

    private boolean generateRiverAt(WorldGenLevel level, double riveriness, BlockPos blockPos) {
        double plateauHeight1 = CakeCaveStructurePiece.calculatePlateauHeight(blockPos.m_123341_(), blockPos.m_123343_(), 0, false);
        if (riveriness < 1000.0) {
            int riverDepth = 3 + (int)((1.0 - Math.sqrt(riveriness / 1000.0)) * 8.0) + (int)(1.75f * ACMath.sampleNoise2D(blockPos.m_123341_() + 123, blockPos.m_123343_() + 120, 10.0f));
            BlockPos riverPos = blockPos.m_175288_((int)plateauHeight1 + 15);
            while (riverPos.m_123342_() > blockPos.m_123342_() - riverDepth) {
                if ((riverPos = riverPos.m_7495_()).m_123342_() < (int)plateauHeight1) {
                    this.checkedSetBlock(level, riverPos, ((LiquidBlock)ACBlockRegistry.PURPLE_SODA.get()).m_49966_());
                    level.m_186469_(riverPos, (Fluid)ACFluidRegistry.PURPLE_SODA_FLUID_SOURCE.get(), ((FlowingFluid)ACFluidRegistry.PURPLE_SODA_FLUID_SOURCE.get()).m_6718_((LevelReader)level));
                    continue;
                }
                this.checkedSetBlock(level, riverPos, Blocks.f_50627_.m_49966_());
            }
            this.checkedSetBlock(level, riverPos.m_7495_(), ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_());
            return true;
        }
        if (riveriness < 3000.0) {
            for (int i = 0; i < 2 + level.m_213780_().m_188503_(2); ++i) {
                this.checkedSetBlock(level, blockPos.m_6625_(i), ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_());
            }
            return true;
        }
        return false;
    }

    private double getRiveriness(BlockPos blockPos) {
        int riverNoiseX = blockPos.m_123341_() + (int)(350.0f * ACMath.sampleNoise2D(blockPos.m_123341_() + 1200, blockPos.m_123343_() - 1200, 150.0f));
        int riverNoiseZ = blockPos.m_123343_() + (int)(350.0f * ACMath.sampleNoise2D(blockPos.m_123341_() - 1200, blockPos.m_123343_() + 1200, 150.0f));
        float riverNoise = Math.abs(ACMath.sampleNoise2D(riverNoiseX + 68200, riverNoiseZ - 2248, 1000.0f));
        return (float)Math.pow(riverNoise * 1000.0f, 2.0);
    }

    private void decorateFloor(WorldGenLevel level, RandomSource rand, BlockPos blockPos) {
        int underDownFor = 1 + rand.m_188503_(2);
        double roadRadius = 0.001;
        float roadNoise = Math.abs(ACMath.sampleNoise2D(blockPos.m_123341_() + 1200, blockPos.m_123343_() + 10222, 100.0f));
        float roadNoiseSq = (float)Math.pow(roadNoise, 3.0);
        double riveriness = this.getRiveriness(blockPos);
        boolean isRiverAt = this.generateRiverAt(level, riveriness, blockPos);
        boolean roadFlag = false;
        BlockState topBlock = ((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()).m_49966_();
        BlockState underBlock = ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_();
        if ((double)roadNoiseSq < roadRadius) {
            boolean edge;
            float voronoiSampleSize = 0.025f;
            VoronoiGenerator.VoronoiInfo info2 = this.voronoiGenerator.get2((float)blockPos.m_123341_() * voronoiSampleSize, (float)blockPos.m_123343_() * voronoiSampleSize);
            double normalizedDistance = info2.distance() * (double)ROAD_BLOCKS.length;
            double border = normalizedDistance % 1.0;
            boolean bl = edge = (double)roadNoiseSq >= roadRadius - 7.5E-4;
            if (isRiverAt) {
                topBlock = edge ? ((Block)ACBlockRegistry.GINGERBREAD_BLOCK.get()).m_49966_() : ((Block)ACBlockRegistry.GINGERBREAD_BRICKS.get()).m_49966_();
                underDownFor = 0;
            } else if (border > (double)0.45f && border < (double)0.65f || edge) {
                topBlock = ((Block)ACBlockRegistry.WHITE_ROCK_CANDY.get()).m_49966_();
                underDownFor = 0;
            } else {
                int index = (int)Mth.m_14036_((float)Math.round(normalizedDistance), (float)0.0f, (float)(ROAD_BLOCKS.length - 1));
                topBlock = ROAD_BLOCKS[index].m_49966_();
                underDownFor = 1;
            }
            underBlock = ((Block)ACBlockRegistry.WHITE_ROCK_CANDY.get()).m_49966_();
            roadFlag = true;
        }
        if (!isRiverAt || roadFlag) {
            this.checkedSetBlock(level, blockPos, topBlock);
        }
        if (!isRiverAt) {
            for (int i = 0; i < underDownFor; ++i) {
                blockPos = blockPos.m_7495_();
                this.checkedSetBlock(level, blockPos, underBlock);
            }
        }
    }

    public static double calculatePlateauHeight(int x, int z, int curvedTop, boolean terrainNoise) {
        int plateauSize = 48;
        float plateauNoise = (0.5f + ACMath.sampleNoise2D(x, z, 100.0f)) * 0.5f;
        double slightTerrainNoise = terrainNoise ? (double)(ACMath.sampleNoise2D(x + 9000, z - 9000, 150.0f) + ACMath.sampleNoise2D(x + 18000, z + 9000, 60.0f)) : 0.0;
        return (double)(-48.0f + ACMath.canyonStep(Mth.m_14116_((float)plateauNoise), 5) * (float)plateauSize + ACMath.canyonStep(Mth.m_14116_((float)plateauNoise), 10) * (float)curvedTop) + slightTerrainNoise;
    }

    private boolean inCircle(BlockPos carve) {
        double plateauHeight = CakeCaveStructurePiece.calculatePlateauHeight(carve.m_123341_(), carve.m_123343_(), 7, true);
        double distToCenterXZ = carve.m_203202_((double)this.holeCenter.m_123341_(), (double)carve.m_123342_(), (double)this.holeCenter.m_123343_());
        if (carve.m_123342_() < (int)plateauHeight) {
            return false;
        }
        double ceilingNoise = 1.0f + (1.0f + ACMath.sampleNoise2D(carve.m_123341_() + 9000, carve.m_123343_() - 9000, 120.0f)) * 10.0f + (1.0f + ACMath.sampleNoise2D(carve.m_123341_() + 3000, carve.m_123343_() + 2000, 40.0f)) * 4.0f;
        double wallNoise = 0.9f + ACMath.sampleNoise2D(carve.m_123341_() + 9000, carve.m_123343_() - 9000, 120.0f) * 0.1f;
        double celingHeightScaled = (double)((float)this.height * 0.85f) - ceilingNoise;
        float yDome = (float)Math.pow((float)Math.abs(this.holeCenter.m_123342_() - carve.m_123342_()) / (float)this.height, 4.0);
        double yDist = ACMath.smin(1.0f - yDome, 1.0f, 0.2f);
        return distToCenterXZ < yDist * ((double)this.radius * wallNoise) * (double)this.radius && (double)carve.m_123342_() < (double)this.holeCenter.m_123342_() + celingHeightScaled;
    }
}

