/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.map;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.CaveMapItem;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRarity;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.message.UpdateCaveBiomeMapTagMessage;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.registries.ForgeRegistries;

public class CaveBiomeMapWorldWorker
implements WorldWorkerManager.IWorker {
    private final Stopwatch stopwatch;
    private ItemStack map;
    private BlockPos center;
    private Player player;
    private ServerLevel serverLevel;
    private ResourceKey<Biome> biomeResourceKey;
    private UUID taskUUID;
    private Direction sampleDirection = Direction.UP;
    private BlockPos lastSampledPos = null;
    private BlockPos lastBiomePos = null;
    private boolean complete;
    private int samples = 0;
    private static final int SAMPLE_INCREMENT = (Integer)AlexsCaves.COMMON_CONFIG.caveMapSearchWidth.get();
    private int width = 0;
    private int nextWidth = SAMPLE_INCREMENT;
    private BlockPos.MutableBlockPos nextPos = new BlockPos.MutableBlockPos();

    public CaveBiomeMapWorldWorker(ItemStack map, ServerLevel serverLevel, BlockPos center, Player player, UUID taskUUID) {
        this.map = map;
        this.serverLevel = serverLevel;
        this.center = center;
        ResourceKey<Biome> from = CaveMapItem.getBiomeTarget(map);
        this.biomeResourceKey = from == null ? ACBiomeRegistry.MAGNETIC_CAVES : from;
        this.player = player;
        this.taskUUID = taskUUID;
        this.stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
        this.nextPos.m_122190_((Vec3i)center);
    }

    public boolean hasWork() {
        boolean ret;
        boolean bl = ret = !this.complete && this.samples < (Integer)AlexsCaves.COMMON_CONFIG.caveMapSearchAttempts.get() && !this.serverLevel.m_7654_().m_129918_();
        if (!ret) {
            this.onWorkComplete(this.getLastFoundBiome());
        }
        return ret;
    }

    public boolean doWork() {
        if (this.hasWork()) {
            ++this.samples;
            int y = this.player.m_146904_();
            ServerChunkCache cache = this.serverLevel.m_7726_();
            BiomeSource source = cache.m_8481_().m_62218_();
            Climate.Sampler sampler = cache.m_214994_().m_224579_();
            int height = 64;
            if (this.sampleDirection != Direction.UP) {
                this.nextPos.m_122175_(this.sampleDirection, SAMPLE_INCREMENT);
            }
            int[] searchedHeights = Mth.m_216250_((int)y, (int)(this.serverLevel.m_141937_() + 1), (int)this.serverLevel.m_151558_(), (int)64).toArray();
            int nextBlockX = this.nextPos.m_123341_();
            int nextBlockZ = this.nextPos.m_123343_();
            int quartX = QuartPos.m_175400_((int)nextBlockX);
            int quartZ = QuartPos.m_175400_((int)nextBlockZ);
            if (ACBiomeRarity.isQuartInRareBiome(this.serverLevel.m_7328_(), quartX, quartZ)) {
                for (int blockY : searchedHeights) {
                    int quartY = QuartPos.m_175400_((int)blockY);
                    Biome biome = (Biome)source.m_203407_(quartX, quartY, quartZ, sampler).get();
                    if (!CaveBiomeMapWorldWorker.verifyBiomeRespectRegistry((Level)this.serverLevel, biome, this.biomeResourceKey)) continue;
                    this.lastBiomePos = new BlockPos(nextBlockX, blockY, nextBlockZ);
                }
            }
            this.width += SAMPLE_INCREMENT;
            if (this.width >= this.nextWidth) {
                if (this.sampleDirection == Direction.UP) {
                    this.sampleDirection = Direction.NORTH;
                } else {
                    this.nextWidth += SAMPLE_INCREMENT;
                    this.sampleDirection = this.sampleDirection.m_122427_();
                }
                this.width = 0;
            }
            this.lastSampledPos = this.nextPos.m_7949_();
            if (this.lastBiomePos == null) {
                return true;
            }
        }
        if (!this.complete) {
            this.onWorkComplete(this.lastBiomePos);
            this.complete = true;
        }
        return false;
    }

    public void onWorkComplete(@Nullable BlockPos biomeCorner) {
        if (!this.complete) {
            CompoundTag tag = this.map.m_41784_();
            if (biomeCorner != null) {
                BlockPos centered = this.calculateBiomeCenter(biomeCorner);
                this.fillOutMapColors(centered, tag);
                tag.m_128405_("BiomeX", centered.m_123341_());
                tag.m_128405_("BiomeY", centered.m_123342_());
                tag.m_128405_("BiomeZ", centered.m_123343_());
                tag.m_128356_("RandomSeed", this.serverLevel.m_213780_().m_188505_());
                tag.m_128379_("Filled", true);
                AlexsCaves.LOGGER.info("Found {} at {} {} {} in {}s", new Object[]{this.biomeResourceKey.m_135782_(), centered.m_123341_(), centered.m_123342_(), centered.m_123343_(), this.stopwatch.elapsed().toSeconds()});
            } else {
                int distance = 0;
                if (this.lastSampledPos != null) {
                    distance = (int)Math.sqrt(this.center.m_123331_((Vec3i)this.lastSampledPos));
                }
                this.player.m_213846_((Component)Component.m_237110_((String)"item.alexscaves.cave_map.error", (Object[])new Object[]{distance}).m_130940_(ChatFormatting.RED));
                AlexsCaves.LOGGER.info("Could not find {} after {}s", (Object)this.biomeResourceKey.m_135782_(), (Object)this.stopwatch.elapsed().toSeconds());
            }
            tag.m_128379_("Loading", false);
            tag.m_128473_("MapUUID");
            this.map.m_41751_(tag);
            AlexsCaves.sendMSGToAll(new UpdateCaveBiomeMapTagMessage(this.player.m_20148_(), this.getTaskUUID(), tag));
        }
        this.complete = true;
    }

    @Nullable
    public BlockPos getLastFoundBiome() {
        return this.lastBiomePos;
    }

    private static boolean verifyBiomeRespectRegistry(Level level, Biome biome, ResourceKey<Biome> matches) {
        Optional biomeRegistry = level.m_9598_().m_6632_(ForgeRegistries.Keys.BIOMES);
        if (biomeRegistry.isPresent()) {
            Optional resourceKey = ((Registry)biomeRegistry.get()).m_7854_((Object)biome);
            return resourceKey.isPresent() && ((ResourceKey)resourceKey.get()).equals(matches);
        }
        return false;
    }

    private BlockPos calculateBiomeCenter(BlockPos biomeCorner) {
        BlockPos yCentered;
        ServerChunkCache cache = this.serverLevel.m_7726_();
        BiomeSource source = cache.m_8481_().m_62218_();
        Climate.Sampler sampler = cache.m_214994_().m_224579_();
        int biomeNorth = 0;
        int biomeSouth = 0;
        int biomeEast = 0;
        int biomeWest = 0;
        if (this.mapBiomeBeneathSurfaceOnly()) {
            int iterations = 0;
            yCentered = biomeCorner;
            while (iterations < 256 && this.getNoiseBiomeAtPos(source, yCentered, sampler).m_203565_(this.biomeResourceKey)) {
                ++iterations;
                yCentered = yCentered.m_7494_();
            }
            yCentered = yCentered.m_6625_(10);
        } else {
            int biomeUp;
            int biomeDown = 0;
            for (biomeUp = 0; biomeUp < 32 && this.getNoiseBiomeAtPos(source, biomeCorner.m_6630_(biomeUp), sampler).m_203565_(this.biomeResourceKey); biomeUp += 8) {
            }
            while (biomeDown < 64 && this.getNoiseBiomeAtPos(source, biomeCorner.m_6625_(biomeDown), sampler).m_203565_(this.biomeResourceKey)) {
                biomeDown += 8;
            }
            yCentered = biomeCorner.m_175288_((int)Math.floor((float)biomeUp * 0.25f) - biomeDown);
        }
        while (biomeNorth < 800 && this.getNoiseBiomeAtPos(source, yCentered.m_122013_(biomeNorth), sampler).m_203565_(this.biomeResourceKey)) {
            biomeNorth += 8;
        }
        while (biomeSouth < 800 && this.getNoiseBiomeAtPos(source, yCentered.m_122020_(biomeSouth), sampler).m_203565_(this.biomeResourceKey)) {
            biomeSouth += 8;
        }
        while (biomeEast < 800 && this.getNoiseBiomeAtPos(source, yCentered.m_122030_(biomeEast), sampler).m_203565_(this.biomeResourceKey)) {
            biomeEast += 8;
        }
        while (biomeWest < 800 && this.getNoiseBiomeAtPos(source, yCentered.m_122025_(biomeWest), sampler).m_203565_(this.biomeResourceKey)) {
            biomeWest += 8;
        }
        return yCentered.m_7918_(biomeEast - biomeWest, 0, biomeSouth - biomeNorth);
    }

    private Holder<Biome> getNoiseBiomeAtPos(BiomeSource source, BlockPos pos, Climate.Sampler sampler) {
        return source.m_203407_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2, sampler);
    }

    private void fillOutMapColors(BlockPos first, CompoundTag tag) {
        Registry registry = this.serverLevel.m_9598_().m_6632_(Registries.f_256952_).orElse(null);
        byte[] arr = new byte[16384];
        HashMap<Integer, Byte> biomeMap = new HashMap<Integer, Byte>();
        ServerChunkCache cache = this.serverLevel.m_7726_();
        BiomeSource source = cache.m_8481_().m_62218_();
        Climate.Sampler sampler = cache.m_214994_().m_224579_();
        if (registry != null) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int scale = 7;
            int j = first.m_123341_();
            int k = first.m_123343_();
            int l = j / scale - 64;
            int i1 = k / scale - 64;
            for (int j1 = 0; j1 < 128; ++j1) {
                for (int k1 = 0; k1 < 128; ++k1) {
                    byte biomeHash;
                    int id;
                    mutableBlockPos.m_122178_((l + k1) * scale, first.m_123342_(), (i1 + j1) * scale);
                    Holder holder1 = null;
                    if (this.mapBiomeBeneathSurfaceOnly()) {
                        mutableBlockPos.m_142448_(first.m_123342_() - 5);
                        holder1 = source.m_203407_(mutableBlockPos.m_123341_() >> 2, mutableBlockPos.m_123342_() >> 2, mutableBlockPos.m_123343_() >> 2, sampler);
                    } else {
                        for (int yUpFromBottom = this.serverLevel.m_141937_() + 1; yUpFromBottom < this.serverLevel.m_5736_(); yUpFromBottom += 32) {
                            mutableBlockPos.m_142448_(yUpFromBottom);
                            holder1 = source.m_203407_(mutableBlockPos.m_123341_() >> 2, mutableBlockPos.m_123342_() >> 2, mutableBlockPos.m_123343_() >> 2, sampler);
                            if (holder1.m_203565_(this.biomeResourceKey)) break;
                        }
                    }
                    int n = id = holder1 == null ? 0 : registry.m_7447_((Object)((Biome)holder1.m_203334_()));
                    if (biomeMap.containsKey(id)) {
                        biomeHash = (Byte)biomeMap.get(id);
                    } else {
                        biomeHash = (byte)biomeMap.size();
                        biomeMap.put(id, biomeHash);
                    }
                    arr[j1 * 128 + k1] = biomeHash;
                }
            }
        }
        ListTag listTag = new ListTag();
        for (Map.Entry entry : biomeMap.entrySet()) {
            CompoundTag biomeEntryTag = new CompoundTag();
            biomeEntryTag.m_128405_("BiomeID", ((Integer)entry.getKey()).intValue());
            biomeEntryTag.m_128405_("BiomeHash", (int)((Byte)entry.getValue()).byteValue());
            listTag.add((Object)biomeEntryTag);
        }
        tag.m_128365_("MapBiomeList", (Tag)listTag);
        tag.m_128382_("MapBiomes", arr);
    }

    private boolean mapBiomeBeneathSurfaceOnly() {
        return this.biomeResourceKey.equals(ACBiomeRegistry.ABYSSAL_CHASM);
    }

    public UUID getTaskUUID() {
        return this.taskUUID;
    }
}

