/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearSirenBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.RaycatEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.ActivatesSirens;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class NucleeperEntity
extends Monster
implements ActivatesSirens,
PowerableMob {
    private float closeProgress;
    private float prevCloseProgress;
    private float explodeProgress;
    private float prevExplodeProgress;
    private float sirenAngle;
    private float prevSirenAngle;
    private int catScareTime = 0;
    private boolean spawnedExplosion = false;
    private static final EntityDataAccessor<Boolean> TRIGGERED = SynchedEntityData.m_135353_(NucleeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CLOSE_TIME = SynchedEntityData.m_135353_(NucleeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EXPLODING = SynchedEntityData.m_135353_(NucleeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(NucleeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public NucleeperEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal<RaycatEntity>((PathfinderMob)this, RaycatEntity.class, 10.0f, 1.0, 1.2){

            public void m_8037_() {
                super.m_8037_();
                NucleeperEntity.this.catScareTime = 20;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRIGGERED, (Object)false);
        this.f_19804_.m_135372_(CLOSE_TIME, (Object)0);
        this.f_19804_.m_135372_(EXPLODING, (Object)false);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
    }

    public int getCloseTime() {
        return (Integer)this.f_19804_.m_135370_(CLOSE_TIME);
    }

    public void setCloseTime(int time) {
        this.f_19804_.m_135381_(CLOSE_TIME, (Object)time);
    }

    public boolean isTriggered() {
        return (Boolean)this.f_19804_.m_135370_(TRIGGERED);
    }

    public void setTriggered(boolean triggered) {
        this.f_19804_.m_135381_(TRIGGERED, (Object)triggered);
    }

    public boolean isExploding() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODING);
    }

    public void setExploding(boolean explode) {
        this.f_19804_.m_135381_(EXPLODING, (Object)explode);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean explode) {
        this.f_19804_.m_135381_(CHARGED, (Object)explode);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Charged", this.isCharged());
        compoundTag.m_128405_("CloseTime", this.getCloseTime());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCharged(compoundTag.m_128471_("Charged"));
        this.setCloseTime(compoundTag.m_128451_("CloseTime"));
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        super.m_8038_(serverLevel, lightningBolt);
        this.setCharged(true);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_204117_(ItemTags.f_262757_)) {
            SoundEvent soundevent = itemstack.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.setTriggered(true);
                itemstack.m_41622_(1, (LivingEntity)player, p_32290_ -> p_32290_.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevCloseProgress = this.closeProgress;
        this.prevExplodeProgress = this.explodeProgress;
        this.prevSirenAngle = this.sirenAngle;
        int time = this.getCloseTime();
        if (this.isExploding() && this.explodeProgress < 5.0f) {
            this.explodeProgress += 1.0f;
        }
        if (!this.isExploding() && this.explodeProgress > 0.0f) {
            this.explodeProgress -= 1.0f;
        }
        if (this.isTriggered() && !this.m_9236_().f_46443_) {
            Level level;
            if (this.catScareTime > 0 && !this.isExploding()) {
                if (time > 0) {
                    this.setCloseTime(time - 1);
                } else {
                    this.setTriggered(false);
                }
            } else if (time < (Integer)AlexsCaves.COMMON_CONFIG.nucleeperFuseTime.get()) {
                this.setCloseTime(time + 1);
            } else if (this.m_6084_()) {
                this.setExploding(true);
            }
            if ((this.f_19797_ + this.m_19879_()) % 10 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.getNearbySirens(serverLevel, 256).forEach(this::activateSiren);
            }
        }
        if (this.isTriggered() && this.m_6084_()) {
            AlexsCaves.PROXY.playWorldSound(this, (byte)1);
        }
        this.sirenAngle += (10.0f + 30.0f * this.closeProgress) % 360.0f;
        this.closeProgress = (float)time / (float)((Integer)AlexsCaves.COMMON_CONFIG.nucleeperFuseTime.get()).intValue();
        if (this.catScareTime > 0) {
            --this.catScareTime;
        }
        if (this.isExploding() && this.explodeProgress >= 5.0f) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_ && !this.spawnedExplosion) {
                this.explode();
                this.spawnedExplosion = true;
            }
        }
        if (this.isCharged() && this.m_6084_() && this.f_19797_ % 150 == 0) {
            this.m_5634_(1.0f);
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    private Stream<BlockPos> getNearbySirens(ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.NUCLEAR_SIREN.getKey()), (Predicate)Predicates.alwaysTrue(), this.m_20183_(), range, PoiManager.Occupancy.ANY);
    }

    private void activateSiren(BlockPos pos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof NuclearSirenBlockEntity) {
            NuclearSirenBlockEntity nuclearSirenBlock = (NuclearSirenBlockEntity)blockEntity;
            nuclearSirenBlock.setNearestNuclearBomb((Entity)this);
        }
    }

    private void explode() {
        NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(this.m_9236_());
        explosion.m_20359_((Entity)this);
        explosion.setSize(this.isCharged() ? 1.75f : 1.0f);
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            explosion.setNoGriefing(true);
        }
        this.m_9236_().m_7967_((Entity)explosion);
    }

    public float getCloseProgress(float partialTick) {
        return this.prevCloseProgress + (this.closeProgress - this.prevCloseProgress) * partialTick;
    }

    public float getSirenAngle(float partialTick) {
        return this.prevSirenAngle + (this.sirenAngle - this.prevSirenAngle) * partialTick;
    }

    public float getExplodeProgress(float partialTick) {
        return (this.prevExplodeProgress + (this.explodeProgress - this.prevExplodeProgress) * partialTick) * 0.2f;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(flying ? this.m_20186_() - this.f_19855_ : 0.0), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 8.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getStepHeight() {
        return 1.1f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.NUCLEEPER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.NUCLEEPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.NUCLEEPER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.NUCLEEPER_STEP.get(), 1.0f, 1.0f);
        }
    }

    protected void m_7472_(DamageSource damageSource, int experience, boolean idk) {
        super.m_7472_(damageSource, experience, idk);
        if (damageSource.m_276093_(ACDamageTypes.TREMORZILLA_BEAM)) {
            this.m_19998_((ItemLike)ACItemRegistry.MUSIC_DISC_FUSION_FRAGMENT.get());
        }
    }

    @Override
    public boolean shouldStopBlaringSirens() {
        return !this.isTriggered() && !this.isExploding() || this.m_213877_();
    }

    public boolean m_7090_() {
        return this.isCharged();
    }

    private class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = NucleeperEntity.this.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8037_() {
            LivingEntity target = NucleeperEntity.this.m_5448_();
            if (target != null && target.m_6084_()) {
                NucleeperEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
                if (NucleeperEntity.this.m_20270_((Entity)target) < 3.5f + target.m_20205_()) {
                    NucleeperEntity.this.setTriggered(true);
                }
            }
        }
    }
}

