/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BoundroidWinchEntity
extends Monster {
    private static final EntityDataAccessor<Optional<UUID>> HEAD_UUID = SynchedEntityData.m_135353_(BoundroidWinchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> HEAD_ID = SynchedEntityData.m_135353_(BoundroidWinchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> LATCHED = SynchedEntityData.m_135353_(BoundroidWinchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float MAX_DIST_TO_CEILING = 2.9f;
    private float latchProgress;
    private float prevLatchProgress;
    private float distanceToCeiling;
    private boolean goingUp;
    private int lastStepTimestamp = -1;
    private boolean isUpsideDownNavigator = false;
    private int noLatchCooldown = 0;
    private int changeLatchStateTime = 0;

    public BoundroidWinchEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(false);
    }

    public BoundroidWinchEntity(BoundroidEntity parent) {
        this((EntityType)ACEntityRegistry.BOUNDROID_WINCH.get(), parent.m_9236_());
        this.setHeadUUID(parent.m_20148_());
        this.m_146884_(parent.m_20182_().m_82520_(0.0, 0.5, 0.0));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new FindShelterGoal());
        this.f_21345_.m_25352_(3, (Goal)new WanderUpsideDownGoal());
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    public boolean m_8023_() {
        return this.getHead() != null;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Entity body = this.getHead();
        if (this.m_6673_(source)) {
            return false;
        }
        if (body != null && !body.m_6673_(source)) {
            boolean flag = body.m_6469_(source, damage);
            if (flag) {
                this.noLatchCooldown = 60 + this.f_19796_.m_188503_(60);
            }
            return flag;
        }
        return super.m_6469_(source, damage);
    }

    public void linkWithHead(Entity head) {
        this.setHeadUUID(head.m_20148_());
        this.f_19804_.m_135381_(HEAD_ID, (Object)head.m_19879_());
    }

    public boolean isLatched() {
        return (Boolean)this.f_19804_.m_135370_(LATCHED);
    }

    public void setLatched(boolean latched) {
        this.f_19804_.m_135381_(LATCHED, (Object)latched);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("HeadUUID")) {
            this.setHeadUUID(compound.m_128342_("HeadUUID"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getHeadUUID() != null) {
            compound.m_128362_("BodyUUID", this.getHeadUUID());
        }
    }

    private void switchNavigator(boolean clinging) {
        if (clinging) {
            this.f_21342_ = new CeilingMoveControl();
            this.f_21344_ = this.createCeilingNavigator(this.m_9236_());
            this.isUpsideDownNavigator = true;
        } else {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isUpsideDownNavigator = false;
        }
    }

    protected PathNavigation createCeilingNavigator(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                int airAbove = 0;
                while (BoundroidWinchEntity.this.m_9236_().m_8055_(pos).m_60795_() && (float)airAbove < 3.9f) {
                    pos = pos.m_7494_();
                    ++airAbove;
                }
                return (float)airAbove < Math.min(2.9f, (float)BoundroidWinchEntity.this.f_19796_.m_188503_(2));
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        return flyingpathnavigation;
    }

    public void m_8119_() {
        Entity head;
        super.m_8119_();
        this.prevLatchProgress = this.latchProgress;
        if (this.isLatched() && this.latchProgress < 5.0f) {
            this.latchProgress += 1.0f;
        }
        if (!this.isLatched() && this.latchProgress > 0.0f) {
            this.latchProgress -= 1.0f;
        }
        if (this.noLatchCooldown > 0) {
            --this.noLatchCooldown;
        }
        double d1 = this.m_20185_() - this.f_19854_;
        double d2 = this.m_20189_() - this.f_19856_;
        double d3 = Math.sqrt(d1 * d1 + d2 * d2);
        if (this.isLatched() && this.f_19863_ && d3 > (double)0.1f && this.f_19797_ - this.lastStepTimestamp > 6) {
            this.lastStepTimestamp = this.f_19797_;
            BlockState state = this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20191_().f_82292_ + 0.5), (double)this.m_20189_()));
            this.m_5496_(state.m_60827_().m_56776_(), 1.0f, 0.5f);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isLatched() && !this.isUpsideDownNavigator) {
                this.switchNavigator(true);
            }
            if (!this.isLatched() && this.isUpsideDownNavigator) {
                this.switchNavigator(false);
            }
        }
        if ((head = this.getHead()) instanceof BoundroidEntity) {
            BoundroidEntity boundroid = (BoundroidEntity)head;
            if (!this.m_9236_().f_46443_) {
                float pullSpeed;
                this.f_19804_.m_135381_(HEAD_ID, (Object)head.m_19879_());
                double distance = this.m_20270_((Entity)boundroid);
                double distanceGoal = this.isLatched() ? 1.25 + Math.sin((float)this.f_19797_ * 0.1f) * 0.25 : 3.5;
                boolean headNoClip = false;
                float f = pullSpeed = boundroid.m_5448_() != null ? 0.3f : 0.1f;
                if (!boundroid.m_142582_((Entity)this) && !boundroid.stopPullingUp() && distance > 7.0) {
                    headNoClip = true;
                }
                if (distance > distanceGoal && !boundroid.stopPullingUp()) {
                    double disRem = Math.min(distance - distanceGoal, 1.0);
                    Vec3 moveTo = this.getChainFrom(1.0f).m_82546_(boundroid.m_20182_());
                    if (moveTo.m_82553_() > 1.0) {
                        moveTo = moveTo.m_82541_();
                    }
                    boundroid.draggedClimable = true;
                    boundroid.m_20256_(boundroid.m_20184_().m_82542_((double)0.95f, (double)0.7f, (double)0.95f).m_82549_(moveTo.m_82490_(disRem * (double)pullSpeed)));
                } else {
                    boundroid.draggedClimable = false;
                }
                this.distanceToCeiling = this.calculateDistanceToCeiling();
                if (this.isLatched()) {
                    this.m_20242_(true);
                    this.changeLatchStateTime = this.distanceToCeiling > 2.9f || !this.m_6084_() || this.noLatchCooldown > 0 ? ++this.changeLatchStateTime : 0;
                    if (this.changeLatchStateTime > 5) {
                        this.setLatched(false);
                        if (this.noLatchCooldown > 0) {
                            this.m_5496_((SoundEvent)ACSoundRegistry.BOUNDROID_DAZED.get(), 2.0f, 1.0f);
                        }
                        this.changeLatchStateTime = 0;
                    }
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.14, 0.0).m_82490_((double)0.85f));
                    this.goingUp = false;
                    boundroid.stopGravity = true;
                } else {
                    this.m_20242_(false);
                    boundroid.stopGravity = false;
                    this.changeLatchStateTime = (this.distanceToCeiling < 2.9f || this.f_19863_ && !this.f_201939_) && this.noLatchCooldown <= 0 ? ++this.changeLatchStateTime : 0;
                    if (this.changeLatchStateTime > 5) {
                        this.setLatched(true);
                        this.changeLatchStateTime = 0;
                    }
                    if (this.goingUp && !this.hasBlockAbove()) {
                        this.goingUp = false;
                    }
                    if (this.goingUp) {
                        this.m_20256_(new Vec3(this.m_20184_().f_82479_, 1.5, this.m_20184_().f_82481_));
                    } else if (this.m_20096_() && this.noLatchCooldown == 0 && this.m_6084_() && this.f_19796_.m_188503_(30) == 0 && this.distanceToCeiling > 2.9f && this.hasBlockAbove()) {
                        this.goingUp = true;
                    }
                }
                boundroid.f_19794_ = headNoClip;
            }
            if (boundroid.f_20916_ > 0 || boundroid.f_20919_ > 0) {
                this.f_20916_ = boundroid.f_20916_;
                this.f_20919_ = boundroid.f_20919_;
            }
        } else if (!this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private boolean hasBlockAbove() {
        if (!this.m_9236_().m_45527_(this.m_20183_())) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_());
            while (mutableBlockPos.m_123342_() < this.m_9236_().m_151558_()) {
                if (this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280296_()) {
                    return true;
                }
                mutableBlockPos.m_122184_(0, 1, 0);
            }
        }
        return false;
    }

    public float getLatchProgress(float partialTicks) {
        return (this.prevLatchProgress + (this.latchProgress - this.prevLatchProgress) * partialTicks) * 0.2f;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getChainLength(float partialTick) {
        return (float)this.getChainTo(partialTick).m_82546_(this.getChainFrom(partialTick)).m_82553_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD_UUID, Optional.empty());
        this.f_19804_.m_135372_(HEAD_ID, (Object)-1);
        this.f_19804_.m_135372_(LATCHED, (Object)false);
    }

    @Nullable
    public UUID getHeadUUID() {
        return ((Optional)this.f_19804_.m_135370_(HEAD_UUID)).orElse(null);
    }

    public void setHeadUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(HEAD_UUID, Optional.ofNullable(uniqueId));
    }

    public Vec3 getChainFrom(float partialTicks) {
        return this.m_20318_(partialTicks).m_82520_(0.0, 0.0, 0.0);
    }

    public Vec3 getChainTo(float partialTicks) {
        Entity entity = this.getHead();
        if (entity instanceof BoundroidEntity) {
            BoundroidEntity boundroid = (BoundroidEntity)entity;
            return boundroid.m_20318_(partialTicks).m_82520_(0.0, (double)boundroid.m_20206_(), 0.0);
        }
        return this.m_20318_(partialTicks).m_82520_(0.0, 0.3, 0.0);
    }

    public Entity getHead() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getHeadUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(HEAD_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.isLatched()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            super.m_7023_(travelVector);
        }
    }

    private float calculateDistanceToCeiling() {
        BlockPos ceiling = this.getCeilingOf(this.m_20183_());
        return (float)((double)ceiling.m_123342_() - this.m_20191_().f_82292_);
    }

    public BlockPos getCeilingOf(BlockPos usPos) {
        while (!this.m_9236_().m_8055_(usPos).m_60783_((BlockGetter)this.m_9236_(), usPos, Direction.DOWN) && usPos.m_123342_() < this.m_9236_().m_151558_()) {
            usPos = usPos.m_7494_();
        }
        return usPos;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.MAGNETIZING.get();
    }

    private class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Entity entity = BoundroidWinchEntity.this.getHead();
            if (entity instanceof BoundroidEntity) {
                BoundroidEntity boundroid = (BoundroidEntity)entity;
                LivingEntity target = boundroid.m_5448_();
                return target != null && target.m_6084_();
            }
            return false;
        }

        public void m_8041_() {
            Entity entity = BoundroidWinchEntity.this.getHead();
            if (entity instanceof BoundroidEntity) {
                BoundroidEntity boundroid = (BoundroidEntity)entity;
                boundroid.setScared(false);
            }
        }

        public void m_8037_() {
            BoundroidEntity boundroid;
            LivingEntity target;
            Entity entity = BoundroidWinchEntity.this.getHead();
            if (entity instanceof BoundroidEntity && (target = (boundroid = (BoundroidEntity)entity).m_5448_()) != null && target.m_6084_()) {
                if (BoundroidWinchEntity.this.isLatched()) {
                    boundroid.setScared(false);
                    BlockPos lowestPos = BoundroidWinchEntity.this.getCeilingOf(target.m_20183_());
                    BoundroidWinchEntity.this.m_21573_().m_26519_((double)lowestPos.m_123341_(), (double)lowestPos.m_123342_(), (double)lowestPos.m_123343_(), 1.0);
                } else {
                    Vec3 vec;
                    if (BoundroidWinchEntity.this.m_21573_().m_26571_() && (vec = LandRandomPos.m_148521_((PathfinderMob)BoundroidWinchEntity.this, (int)15, (int)7, (Vec3)target.m_20182_())) != null) {
                        BoundroidWinchEntity.this.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.3);
                    }
                    boundroid.setScared(true);
                }
            }
        }
    }

    class FindShelterGoal
    extends Goal {
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public FindShelterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!BoundroidWinchEntity.this.m_9236_().m_45527_(BoundroidWinchEntity.this.m_20183_()) && BoundroidWinchEntity.this.m_217043_().m_188503_(20) != 0) {
                return false;
            }
            return this.setWantedPos();
        }

        protected boolean setWantedPos() {
            Vec3 vec3 = this.getHidePos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !BoundroidWinchEntity.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            BoundroidWinchEntity.this.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, 1.0);
        }

        @Nullable
        protected Vec3 getHidePos() {
            RandomSource randomsource = BoundroidWinchEntity.this.m_217043_();
            BlockPos blockpos = BoundroidWinchEntity.this.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(20) - 10, randomsource.m_188503_(6) - 3, randomsource.m_188503_(20) - 10);
                if (BoundroidWinchEntity.this.m_9236_().m_45527_(blockpos1) || !(BoundroidWinchEntity.this.m_21692_(blockpos1) < 0.0f)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    class WanderUpsideDownGoal
    extends RandomStrollGoal {
        private int stillTicks;

        public WanderUpsideDownGoal() {
            super((PathfinderMob)BoundroidWinchEntity.this, 1.0, 10);
            this.stillTicks = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (BoundroidWinchEntity.this.isLatched()) {
                int distance = 16;
                int i = 0;
                if (i < 15) {
                    Random rand = new Random();
                    BlockPos randPos = BoundroidWinchEntity.this.m_20183_().m_7918_(rand.nextInt(distance * 2) - distance, -5, rand.nextInt(distance * 2) - distance);
                    BlockPos lowestPos = BoundroidWinchEntity.this.getCeilingOf(randPos).m_7495_();
                    return Vec3.m_82512_((Vec3i)lowestPos);
                }
                return null;
            }
            return super.m_7037_();
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && BoundroidWinchEntity.this.f_19796_.m_188503_(100) != 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.f_25726_ = 0.0;
            this.f_25727_ = 0.0;
            this.f_25728_ = 0.0;
        }

        public void m_8056_() {
            this.stillTicks = 0;
            this.f_25725_.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, this.f_25729_);
        }
    }

    class CeilingMoveControl
    extends MoveControl {
        private final Mob parentEntity;

        public CeilingMoveControl() {
            super((Mob)BoundroidWinchEntity.this);
            this.parentEntity = BoundroidWinchEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.035 / d0);
                float verticalSpeed = 0.15f;
                float y = this.parentEntity.f_19862_ ? -0.2f : (this.parentEntity.f_19863_ ? 0.2f : 1.2f);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82490_((double)0.95f).m_82520_(0.0, (double)y, 0.0).m_82549_(vector3d1.m_82542_(1.0, (double)verticalSpeed, 1.0)));
                if (this.parentEntity.m_5448_() != null) {
                    double d1 = this.parentEntity.m_5448_().m_20189_() - this.parentEntity.m_20189_();
                    double d3 = this.parentEntity.m_5448_().m_20186_() - this.parentEntity.m_20186_();
                    double d2 = this.parentEntity.m_5448_().m_20185_() - this.parentEntity.m_20185_();
                    float f = Mth.m_14116_((float)((float)(d2 * d2 + d1 * d1)));
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                    this.parentEntity.m_146926_((float)(Mth.m_14136_((double)d3, (double)f) * 57.2957763671875));
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                } else if (d0 >= width) {
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                }
            }
        }
    }
}

