/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.GeothermalVentBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GeothermalVentBlockEntity
extends BlockEntity {
    private static final double PARTICLE_DIST = 14400.0;
    private int soundTime = 0;

    public GeothermalVentBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.GEOTHERMAL_VENT.get(), pos, state);
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, GeothermalVentBlockEntity blockEntity) {
        Player player = AlexsCaves.PROXY.getClientSidePlayer();
        if (player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 14400.0 || level.f_46441_.m_188499_()) {
            return;
        }
        int smokeType = (Integer)state.m_61143_((Property)GeothermalVentBlock.SMOKE_TYPE);
        SimpleParticleType particle = ParticleTypes.f_123762_;
        switch (smokeType) {
            case 1: {
                particle = level.f_46441_.m_188503_(3) == 0 ? ParticleTypes.f_123759_ : (ParticleOptions)ACParticleRegistry.WHITE_VENT_SMOKE.get();
                break;
            }
            case 2: {
                particle = level.f_46441_.m_188503_(3) == 0 ? ParticleTypes.f_123765_ : (ParticleOptions)ACParticleRegistry.BLACK_VENT_SMOKE.get();
                break;
            }
            case 3: {
                particle = level.f_46441_.m_188503_(3) == 0 ? (ParticleOptions)ACParticleRegistry.ACID_BUBBLE.get() : (ParticleOptions)ACParticleRegistry.GREEN_VENT_SMOKE.get();
            }
        }
        float x = (level.f_46441_.m_188501_() - 0.5f) * 0.25f;
        float z = (level.f_46441_.m_188501_() - 0.5f) * 0.25f;
        level.m_6485_((ParticleOptions)particle, true, (double)((float)pos.m_123341_() + 0.5f + x), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f + z), (double)(x * 0.15f), (double)(0.03f + level.f_46441_.m_188501_() * 0.2f), (double)(z * 0.15f));
        if (blockEntity.soundTime-- <= 0) {
            blockEntity.soundTime = level.m_213780_().m_188503_(20) + 30;
            boolean underwater = !state.m_60819_().m_76178_() || !level.m_8055_(pos.m_7494_()).m_60819_().m_76178_();
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, underwater ? (SoundEvent)ACSoundRegistry.GEOTHERMAL_VENT_BUBBLE_UNDERWATER.get() : (SoundEvent)ACSoundRegistry.GEOTHERMAL_VENT_BUBBLE.get(), SoundSource.BLOCKS, underwater ? 2.5f : 1.5f, level.f_46441_.m_188501_() * 0.4f + 0.8f, false);
        }
    }
}

