/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.FallingFrostmintEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.FrostmintExplosion;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class FrostmintBlock
extends SlabBlock
implements Fallable {
    public FrostmintBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_60913_(1.0f, 1.5f).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASS));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos1) {
        levelAccessor.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
        return super.m_7417_(blockState, direction, blockState1, levelAccessor, pos, pos1);
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos blockPos = blockHitResult.m_82425_();
        while (level.m_8055_(blockPos.m_7495_()).m_60713_((Block)this) && blockPos.m_123342_() > level.m_141937_()) {
            blockPos = blockPos.m_7495_();
        }
        level.m_186460_(blockPos, (Block)this, this.getDelayAfterPlace());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        if ((FrostmintBlock.isFree(level.m_8055_(blockPos.m_7495_())) || state.m_61143_((Property)f_56353_) == SlabType.TOP) && blockPos.m_123342_() >= level.m_141937_()) {
            FallingFrostmintEntity.fall((Level)level, blockPos, state);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState blockState, boolean b) {
        level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
    }

    public static boolean isFree(BlockState belowState) {
        if (belowState.m_60734_() instanceof FrostmintBlock && belowState.m_61143_((Property)f_56353_) == SlabType.BOTTOM) {
            return true;
        }
        return FallingBlock.m_53241_((BlockState)belowState);
    }

    public void m_142525_(Level level, BlockPos fallenOn, FallingBlockEntity fallingBlockEntity) {
    }

    public void m_48792_(Level level, BlockPos blockPos, BlockState blockState, BlockState blockState1, FallingBlockEntity fallingBlockEntity) {
        if (blockState1.m_60819_().getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get() && !level.f_46443_) {
            FrostmintExplosion explosion = new FrostmintExplosion(level, (Entity)fallingBlockEntity, (float)blockPos.m_123341_() + 0.5f, (float)blockPos.m_123342_() + 0.5f, (float)blockPos.m_123343_() + 0.5f, 4.0f, Explosion.BlockInteraction.DESTROY_WITH_DECAY, false);
            explosion.explode();
            explosion.finalizeExplosion(true);
            for (Player player : level.m_45976_(Player.class, new AABB(blockPos.m_7918_(-32, -16, -32), blockPos.m_7918_(32, 16, 32)))) {
                ACAdvancementTriggerRegistry.FROSTMINT_EXPLOSION.triggerForEntity((Entity)player);
            }
        }
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
    }
}

