/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class WatcherModel
extends AdvancedEntityModel<WatcherEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox head;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox rwing;
    private final AdvancedModelBox cube_r2;
    private final AdvancedModelBox lwing;
    private final AdvancedModelBox cube_r3;
    private final AdvancedModelBox lhorn;
    private final AdvancedModelBox rhorn;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox lleg;
    private final ModelAnimator animator;

    public WatcherModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, -2.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 5.125f, -0.5f);
        this.root.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(67, 61).addBox(-4.0f, -5.125f, -2.5f, 8.0f, 12.0f, 5.0f, 0.0f, false);
        this.body.setTextureOffset(27, 22).addBox(-5.0f, -5.875f, -3.5f, 10.0f, 22.0f, 7.0f, 0.25f, false);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(-5.1667f, -4.4583f, 0.0f);
        this.body.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(16, 61).addBox(-4.3333f, -0.6667f, -3.0f, 4.0f, 5.0f, 6.0f, 0.25f, false);
        this.larm.setTextureOffset(56, 46).addBox(-3.3333f, 0.3333f, -2.5f, 3.0f, 15.0f, 5.0f, 0.24f, false);
        this.larm.setTextureOffset(36, 65).addBox(-3.3333f, 15.3333f, -2.5f, 3.0f, 4.0f, 5.0f, 0.0f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(5.1667f, -4.4583f, 0.0f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(16, 61).addBox(0.3333f, -0.6667f, -3.0f, 4.0f, 5.0f, 6.0f, 0.25f, true);
        this.rarm.setTextureOffset(56, 46).addBox(0.3333f, 0.3333f, -2.5f, 3.0f, 15.0f, 5.0f, 0.24f, true);
        this.rarm.setTextureOffset(36, 65).addBox(0.3333f, 15.3333f, -2.5f, 3.0f, 4.0f, 5.0f, 0.0f, true);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -5.125f, 0.5f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(72, 45).addBox(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 7.0f, 0.0f, false);
        this.head.setTextureOffset(34, 0).addBox(-5.0f, -10.0f, -4.0f, 10.0f, 9.0f, 7.0f, 0.26f, false);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, -10.25f, -4.25f);
        this.head.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.7854f, 0.0f, 0.0f);
        this.cube_r1.setTextureOffset(54, 16).addBox(-2.0f, 0.25f, -7.25f, 4.0f, 4.0f, 7.0f, 0.25f, false);
        this.rwing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rwing.setRotationPoint(0.0f, -5.0f, 3.0f);
        this.head.addChild((BasicModelPart)this.rwing);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.rwing.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, 0.0f, 1.1781f, 0.0f);
        this.cube_r2.setTextureOffset(0, 18).addBox(0.0f, -9.0f, 0.0f, 0.0f, 17.0f, 11.0f, 0.0f, false);
        this.lwing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lwing.setRotationPoint(0.0f, -5.0f, 3.0f);
        this.head.addChild((BasicModelPart)this.lwing);
        this.cube_r3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r3.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.lwing.addChild((BasicModelPart)this.cube_r3);
        this.setRotateAngle(this.cube_r3, 0.0f, -1.1781f, 0.0f);
        this.cube_r3.setTextureOffset(0, 18).addBox(0.0f, -9.0f, 0.0f, 0.0f, 17.0f, 11.0f, 0.0f, true);
        this.lhorn = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lhorn.setRotationPoint(5.25f, -6.0f, 0.0f);
        this.head.addChild((BasicModelPart)this.lhorn);
        this.lhorn.setTextureOffset(0, 61).addBox(0.0f, -11.0f, 0.0f, 8.0f, 15.0f, 0.0f, 0.0f, true);
        this.rhorn = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rhorn.setRotationPoint(-5.25f, -6.0f, 0.0f);
        this.head.addChild((BasicModelPart)this.rhorn);
        this.rhorn.setTextureOffset(0, 61).addBox(-8.0f, -11.0f, 0.0f, 8.0f, 15.0f, 0.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(2.5f, 11.5f, -0.5f);
        this.root.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(61, 27).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 15.0f, 3.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(-2.5f, 11.5f, -0.5f);
        this.root.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(61, 27).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 15.0f, 3.0f, 0.0f, false);
        this.root.rotateAngleY = (float)Math.PI;
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void setupAnim(WatcherEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float runProgress = entity.getRunAmount(partialTick);
        float shadeAmount = entity.getShadeAmount(partialTick);
        float groundAmount = 1.0f - shadeAmount;
        float walkAmount = limbSwingAmount * (1.0f - runProgress);
        float runAmount = limbSwingAmount * runProgress;
        float walkSpeed = 0.5f;
        float walkDegree = 1.0f;
        float runSpeed = 0.5f;
        float runDegree = 1.0f;
        float twitchinessAmount = ACMath.smin((float)Math.sin(ageInTicks * 0.03f) + 0.5f, 0.0f, 0.3f);
        this.progressRotationPrev(this.body, walkAmount, (float)Math.toRadians(-5.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, walkAmount, (float)Math.toRadians(5.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.body, runAmount, (float)Math.toRadians(-15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, runAmount, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, runProgress, (float)Math.toRadians(75.0), (float)Math.toRadians(35.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.larm, runProgress, (float)Math.toRadians(75.0), (float)Math.toRadians(-35.0), 0.0f, 1.0f);
        this.progressPositionPrev(this.body, runAmount * groundAmount, 0.0f, -6.5f, 4.0f, 1.0f);
        this.progressPositionPrev(this.head, runAmount * groundAmount, 0.0f, 1.5f, 2.0f, 1.0f);
        this.swing(this.lwing, 0.2f, 0.25f, false, 1.0f, 0.1f, ageInTicks, 1.0f);
        this.swing(this.rwing, 0.2f, 0.25f, true, 1.0f, 0.1f, ageInTicks, 1.0f);
        this.flap(this.head, 4.0f, 0.1f, false, 0.0f, 0.0f, ageInTicks, twitchinessAmount);
        this.flap(this.larm, 0.1f, 0.1f, false, -0.5f, 0.1f, ageInTicks, 1.0f);
        this.flap(this.rarm, 0.1f, 0.1f, true, -0.5f, 0.1f, ageInTicks, 1.0f);
        this.swing(this.larm, 0.1f, 0.1f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.rarm, 0.1f, 0.1f, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.lleg, walkSpeed, walkDegree * 0.5f, false, 1.0f, -0.1f, limbSwing, walkAmount * groundAmount);
        this.walk(this.rleg, walkSpeed, walkDegree * 0.5f, true, 1.0f, 0.1f, limbSwing, walkAmount * groundAmount);
        this.walk(this.body, walkSpeed * 0.5f, walkDegree * 0.1f, false, -2.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.head, walkSpeed * 0.5f, walkDegree * 0.1f, false, -1.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.larm, walkSpeed * 0.5f, walkDegree * 0.25f, false, -0.5f, 0.1f, limbSwing, walkAmount);
        this.walk(this.rarm, walkSpeed * 0.5f, walkDegree * 0.25f, false, 0.5f, 0.1f, limbSwing, walkAmount);
        this.walk(this.head, runSpeed * 0.5f, runDegree * 0.1f, false, -1.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.lleg, runSpeed, runDegree * 0.5f, false, 4.0f, -0.1f, limbSwing, runAmount * groundAmount);
        this.walk(this.rleg, runSpeed, runDegree * 0.5f, true, 4.0f, 0.1f, limbSwing, runAmount * groundAmount);
        this.walk(this.rarm, runSpeed, runDegree * 0.15f, false, 2.0f, 0.4f, limbSwing, runAmount);
        this.walk(this.larm, runSpeed, runDegree * 0.15f, true, 2.0f, -0.4f, limbSwing, runAmount);
        this.swing(this.root, runSpeed, runDegree * 0.35f, true, 3.0f, 0.0f, limbSwing, runAmount * groundAmount);
        this.swing(this.body, runSpeed, runDegree * 0.25f, false, 3.0f, 0.0f, limbSwing, runAmount);
        this.larm.setScale(1.0f, 1.0f + runAmount * 0.4f, 1.0f);
        this.rarm.setScale(1.0f, 1.0f + runAmount * 0.4f, 1.0f);
        this.walk(this.lleg, walkSpeed, walkDegree * 0.3f, false, -1.0f, -0.1f, limbSwing, limbSwingAmount * shadeAmount);
        this.walk(this.rleg, walkSpeed, walkDegree * 0.3f, false, -2.0f, -0.1f, limbSwing, limbSwingAmount * shadeAmount);
        this.head.rotateAngleY += netHeadYaw / 57.295776f;
        this.head.rotateAngleX -= headPitch / 57.295776f;
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.cube_r1, (Object)this.cube_r2, (Object)this.cube_r3, (Object)this.body, (Object)this.larm, (Object)this.lleg, (Object)this.rarm, (Object)this.rleg, (Object)this.lhorn, (Object)this.rhorn, (Object)this.head, (Object[])new AdvancedModelBox[]{this.rwing, this.lwing});
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(WatcherEntity.ANIMATION_ATTACK_0);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-35.0), (float)Math.toRadians(-60.0), (float)Math.toRadians(-25.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(25.0), 0.0f, (float)Math.toRadians(40.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(25.0), 0.0f, (float)Math.toRadians(-40.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-35.0), (float)Math.toRadians(60.0), (float)Math.toRadians(25.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(WatcherEntity.ANIMATION_ATTACK_1);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -5.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-10.0), (float)Math.toRadians(75.0), (float)Math.toRadians(25.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-10.0), (float)Math.toRadians(-75.0), (float)Math.toRadians(-25.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.rarm, (float)Math.toRadians(0.0), (float)Math.toRadians(-45.0), (float)Math.toRadians(25.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(0.0), (float)Math.toRadians(45.0), (float)Math.toRadians(-25.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void positionForParticle(float partialTick, float v) {
        this.resetToDefaultPose();
    }
}

