/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.compat.trinket;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladiumcore.util.Platform;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsSlotInv;
import net.venturecraft.gliders.common.item.GliderItem;

public class CuriosTrinketsUtil {
    public static final Slot HAT = new Slot("head", "head/hat");
    public static final Slot NECKLACE = new Slot("necklace", "chest/necklace");
    public static final Slot BACK = new Slot("glider", "chest/back");
    public static final Slot BACK_NATIVE = new Slot("back", "chest/back");
    public static final Slot CAPE = new Slot("back", "chest/cape");
    public static final Slot BELT = new Slot("belt", "legs/belt");
    public static final Slot HAND = new Slot("hand", "hand/glove");
    public static final Slot OFFHAND = new Slot("hand", "offhand/glove");
    public static final Slot RING = new Slot("hand", "hand/ring");
    public static final Slot OFFHAND_RING = new Slot("ring", "offhand/ring");
    private static CuriosTrinketsUtil INSTANCE = new CuriosTrinketsUtil();

    public static CuriosTrinketsUtil getInstance() {
        return INSTANCE;
    }

    public static void setInstance(CuriosTrinketsUtil instance) {
        INSTANCE = instance;
    }

    public boolean isTrinkets() {
        return false;
    }

    public boolean isCurios() {
        return false;
    }

    public ItemStack getFirstFoundGlider(LivingEntity livingEntity) {
        return this.findGliders(livingEntity, CuriosTrinketsUtil.BACK.identifier, CuriosTrinketsUtil.CAPE.identifier, CuriosTrinketsUtil.BACK_NATIVE.identifier);
    }

    public ItemStack findGliders(LivingEntity entity, String ... slots) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof GliderItem) {
            return entity.m_6844_(EquipmentSlot.CHEST);
        }
        for (String slot : slots) {
            List<ItemStack> items = this.getItemsInSlot(entity, slot);
            for (ItemStack item : items) {
                Item item2 = item.m_41720_();
                if (!(item2 instanceof GliderItem)) continue;
                GliderItem gliderItem = (GliderItem)item2;
                return item;
            }
        }
        return ItemStack.f_41583_;
    }

    public List<ItemStack> getItemsInSlot(LivingEntity entity, String slot) {
        CuriosTrinketsSlotInv inv = this.getSlot(entity, slot);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            items.add(stack);
        }
        return items;
    }

    public CuriosTrinketsSlotInv getSlot(LivingEntity entity, String slot) {
        return CuriosTrinketsSlotInv.EMPTY;
    }

    public CuriosTrinketsSlotInv getSlot(LivingEntity entity, Slot slot) {
        return this.getSlot(entity, (Platform.isForge() ? slot.getForge() : slot.getFabric()).f_203868_().m_135815_());
    }

    public static class Slot {
        private final TagKey<Item> forge;
        private final TagKey<Item> fabric;
        private final String identifier;

        public Slot(String forge, String fabric) {
            this.forge = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("curios:" + forge));
            this.fabric = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("trinkets:" + fabric));
            this.identifier = Platform.isForge() ? forge : fabric;
        }

        public String identifier() {
            return this.identifier;
        }

        public TagKey<Item> getFabric() {
            return this.fabric;
        }

        public TagKey<Item> getForge() {
            return this.forge;
        }
    }
}

