/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.mixin;

import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.satisfy.vinery.core.item.WinemakerBootsItem;
import net.satisfy.vinery.core.item.WinemakerChestItem;
import net.satisfy.vinery.core.item.WinemakerHelmetItem;
import net.satisfy.vinery.core.item.WinemakerLegsItem;
import net.satisfy.vinery.core.registry.ArmorRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BoneMealItem.class})
public abstract class BoneMealItemMixin {
    @Inject(method={"useOn"}, at={@At(value="RETURN")})
    public void useOnBlock(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (!(context.m_43725_() instanceof ServerLevel)) {
            return;
        }
        ArmorRegistry.checkArmorSet(Objects.requireNonNull(context.m_43723_()));
        if (cir.getReturnValue() != InteractionResult.CONSUME || !ArmorRegistry.setBonusActive) {
            return;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return;
        }
        ItemStack helmet = player.m_150109_().m_36052_(3);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack boots = player.m_150109_().m_36052_(0);
        if (helmet.m_41720_() instanceof WinemakerHelmetItem && chestplate.m_41720_() instanceof WinemakerChestItem && leggings.m_41720_() instanceof WinemakerLegsItem && boots.m_41720_() instanceof WinemakerBootsItem) {
            ItemStack heldItem = context.m_43722_();
            if (!heldItem.m_41619_()) {
                heldItem.m_41769_(1);
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack armorPiece = player.m_150109_().m_36052_(i);
                if (armorPiece.m_41619_()) continue;
                armorPiece.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
        }
    }
}

