/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import satisfy.herbalbrews.blocks.TeaLeafBlock;
import satisfy.herbalbrews.registry.BlockEntityRegistry;
import satisfy.herbalbrews.registry.ObjectRegistry;

public class TeaLeafBlockEntity
extends BlockEntity
implements BlockEntityTicker<TeaLeafBlockEntity> {
    private int timer = 0;

    public TeaLeafBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TEA_LEAF_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.timer = tag.m_128451_("Timer");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Timer", this.timer);
    }

    private Block getEndBlock(Block startBlock) {
        if (startBlock == ObjectRegistry.GREEN_TEA_LEAF_BLOCK.get()) {
            return (Block)ObjectRegistry.DRIED_OUT_GREEN_TEA_LEAF_BLOCK.get();
        }
        if (startBlock == ObjectRegistry.MIXED_TEA_LEAF_BLOCK.get()) {
            return (Block)ObjectRegistry.OOLONG_TEA_LEAF_BLOCK.get();
        }
        if (startBlock == ObjectRegistry.DRIED_GREEN_TEA_LEAF_BLOCK.get()) {
            return (Block)ObjectRegistry.BLACK_TEA_LEAF_BLOCK.get();
        }
        return Blocks.f_50016_;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, TeaLeafBlockEntity blockEntity) {
        if (level == null || level.f_46443_) {
            return;
        }
        int randomTickSpeed = level.m_46469_().m_46215_(GameRules.f_46143_);
        this.timer += randomTickSpeed;
        if (this.timer >= 900) {
            BlockState state = level.m_8055_(blockPos);
            int dryingStage = (Integer)state.m_61143_((Property)TeaLeafBlock.DRYING);
            if (dryingStage < 4) {
                level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)state));
                level.m_5594_(null, blockPos, SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)TeaLeafBlock.DRYING, (Comparable)Integer.valueOf(dryingStage + 1)));
                level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)state));
                this.timer = 0;
            } else {
                Block endBlock = this.getEndBlock(state.m_60734_());
                if (endBlock != Blocks.f_50016_) {
                    level.m_46597_(blockPos, endBlock.m_49966_());
                }
            }
        }
    }
}

