/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.blocks.entity;

import de.cristelknight.doapi.common.world.ImplementedInventory;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfy.herbalbrews.blocks.TeaKettleBlock;
import satisfy.herbalbrews.client.gui.handler.TeaKettleGuiHandler;
import satisfy.herbalbrews.recipe.TeaKettleRecipe;
import satisfy.herbalbrews.registry.BlockEntityRegistry;
import satisfy.herbalbrews.registry.RecipeTypeRegistry;
import satisfy.herbalbrews.registry.TagsRegistry;

public class TeaKettleBlockEntity
extends BlockEntity
implements BlockEntityTicker<TeaKettleBlockEntity>,
ImplementedInventory,
MenuProvider {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);
    private static final int MAX_CAPACITY = 7;
    public static final int MAX_COOKING_TIME = 600;
    private int cookingTime;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 6;
    private static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private boolean isBeingBurned;
    protected float experience;
    private final ContainerData delegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TeaKettleBlockEntity.this.cookingTime;
                case 1 -> {
                    if (TeaKettleBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TeaKettleBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    TeaKettleBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public TeaKettleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TEA_KETTLE_BLOCK_ENTITY.get(), pos, state);
    }

    public void dropExperience(ServerLevel world, Vec3 pos) {
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)pos, (int)((int)this.experience));
    }

    public int @NotNull [] m_7071_(Direction side) {
        return INPUT_SLOTS;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookingTime = nbt.m_128451_("CookingTime");
        this.experience = nbt.m_128457_("Experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("CookingTime", this.cookingTime);
        nbt.m_128350_("Experience", this.experience);
    }

    public boolean isBeingBurned() {
        if (this.m_58904_() == null) {
            throw new NullPointerException("Null world invoked");
        }
        BlockState belowState = this.m_58904_().m_8055_(this.m_58899_().m_7495_());
        Optional optionalList = BuiltInRegistries.f_256975_.m_203431_(TagsRegistry.ALLOWS_COOKING);
        HolderSet.Named entryList = optionalList.orElse(null);
        if (entryList == null) {
            return false;
        }
        return entryList.m_203333_((Holder)belowState.m_60734_().m_204297_());
    }

    private boolean canCraft(TeaKettleRecipe recipe) {
        if (recipe == null || recipe.getResultItem().m_41619_()) {
            return false;
        }
        if (this.m_8020_(0).m_41619_()) {
            return true;
        }
        ItemStack recipeOutput = recipe.getResultItem();
        ItemStack outputSlotStack = this.m_8020_(0);
        int outputSlotCount = outputSlotStack.m_41613_();
        if (!ItemStack.m_41656_((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            return false;
        }
        if (outputSlotCount < this.m_6893_() && outputSlotCount < outputSlotStack.m_41741_()) {
            return true;
        }
        return outputSlotCount < recipeOutput.m_41741_();
    }

    private void craft(TeaKettleRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 1; i <= 6; ++i) {
            ingredients.add((Object)this.m_8020_(i));
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            boolean ingredientConsumed = false;
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack inputStack = (ItemStack)ingredients.get(i);
                if (inputStack.m_41619_() || !ingredient.test(inputStack)) continue;
                ItemStack remainderStack = this.getRemainderItem(inputStack);
                inputStack.m_41774_(1);
                if (inputStack.m_41619_()) {
                    this.m_6836_(i + 1, remainderStack);
                }
                ingredientConsumed = true;
                ingredients.set(i, (Object)inputStack);
                break;
            }
            if (ingredientConsumed) continue;
            return;
        }
        ItemStack recipeOutput = recipe.assemble();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput);
        } else if (outputSlotStack.m_150930_(recipeOutput.m_41720_())) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        }
        return ItemStack.f_41583_;
    }

    public void tick(Level world, BlockPos pos, BlockState state, TeaKettleBlockEntity blockEntity) {
        if (world.m_5776_()) {
            return;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned) {
            if (((Boolean)state.m_61143_((Property)TeaKettleBlock.LIT)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        TeaKettleRecipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get(), (Container)this, world).orElse(null);
        boolean canCraft = this.canCraft(recipe);
        if (canCraft) {
            ++this.cookingTime;
            if (this.cookingTime >= 600) {
                this.cookingTime = 0;
                this.craft(recipe);
            }
        } else if (!this.canCraft(recipe)) {
            this.cookingTime = 0;
        }
        if (canCraft) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (((Boolean)state.m_61143_((Property)TeaKettleBlock.COOKING)).booleanValue()) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if ((Boolean)state.m_61143_((Property)TeaKettleBlock.LIT) != this.isBeingBurned) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new TeaKettleGuiHandler(syncId, inv, (Container)this, this.delegate);
    }
}

