/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import de.cristelknight.doapi.client.render.feature.CustomArmorManager;
import de.cristelknight.doapi.client.render.feature.CustomArmorSet;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.satisfy.brewery.client.model.BrewfestHatModel;
import net.satisfy.brewery.client.model.DirndlInner;
import net.satisfy.brewery.client.model.DirndlOuter;
import net.satisfy.brewery.client.model.LederhosenInner;
import net.satisfy.brewery.client.model.LederhosenOuter;
import net.satisfy.brewery.item.IBrewfestArmorSet;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.BreweryIdentifier;

public class ArmorRegistry {
    public static void registerArmorModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)BrewfestHatModel.LAYER_LOCATION, BrewfestHatModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)LederhosenInner.LAYER_LOCATION, LederhosenInner::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LederhosenOuter.LAYER_LOCATION, LederhosenOuter::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)DirndlInner.LAYER_LOCATION, DirndlInner::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)DirndlOuter.LAYER_LOCATION, DirndlOuter::createBodyLayer);
    }

    public static <T extends LivingEntity> void registerArmorModels(CustomArmorManager<T> armors, EntityModelSet modelLoader) {
        armors.addArmor(new CustomArmorSet(new Item[]{(Item)ObjectRegistry.BREWFEST_HAT.get(), (Item)ObjectRegistry.BREWFEST_REGALIA.get(), (Item)ObjectRegistry.BREWFEST_BOOTS.get(), (Item)ObjectRegistry.BREWFEST_TROUSERS.get()}).setTexture((ResourceLocation)new BreweryIdentifier("lederhosen")).setOuterModel(new LederhosenOuter(modelLoader.m_171103_(LederhosenOuter.LAYER_LOCATION))).setInnerModel(new LederhosenInner(modelLoader.m_171103_(LederhosenInner.LAYER_LOCATION))));
        armors.addArmor(new CustomArmorSet(new Item[]{(Item)ObjectRegistry.BREWFEST_HAT_RED.get(), (Item)ObjectRegistry.BREWFEST_BLOUSE.get(), (Item)ObjectRegistry.BREWFEST_DRESS.get(), (Item)ObjectRegistry.BREWFEST_SHOES.get()}).setTexture((ResourceLocation)new BreweryIdentifier("dirndl")).setOuterModel(new LederhosenOuter(modelLoader.m_171103_(LederhosenOuter.LAYER_LOCATION))).setInnerModel(new LederhosenInner(modelLoader.m_171103_(LederhosenInner.LAYER_LOCATION))));
    }

    public static <T extends LivingEntity> void registerHatModels(Map<Item, EntityModel<T>> models, EntityModelSet modelLoader) {
        models.put((Item)ObjectRegistry.BREWFEST_HAT.get(), new BrewfestHatModel(modelLoader.m_171103_(BrewfestHatModel.LAYER_LOCATION)));
        models.put((Item)ObjectRegistry.BREWFEST_HAT_RED.get(), new BrewfestHatModel(modelLoader.m_171103_(BrewfestHatModel.LAYER_LOCATION)));
    }

    public static void appendTooltip(List<Component> tooltip) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean helmet = IBrewfestArmorSet.hasBrewfestHelmet((Player)player);
        boolean breastplate = IBrewfestArmorSet.hasBrewfestBreastplate((Player)player);
        boolean leggings = IBrewfestArmorSet.hasBrewfestLeggings((Player)player);
        boolean boots = IBrewfestArmorSet.hasBrewfestBoots((Player)player);
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.brewfest.brewfestdrop").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.brewfest.brewfest_set").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.BOLD}));
        tooltip.add((Component)(helmet ? Component.m_237115_((String)"tooltip.brewfest.brewfesthelmet").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.brewfest.brewfesthelmet").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)(breastplate ? Component.m_237115_((String)"tooltip.brewfest.brewfestbreastplate").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.brewfest.brewfestbreastplate").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)(leggings ? Component.m_237115_((String)"tooltip.brewfest.brewfestleggings").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.brewfest.brewfestleggings").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)(boots ? Component.m_237115_((String)"tooltip.brewfest.brewfestboots").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.brewfest.brewfestboots").m_130940_(ChatFormatting.GRAY)));
    }
}

