/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery;

import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import net.satisfy.brewery.block.brew_event.BrewEvents;
import net.satisfy.brewery.event.BlockClickEvent;
import net.satisfy.brewery.event.CommonEvents;
import net.satisfy.brewery.event.HealingTouchEvent;
import net.satisfy.brewery.event.PartyStarterEvent;
import net.satisfy.brewery.event.PlayerCloneEvent;
import net.satisfy.brewery.event.PlayerRespawnEvent;
import net.satisfy.brewery.event.ProtectiveTouchEvent;
import net.satisfy.brewery.event.RenewingTouchEvent;
import net.satisfy.brewery.event.ToxicTouchEvent;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.BlockEntityRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.MobEffectRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.registry.RecipeTypeRegistry;
import net.satisfy.brewery.registry.TabRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Brewery {
    public static final String MOD_ID = "brewery";
    public static final Logger LOGGER = LogManager.getLogger((String)"brewery");

    public static void init() {
        LOGGER.debug("Initiate brewery");
        MobEffectRegistry.init();
        ObjectRegistry.init();
        BrewEvents.loadClass();
        BlockEntityRegistry.init();
        TabRegistry.init();
        CommonEvents.init();
        BreweryNetworking.registerC2SPackets();
        EntityRegistry.init();
        RecipeTypeRegistry.init();
        Brewery.registerEvents();
        HealingTouchEvent healingTouchEvent = new HealingTouchEvent();
        PlayerEvent.ATTACK_ENTITY.register((Object)healingTouchEvent);
        RenewingTouchEvent renewingTouchEvent = new RenewingTouchEvent();
        PlayerEvent.ATTACK_ENTITY.register((Object)renewingTouchEvent);
        ToxicTouchEvent toxicTouchEvent = new ToxicTouchEvent();
        PlayerEvent.ATTACK_ENTITY.register((Object)toxicTouchEvent);
        PartyStarterEvent partyStarterEvent = new PartyStarterEvent();
        PlayerEvent.ATTACK_ENTITY.register((Object)partyStarterEvent);
        ProtectiveTouchEvent protectiveTouchEvent = new ProtectiveTouchEvent();
        PlayerEvent.ATTACK_ENTITY.register((Object)protectiveTouchEvent);
    }

    private static void registerEvents() {
        PlayerEvent.PLAYER_RESPAWN.register((Object)new PlayerRespawnEvent());
        PlayerEvent.PLAYER_CLONE.register((Object)new PlayerCloneEvent());
        InteractionEvent.RIGHT_CLICK_BLOCK.register((Object)new BlockClickEvent());
    }
}

