/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AdvancedButtonHandler {
    private static AdvancedButton activeDescBtn;
    private static int garbageCheck;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AdvancedButtonHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(ScreenEvent.Render.Post e) {
        if (activeDescBtn != null) {
            if (activeDescBtn.m_198029_() && Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91080_ != null) {
                AdvancedButtonHandler.renderDescription(e.getGuiGraphics(), e.getMouseX(), e.getMouseY());
            }
            if (garbageCheck == 0) {
                activeDescBtn = null;
            }
            garbageCheck = 0;
        }
    }

    public static void setActiveDescriptionButton(AdvancedButton btn) {
        activeDescBtn = btn;
        garbageCheck = 1;
    }

    private static void renderDescriptionBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, new Color(26, 26, 26, 250).getRGB());
    }

    private static void renderDescription(GuiGraphics graphics, int mouseX, int mouseY) {
        PoseStack matrix = graphics.m_280168_();
        if (activeDescBtn != null && activeDescBtn.getDescription() != null) {
            int width = 10;
            int height = 10;
            for (String s : activeDescBtn.getDescription()) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre(matrix, 600);
            AdvancedButtonHandler.renderDescriptionBackground(graphics, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : activeDescBtn.getDescription()) {
                graphics.m_280056_(Minecraft.m_91087_().f_91062_, s, mouseX + 5, mouseY + i2, Color.WHITE.getRGB(), true);
                i2 += 10;
            }
            RenderUtils.setZLevelPost(matrix);
            RenderSystem.disableBlend();
        }
    }

    static {
        garbageCheck = 0;
    }
}

