/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.jerintegration.compat.mekanism;

import fr.alasdiablo.jerintegration.api.WorldGenIntegration;
import fr.alasdiablo.jerintegration.util.JERIntegrationUtils;
import fr.alasdiablo.jerintegration.util.WorldContext;
import java.util.Objects;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.WorldConfig;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.ResourceType;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import mekanism.common.world.height.HeightShape;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.WorldGenerationContext;

public class MekanismWorldGen
extends WorldGenIntegration {
    @Override
    public void registerWorldGen(IWorldGenRegistry registry) {
        WorldContext fakeContext = new WorldContext();
        for (OreType type : EnumUtils.ORE_TYPES) {
            int features = type.getBaseConfigs().size();
            for (int vein = 0; vein < features; ++vein) {
                Item rawOre;
                DistributionSquare distribution;
                OreType.OreVeinType oreVeinType = new OreType.OreVeinType(type, vein);
                WorldConfig.OreVeinConfig oreVeinConfig = MekanismConfig.world.getVeinConfig(oreVeinType);
                if (!oreVeinConfig.shouldGenerate().getAsBoolean()) continue;
                OreBlockType oreBlockType = (OreBlockType)MekanismBlocks.ORES.get(oreVeinType.type());
                if (oreVeinConfig.range().shape().get() == HeightShape.UNIFORM) {
                    distribution = new DistributionSquare(oreVeinConfig.perChunk().getAsInt(), oreVeinConfig.maxVeinSize().getAsInt(), oreVeinConfig.range().minInclusive().resolveY((WorldGenerationContext)fakeContext), oreVeinConfig.range().maxInclusive().resolveY((WorldGenerationContext)fakeContext));
                } else {
                    int range = (oreVeinConfig.range().maxInclusive().resolveY((WorldGenerationContext)fakeContext) - oreVeinConfig.range().minInclusive().resolveY((WorldGenerationContext)fakeContext)) / 2;
                    int midY = range + oreVeinConfig.range().minInclusive().resolveY((WorldGenerationContext)fakeContext);
                    distribution = new DistributionTriangular(oreVeinConfig.perChunk().getAsInt(), oreVeinConfig.maxVeinSize().getAsInt(), midY, range);
                }
                if (type.getResource().getRegistrySuffix().equals("fluorite")) {
                    rawOre = MekanismItems.FLUORITE_GEM.m_5456_();
                    JERIntegrationUtils.register(registry, new ItemStack((ItemLike)oreBlockType.stoneBlock()), new ItemStack((ItemLike)oreBlockType.deepslateBlock()), new ItemStack((ItemLike)rawOre), (DistributionBase)distribution);
                    continue;
                }
                rawOre = Objects.requireNonNull((ItemRegistryObject)MekanismItems.PROCESSED_RESOURCES.get((Object)ResourceType.RAW, (Object)type.getResource())).m_5456_();
                JERIntegrationUtils.register(registry, new ItemStack((ItemLike)oreBlockType.stoneBlock()), new ItemStack((ItemLike)oreBlockType.deepslateBlock()), new ItemStack((ItemLike)rawOre), (DistributionBase)distribution);
            }
        }
    }
}

