/*
 * Decompiled with CFR 0.152.
 */
package net.count.ironsspellsdelight.item.custom;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ManaInfusionTalisman
extends Item {
    private static final UUID MANA_BONUS_UUID = UUID.fromString("6c52b4ba-97b1-4ec6-bc65-abcdef123456");
    private static final int MANA_BONUS = 50;
    private static final int BONUS_DURATION_TICKS = 600;
    private final Map<Player, Integer> playersWithBonus = new HashMap<Player, Integer>();

    public ManaInfusionTalisman(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        if (!level.f_46443_ && entity instanceof Player && !this.playersWithBonus.containsKey(player = (Player)entity)) {
            this.applyManaBonus(player);
            this.playersWithBonus.put(player, 600);
        }
        return super.m_5922_(stack, level, entity);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (this.playersWithBonus.containsKey(player)) {
            int remainingTicks = this.playersWithBonus.get(player) - 1;
            if (remainingTicks <= 0) {
                this.removeManaBonus(player);
                this.playersWithBonus.remove(player);
            } else {
                this.playersWithBonus.put(player, remainingTicks);
            }
        }
    }

    private void applyManaBonus(Player player) {
        AttributeInstance maxManaAttribute = player.m_21051_((Attribute)AttributeRegistry.MAX_MANA.get());
        if (maxManaAttribute != null && maxManaAttribute.m_22111_(MANA_BONUS_UUID) == null) {
            maxManaAttribute.m_22118_(new AttributeModifier(MANA_BONUS_UUID, "ManaInfusionTalisman Bonus", 50.0, AttributeModifier.Operation.ADDITION));
            player.m_5661_((Component)Component.m_237110_((String)"item.irons_spellbooks.mana_bonus_applied", (Object[])new Object[]{50}), true);
        }
    }

    private void removeManaBonus(Player player) {
        AttributeInstance maxManaAttribute = player.m_21051_((Attribute)AttributeRegistry.MAX_MANA.get());
        if (maxManaAttribute != null && maxManaAttribute.m_22111_(MANA_BONUS_UUID) != null) {
            maxManaAttribute.m_22120_(MANA_BONUS_UUID);
            player.m_5661_((Component)Component.m_237115_((String)"item.irons_spellbooks.mana_bonus_removed"), true);
        }
    }
}

