/*
 * Decompiled with CFR 0.152.
 */
package net.count.ironsspellsdelight.item.custom;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicProvider;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.count.ironsspellsdelight.handler.EmpowermentTickHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FireSpellEmpowermentCharm
extends Item {
    private static final Random RANDOM = new Random();
    private static final UUID EMPOWERMENT_UUID = UUID.fromString("6c52b4ba-97b1-4ec6-bc65-abcdef654321");

    public FireSpellEmpowermentCharm(Item.Properties properties) {
        super(properties);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Optional magicDataOptional = player.getCapability(PlayerMagicProvider.PLAYER_MAGIC).resolve();
            if (magicDataOptional.isEmpty()) {
                player.m_5661_((Component)Component.m_237115_((String)"item.irons_spellbooks.magic_data_error"), true);
                return stack;
            }
            MagicData magicData = (MagicData)magicDataOptional.get();
            if (!player.m_36335_().m_41519_((Item)this)) {
                AttributeInstance fireSpellPower = player.m_21051_((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get());
                if (fireSpellPower != null) {
                    double boostValue = 0.1 + RANDOM.nextDouble() * 0.15;
                    AttributeModifier modifier = new AttributeModifier(EMPOWERMENT_UUID, "Fire Spell Empowerment", boostValue, AttributeModifier.Operation.ADDITION);
                    fireSpellPower.m_22118_(modifier);
                    player.m_5661_((Component)Component.m_237110_((String)"item.irons_spellbooks.fire_spell_empowered", (Object[])new Object[]{boostValue}), true);
                    new EmpowermentTickHandler(player, fireSpellPower, EMPOWERMENT_UUID, 1200);
                }
                player.m_36335_().m_41524_((Item)this, 1200);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.irons_spellbooks.on_cooldown"), true);
            }
        }
        return super.m_5922_(stack, level, entity);
    }
}

