/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.condition;

import com.craisinlord.integrated_api.world.condition.StructureCondition;
import com.craisinlord.integrated_api.world.condition.StructureConditionType;
import com.craisinlord.integrated_api.world.structures.context.StructureContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;

public class AltitudeCondition
extends StructureCondition {
    public static final Codec<AltitudeCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.optionalFieldOf("bottom_cutoff_y").forGetter(conditon -> conditon.bottomCutoffY), (App)Codec.DOUBLE.optionalFieldOf("top_cutoff_y").forGetter(conditon -> conditon.topCutoffY)).apply((Applicative)builder, AltitudeCondition::new));
    private Optional<Double> bottomCutoffY;
    private Optional<Double> topCutoffY;

    public AltitudeCondition(Optional<Double> bottomCutoffY, Optional<Double> topCutoffY) {
        this.bottomCutoffY = bottomCutoffY;
        this.topCutoffY = topCutoffY;
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.ALTITUDE;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        if (this.bottomCutoffY.isPresent() && (double)ctx.pieceMinY() < this.bottomCutoffY.get()) {
            return false;
        }
        return !this.topCutoffY.isPresent() || !((double)ctx.pieceMaxY() > this.topCutoffY.get());
    }
}

