/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixins;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.data.fluid_generators.FluidGeneratorsHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LiquidBlock.class})
public abstract class LiquidBlockMixin
extends Block
implements BucketPickup {
    @Shadow
    @Final
    public static ImmutableList<Direction> f_181233_;
    @Shadow
    @Final
    protected FlowingFluid f_54689_;

    @Shadow
    protected abstract void m_54700_(LevelAccessor var1, BlockPos var2);

    @Shadow
    public abstract FluidState m_5888_(BlockState var1);

    protected LiquidBlockMixin(BlockBehaviour.Properties settings, FlowingFluid fluid) {
        super(settings);
    }

    @Inject(method={"shouldSpreadLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldSpreadLiquid(Level level, BlockPos pos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        FlowingFluid f = this.getOwnFluid();
        Optional<Pair<BlockPos, SoundEvent>> successPos = FluidGeneratorsHandler.applyGenerators(f, f_181233_, pos, level);
        if (successPos.isPresent()) {
            if (f.m_205067_(FluidTags.f_13132_)) {
                this.m_54700_((LevelAccessor)level, (BlockPos)successPos.get().getFirst());
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    public FlowingFluid getOwnFluid() {
        FlowingFluid f = IWPlatformStuff.getFlowingFluid((LiquidBlock)this);
        if (f == null) {
            return this.f_54689_;
        }
        return f;
    }
}

