/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import com.ordana.immersive_weathering.util.StrOpt;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluid;

public class SelfFluidGenerator
implements IFluidGenerator {
    public static final Codec<SelfFluidGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(SelfFluidGenerator::getFluid), (App)StrOpt.of(IFluidGenerator.FluidType.CODEC, "fluid_type", IFluidGenerator.FluidType.BOTH).forGetter(SelfFluidGenerator::getFluidType), (App)BlockState.f_61039_.fieldOf("generate").forGetter(SelfFluidGenerator::getGrowth), (App)AdjacentBlocks.CODEC.fieldOf("adjacent_blocks").forGetter(SelfFluidGenerator::getAdjacentBlocksCondition), (App)StrOpt.of(IPositionRuleTest.CODEC, "additional_target_check").forGetter(SelfFluidGenerator::getPositionTests), (App)StrOpt.of(Codec.INT, "priority", 0).forGetter(SelfFluidGenerator::getPriority)).apply((Applicative)instance, SelfFluidGenerator::new));
    public static final IFluidGenerator.Type<SelfFluidGenerator> TYPE = new IFluidGenerator.Type<SelfFluidGenerator>(CODEC, "target_self");
    private final Fluid fluid;
    private final IFluidGenerator.FluidType fluidType;
    private final BlockState growth;
    private final Optional<IPositionRuleTest> positionTests;
    private final int priority;
    private final AdjacentBlocks adjacentBlocksCondition;

    public SelfFluidGenerator(Fluid fluid, IFluidGenerator.FluidType fluidType, BlockState growth, AdjacentBlocks adjacentBlocks, Optional<IPositionRuleTest> positionRuleTests, int priority) {
        this.fluid = fluid;
        this.fluidType = fluidType;
        this.growth = growth;
        this.adjacentBlocksCondition = adjacentBlocks;
        this.positionTests = positionRuleTests;
        this.priority = priority;
    }

    @Override
    public IFluidGenerator.FluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public IFluidGenerator.Type<?> getType() {
        return TYPE;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    public BlockState getGrowth() {
        return this.growth;
    }

    public Optional<IPositionRuleTest> getPositionTests() {
        return this.positionTests;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public AdjacentBlocks getAdjacentBlocksCondition() {
        return this.adjacentBlocksCondition;
    }

    @Override
    public Optional<BlockPos> tryGenerating(List<Direction> possibleFlowDir, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache) {
        if (!this.adjacentBlocksCondition.isMet(possibleFlowDir, pos, level, neighborCache, this.positionTests)) {
            return Optional.empty();
        }
        if (pos != null) {
            level.m_46597_(pos, this.growth);
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static class AdjacentBlocks {
        public static final Codec<AdjacentBlocks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(RuleTest.f_74307_.listOf(), "sides", List.of()).forGetter(a -> a.sidesBlocks), (App)StrOpt.of(RuleTest.f_74307_.listOf(), "any", List.of()).forGetter(a -> a.anyBlocks), (App)StrOpt.of(RuleTest.f_74307_, "up").forGetter(a -> Optional.ofNullable(a.upBlock)), (App)StrOpt.of(RuleTest.f_74307_, "down").forGetter(a -> Optional.ofNullable(a.downBlock))).apply((Applicative)instance, AdjacentBlocks::new)).comapFlatMap(arg -> {
            if (arg.sidesBlocks.isEmpty() && arg.anyBlocks.isEmpty() && arg.upBlock == null && arg.downBlock == null) {
                return DataResult.error(() -> "Adjacent Blocks must contain at least one predicate");
            }
            return DataResult.success((Object)arg);
        }, Function.identity());
        private final List<RuleTest> anyBlocks;
        private final List<RuleTest> sidesBlocks;
        private final RuleTest upBlock;
        private final RuleTest downBlock;

        public AdjacentBlocks(List<RuleTest> sidesBlocks, List<RuleTest> anyBlocks, Optional<RuleTest> upBlock, Optional<RuleTest> downBlock) {
            this.sidesBlocks = sidesBlocks;
            this.anyBlocks = anyBlocks;
            this.upBlock = upBlock.orElse(null);
            this.downBlock = downBlock.orElse(null);
        }

        public boolean isMet(List<Direction> possibleFlowDir, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache, Optional<IPositionRuleTest> extraCheck) {
            boolean atLeastOnceSuccess;
            Supplier b = Suppliers.memoize(() -> level.m_204166_(pos));
            for (RuleTest r : this.anyBlocks) {
                atLeastOnceSuccess = false;
                for (Direction d : Direction.values()) {
                    BlockPos side = pos.m_121945_(d);
                    BlockState state = neighborCache.computeIfAbsent(d, p -> level.m_8055_(side));
                    if (!r.m_213865_(state, level.f_46441_) || extraCheck.isPresent() && !extraCheck.get().test((java.util.function.Supplier<Holder<Biome>>)b, side, level)) continue;
                    atLeastOnceSuccess = true;
                    break;
                }
                if (atLeastOnceSuccess) continue;
                return false;
            }
            for (RuleTest r : this.sidesBlocks) {
                atLeastOnceSuccess = false;
                for (Direction d : possibleFlowDir) {
                    BlockPos side;
                    BlockState state;
                    if (!d.m_122434_().m_122479_() || !r.m_213865_(state = neighborCache.computeIfAbsent(d, arg_0 -> AdjacentBlocks.lambda$isMet$9(level, side = pos.m_121945_(d), arg_0)), level.f_46441_) || extraCheck.isPresent() && !extraCheck.get().test((java.util.function.Supplier<Holder<Biome>>)b, side, level)) continue;
                    atLeastOnceSuccess = true;
                    break;
                }
                if (atLeastOnceSuccess) continue;
                return false;
            }
            if (this.upBlock != null && this.testFails(this.upBlock, pos, level, neighborCache, extraCheck, (java.util.function.Supplier<Holder<Biome>>)b, Direction.UP)) {
                return false;
            }
            return this.downBlock == null || !this.testFails(this.downBlock, pos, level, neighborCache, extraCheck, (java.util.function.Supplier<Holder<Biome>>)b, Direction.DOWN);
        }

        private boolean testFails(RuleTest test, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache, Optional<IPositionRuleTest> extraCheck, java.util.function.Supplier<Holder<Biome>> biome, Direction dir) {
            BlockPos target = pos.m_121945_(dir);
            BlockState state = neighborCache.computeIfAbsent(dir, p -> level.m_8055_(target));
            if (!test.m_213865_(state, level.f_46441_)) {
                return true;
            }
            return extraCheck.isPresent() && !extraCheck.get().test(biome, target, level);
        }

        private static /* synthetic */ BlockState lambda$isMet$9(Level level, BlockPos side, Direction p) {
            return level.m_8055_(side);
        }
    }
}

