/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.blocks.FulguriteBlock;
import com.ordana.immersive_weathering.blocks.cracked.Crackable;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LightningGrowth
extends BuiltinBlockGrowth {
    public static final SimpleWeightedRandomList<Direction> list = SimpleWeightedRandomList.m_146263_().m_146271_((Object)Direction.UP, 7).m_146271_((Object)Direction.DOWN, 1).m_146271_((Object)Direction.NORTH, 1).m_146271_((Object)Direction.EAST, 1).m_146271_((Object)Direction.WEST, 1).m_146271_((Object)Direction.SOUTH, 1).m_146270_();

    public LightningGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Nullable
    public Iterable<Block> getOwners() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        ((HolderSet.Named)BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13029_).get()).m_203614_().forEach(h -> blocks.add((Block)h.m_203334_()));
        ((HolderSet.Named)BuiltInRegistries.f_256975_.m_203431_(ModTags.CRACKABLE).get()).m_203614_().forEach(h -> blocks.add((Block)h.m_203334_()));
        return blocks;
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Supplier<Holder<Biome>> biome) {
        this.onLightningHit(pos, (Level)level, 0);
    }

    public void onLightningHit(BlockPos centerPos, Level level, int rec) {
        BlockPos downPos;
        if (this.growthChance != 1.0f && !(level.f_46441_.m_188501_() < this.growthChance)) {
            return;
        }
        if (rec == 0 && !CommonConfigs.VITRIFIED_LIGHTNING.get().booleanValue()) {
            return;
        }
        this.convert(level, centerPos);
        if (rec >= 5) {
            return;
        }
        float decrement = 0.7f;
        double p = Math.pow(decrement, ++rec);
        if ((rec == 0 || (double)level.f_46441_.m_188501_() < 1.0 * p) && this.isValidTarget(level, downPos = centerPos.m_7495_())) {
            this.onLightningHit(downPos, level, rec);
        }
        for (BlockPos target : BlockPos.m_121925_((BlockPos)centerPos, (int)1, (int)0, (int)1)) {
            if (!((double)level.f_46441_.m_188501_() < 0.3 * p) || target == centerPos || !this.isValidTarget(level, target)) continue;
            this.onLightningHit(target, level, rec);
        }
    }

    private boolean isValidTarget(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_204336_(ModTags.CRACKABLE) || state.m_204336_(BlockTags.f_13029_);
    }

    private void convert(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state instanceof Crackable) {
            level.m_7731_(pos, Crackable.getCrackedBlock(state), 3);
        } else if (state.m_204336_(BlockTags.f_13029_)) {
            Direction dir;
            BlockPos offset;
            level.m_7731_(pos, ModBlocks.VITRIFIED_SAND.get().m_49966_(), 3);
            if ((double)level.f_46441_.m_188501_() < CommonConfigs.FULGURITE_CHANCE.get() && level.m_8055_(offset = pos.m_121945_(dir = (Direction)((WeightedEntry.Wrapper)list.m_216829_(level.f_46441_).get()).m_146310_())).m_60795_()) {
                level.m_7731_(offset, (BlockState)((BlockState)ModBlocks.FULGURITE.get().m_49966_().m_61124_((Property)FulguriteBlock.f_152006_, (Comparable)dir)).m_61124_((Property)FulguriteBlock.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }
}

