/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.entities.FallingLayerEntity;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LayerBlock
extends FallingBlock {
    public static final IntegerProperty LAYERS_8 = BlockStateProperties.f_61417_;
    private static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[9];
    private final int min;
    private final int max;

    public LayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.layerProperty(), (Comparable)Integer.valueOf(1)));
        this.min = (Integer)Collections.min(this.layerProperty().m_6908_());
        this.max = (Integer)Collections.max(this.layerProperty().m_6908_());
    }

    public final int getMaxLayers() {
        return this.max;
    }

    public final int getMinLayers() {
        return this.min;
    }

    public IntegerProperty layerProperty() {
        return LAYERS_8;
    }

    public int getLayers(BlockState state) {
        return (Integer)state.m_61143_((Property)this.layerProperty());
    }

    public void m_6807_(BlockState state, Level levelIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            levelIn.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    public VoxelShape getDefaultShape(BlockState state) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS_8)];
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getDefaultShape(pState);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return this.getDefaultShape(pState);
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return this.getDefaultShape(pState);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND -> {
                if (this.getLayers(state) < 5) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> {
                if (this.getLayers(state) == 0) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.AIR -> false;
        };
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos otherPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = currentPos.m_7494_();
            BlockState state1 = level.m_8055_(pos);
            while (state1.m_60713_((Block)this)) {
                serverLevel.m_186460_(pos, (Block)this, this.m_7198_());
                pos = pos.m_7494_();
                state1 = serverLevel.m_8055_(pos);
            }
        }
        return super.m_7417_(state, direction, facingState, level, currentPos, otherPos);
    }

    public boolean shouldFall(BlockState state, BlockState belowState) {
        return (belowState.m_60795_() || belowState.m_247087_()) && !belowState.m_60713_((Block)this);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRand) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if ((this.shouldFall(state, below) || this.hasIncompletePileBelow(below)) && pos.m_123342_() >= level.m_141937_()) {
            while (state.m_60713_((Block)this)) {
                FallingLayerEntity fallingblockentity = FallingLayerEntity.fall((Level)level, pos, state);
                this.m_6788_(fallingblockentity);
                pos = pos.m_7494_();
                state = level.m_8055_(pos);
            }
        }
    }

    private boolean hasIncompletePileBelow(BlockState state) {
        return state.m_60713_((Block)this) && this.getLayers(state) != this.getMaxLayers();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = this.getLayers(blockstate);
            return (BlockState)blockstate.m_61124_((Property)this.layerProperty(), (Comparable)Integer.valueOf(Math.min(this.getMaxLayers(), i + 1)));
        }
        return super.m_5573_(context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.layerProperty()});
    }

    protected void removeOneLayer(BlockState state, BlockPos pos, Level level) {
        int levels = this.getLayers(state);
        if (levels > 1) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.layerProperty(), (Comparable)Integer.valueOf(levels - 1)));
        } else {
            level.m_7471_(pos, false);
        }
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        int i = this.getLayers(pState);
        if (pUseContext.m_43722_().m_150930_(this.m_5456_()) && i < this.getMaxLayers()) {
            return true;
        }
        return i == 1;
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
        LayerBlock.SHAPE_BY_LAYER[0] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.1f, (double)16.0);
    }
}

