/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.google.common.collect.Lists;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class IvyBlock
extends MultifaceBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = ModBlockProperties.AGE;
    public static final int MAX_AGE = 10;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public IvyBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(7)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    protected BlockState age(BlockState state) {
        return state.m_61138_((Property)AGE) ? (BlockState)state.m_61122_((Property)AGE) : state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        return Arrays.stream(ctx.m_6232_()).map(direction -> this.m_153940_(blockState, (BlockGetter)level, blockPos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public MultifaceSpreader m_213612_() {
        return this.spreader;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 10;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 0 || Stream.of(f_153806_).anyMatch(direction -> this.m_221571_((BlockGetter)level, state, pos, direction.m_122424_()));
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource r) {
        int methodThree;
        int method = r.m_188503_(3);
        Random random = new Random(r.m_188505_());
        if (method == 0 ? this.growPseudoAdjacent((Level)level, random, pos, state) : (method == 1 ? this.growAdjacent((Level)level, random, pos, state) : this.growExternal((Level)level, random, pos, state))) {
            return;
        }
        int methodTwo = random.nextInt(3);
        if (methodTwo == method) {
            boolean side = random.nextBoolean();
            int n = method == 0 ? (side ? 1 : 2) : (method == 1 ? (side ? 0 : 2) : (methodTwo = side ? 0 : 1));
        }
        if (methodTwo == 0 ? this.growPseudoAdjacent((Level)level, random, pos, state) : (methodTwo == 1 ? this.growAdjacent((Level)level, random, pos, state) : this.growExternal((Level)level, random, pos, state))) {
            return;
        }
        int n = method == 0 ? (methodTwo == 1 ? 2 : 1) : (method == 1 ? (methodTwo == 0 ? 2 : 0) : (methodThree = methodTwo == 2 ? 0 : 2));
        if (methodThree == 0) {
            this.growPseudoAdjacent((Level)level, random, pos, state);
        } else if (methodThree == 1) {
            this.growAdjacent((Level)level, random, pos, state);
        } else {
            this.growExternal((Level)level, random, pos, state);
        }
    }

    public static boolean isIvyPos(BlockPos pos) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(2) == 0;
    }

    public void m_214148_(ServerLevel level, RandomSource r, BlockPos pos, BlockState state) {
        int methodThree;
        level.m_46597_(pos, (BlockState)state.m_60734_().m_152465_(state).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        Random random = new Random(r.m_188505_());
        int method = r.m_188503_(3);
        if (method == 0 ? this.growPseudoAdjacent((Level)level, random, pos, state) : (method == 1 ? this.growAdjacent((Level)level, random, pos, state) : this.growExternal((Level)level, random, pos, state))) {
            return;
        }
        int methodTwo = random.nextInt(3);
        if (methodTwo == method) {
            boolean side = random.nextBoolean();
            int n = method == 0 ? (side ? 1 : 2) : (method == 1 ? (side ? 0 : 2) : (methodTwo = side ? 0 : 1));
        }
        if (methodTwo == 0 ? this.growPseudoAdjacent((Level)level, random, pos, state) : (methodTwo == 1 ? this.growAdjacent((Level)level, random, pos, state) : this.growExternal((Level)level, random, pos, state))) {
            return;
        }
        int n = method == 0 ? (methodTwo == 1 ? 2 : 1) : (method == 1 ? (methodTwo == 0 ? 2 : 0) : (methodThree = methodTwo == 2 ? 0 : 2));
        if (methodThree == 0) {
            this.growPseudoAdjacent((Level)level, random, pos, state);
        } else if (methodThree == 1) {
            this.growAdjacent((Level)level, random, pos, state);
        } else {
            this.growExternal((Level)level, random, pos, state);
        }
    }

    public List<Direction> getFacingDirections(BlockState state) {
        ArrayList facing = Lists.newArrayList();
        for (Direction dir : Direction.values()) {
            if (!((Boolean)state.m_61143_((Property)MultifaceBlock.m_153933_((Direction)dir))).booleanValue()) continue;
            facing.add(dir);
        }
        return facing;
    }

    public boolean growPseudoAdjacent(Level level, Random random, BlockPos pos, BlockState state) {
        BlockState newStateHere = state;
        ArrayList shuffledDirections = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(shuffledDirections, random);
        for (Direction dir : shuffledDirections) {
            BlockState attemptedStateHere = (BlockState)newStateHere.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
            if (this.m_7898_(attemptedStateHere, (LevelReader)level, pos)) {
                newStateHere = attemptedStateHere;
            }
            if (newStateHere.equals(state)) continue;
            level.m_46597_(pos, newStateHere);
            return true;
        }
        return false;
    }

    public boolean canGrowPseudoAdjacent(Level level, BlockPos pos, BlockState state) {
        BlockState newStateHere = state;
        for (Direction dir : Direction.values()) {
            BlockState attemptedStateHere = (BlockState)newStateHere.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
            if (this.m_7898_(attemptedStateHere, (LevelReader)level, pos)) {
                newStateHere = attemptedStateHere;
            }
            if (newStateHere.equals(state)) continue;
            return true;
        }
        return false;
    }

    public boolean growAdjacent(Level level, Random random, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        Collections.shuffle(facing, random);
        ArrayList shuffledDirections = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(shuffledDirections, random);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : shuffledDirections) {
                if (idealFacingDir.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && !dir.equals((Object)Direction.UP)) {
                    if (dir.equals((Object)Direction.DOWN) && random.nextDouble() < 0.9) {
                        return false;
                    }
                    if (dir.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && random.nextDouble() < 0.25) {
                        return false;
                    }
                }
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos adjacentPos = pos.m_121945_(dir);
                BlockState adjacentState = level.m_8055_(adjacentPos);
                BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true));
                if (!adjacentState.m_60795_() && !adjacentState.m_60713_((Block)this) || !this.m_7898_(newState, (LevelReader)level, adjacentPos) || !IvyBlock.isIvyPos(adjacentPos)) continue;
                BlockState finalNewState = adjacentState.m_60713_((Block)this) ? (BlockState)adjacentState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true)) : ((Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newState);
                level.m_46597_(adjacentPos, finalNewState);
                if (finalNewState.equals(adjacentState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canGrowAdjacent(Level level, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : Direction.values()) {
                BlockState finalNewState;
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos adjacentPos = pos.m_121945_(dir);
                BlockState adjacentState = level.m_8055_(adjacentPos);
                BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true));
                if (!adjacentState.m_60795_() && !adjacentState.m_60713_((Block)this) || !this.m_7898_(newState, (LevelReader)level, adjacentPos)) continue;
                BlockState blockState = adjacentState.m_60713_((Block)this) ? (BlockState)adjacentState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true)) : (finalNewState = (Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newState);
                if (finalNewState.equals(adjacentState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean growExternal(Level level, Random random, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        Collections.shuffle(facing, random);
        ArrayList shuffledDirections = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(shuffledDirections, random);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : shuffledDirections) {
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos externalPos = pos.m_121945_(idealFacingDir).m_121945_(dir);
                BlockState externalState = level.m_8055_(externalPos);
                BlockState newStateOpposed = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
                if (!level.m_8055_(pos.m_121945_(dir)).m_60795_() || !externalState.m_60795_() && !externalState.m_60713_((Block)this) || !this.m_7898_(newStateOpposed, (LevelReader)level, externalPos) || !IvyBlock.isIvyPos(externalPos)) continue;
                BlockState finalNewState = externalState.m_60713_((Block)this) ? (BlockState)externalState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true)) : ((Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newStateOpposed.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newStateOpposed);
                level.m_46597_(externalPos, finalNewState);
                if (finalNewState.equals(externalState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canGrowExternal(Level level, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : Direction.values()) {
                BlockState finalNewState;
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos externalPos = pos.m_121945_(idealFacingDir).m_121945_(dir);
                BlockState externalState = level.m_8055_(externalPos);
                BlockState newStateOpposed = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
                if (!level.m_8055_(pos.m_121945_(dir)).m_60795_() || !externalState.m_60795_() && !externalState.m_60713_((Block)this) || !this.m_7898_(newStateOpposed, (LevelReader)level, externalPos)) continue;
                BlockState blockState = externalState.m_60713_((Block)this) ? (BlockState)externalState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true)) : (finalNewState = (Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newStateOpposed.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newStateOpposed);
                if (finalNewState.equals(externalState)) continue;
                return true;
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ShearsItem && (Integer)state.m_61143_((Property)AGE) < 10) {
            level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(10)));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }
}

