/*
 * Decompiled with CFR 0.152.
 */
package org.groovymc.gml.mappings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.srgutils.IMappingFile;
import org.apache.commons.codec.binary.Hex;
import org.apache.groovy.nio.extensions.NioExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.groovymc.gml.mappings.LoadedMappings;
import org.groovymc.gml.mappings.ManifestMetaFile;
import org.groovymc.gml.mappings.VersionMetaFile;
import org.slf4j.Logger;

public class MappingsProvider
implements GroovyObject {
    public static final MappingsProvider INSTANCE;
    private static final Logger LOGGER;
    private static final String PISTON_META = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    private static final String MAPPINGS_THREAD = "GML Mappings Thread";
    private static final String VERSION_JSON = "version.json";
    private static final String OFFICIAL = "official.txt";
    private static final String MCPCONFIG_ZIP = "srg.zip";
    private static final String JOINED_PATH = "config/joined.tsrg";
    private static final /* synthetic */ Gson $GSON;
    private static final AtomicLong startTime;
    private final String version;
    private final Path gameDir;
    private final Path cacheDir;
    private final Path zipPath;
    private final Path versionJsonPath;
    private final Path officialPath;
    private final String mcpVersion;
    private final GString mcpConfigURL;
    private final CompletableFuture<Either<LoadedMappings, Throwable>> mappingsProvider;
    private boolean setup;
    private static volatile /* synthetic */ HttpClient $client;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private MappingsProvider() {
        InputStream is;
        block22: {
            MetaClass metaClass;
            boolean bl;
            String string;
            Path path;
            Path path2;
            Path path3;
            Path path4;
            String string2;
            this.version = string2 = FMLLoader.versionInfo().mcVersion();
            Object t = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IndyInterface.bootstrap("cast", "()", 0, IEnvironment.Keys.GAMEDIR.get())).get();
            this.gameDir = IndyInterface.bootstrap("cast", "()", 0, t);
            this.cacheDir = path4 = this.gameDir.resolve("mod_data/gml").resolve(this.version);
            this.zipPath = path3 = this.cacheDir.resolve(MCPCONFIG_ZIP);
            this.versionJsonPath = path2 = this.cacheDir.resolve(VERSION_JSON);
            this.officialPath = path = this.cacheDir.resolve(OFFICIAL);
            this.mcpVersion = string = FMLLoader.versionInfo().mcpVersion();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.version, this.mcpVersion, this.version, this.mcpVersion}, new String[]{"https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_config/", "-", "/mcp_config-", "-", ".zip"});
            this.mcpConfigURL = gStringImpl;
            CompletableFuture completableFuture = new CompletableFuture();
            this.mappingsProvider = completableFuture;
            this.setup = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            is = this.getClass().getResourceAsStream("/mod_data_readme.txt");
            Throwable __$$primaryExc0 = null;
            try {
                try {
                    Files.createDirectories(this.cacheDir, new FileAttribute[0]);
                    Files.write(this.cacheDir.resolve("README"), is.readAllBytes(), new OpenOption[0]);
                }
                catch (Throwable __$$t0) {
                    __$$primaryExc0 = __$$t0;
                    throw __$$t0;
                }
                if (!(__$$primaryExc0 != null)) break block22;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc0 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = is;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc0) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc0;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc0);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = is;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = is;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc0) {
                Object v4;
                Throwable throwable = __$$primaryExc0;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc0);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = is;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private Thread setupMappingsThread(Runnable runnable) {
        Thread mappingsThread = new Thread(runnable, MAPPINGS_THREAD);
        public final class _setupMappingsThread_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setupMappingsThread_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Thread t, Throwable e) {
                MappingsProvider.pfaccess$0(null).error("Caught exception while setting up mappings...", e);
                return ((MappingsProvider)this.getThisObject()).getMappingsProvider().complete((Either<LoadedMappings, Throwable>)Either.right((Object)e));
            }

            @Generated
            public Boolean call(Thread t, Throwable e) {
                return this.doCall(t, e);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupMappingsThread_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        mappingsThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)IndyInterface.bootstrap("cast", "()", 0, new _setupMappingsThread_closure1(this, this))));
        return mappingsThread;
    }

    public synchronized void startMappingsSetup() {
        startTime.set(System.currentTimeMillis());
        if (!this.setup) {
            boolean bl;
            LOGGER.info("Starting runtime mappings setup...");
            this.setup = bl = true;
            if (Files.exists(this.versionJsonPath, new LinkOption[0]) && Files.exists(this.zipPath, new LinkOption[0]) && Files.exists(this.officialPath, new LinkOption[0])) {
                public final class _startMappingsSetup_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _startMappingsSetup_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Void doCall(Object it) {
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).loadLayeredMappings();
                        MappingsProvider.pfaccess$0(null).info("Finished runtime mappings setup.");
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Void doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _startMappingsSetup_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Thread mappingsThread = this.setupMappingsThread((Runnable)((Object)new _startMappingsSetup_closure2(this, this)));
                mappingsThread.start();
            } else {
                public final class _startMappingsSetup_closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _startMappingsSetup_closure3(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Void doCall(Object it) {
                        InputStream manifestInput = MappingsProvider.downloadFile(MappingsProvider.pfaccess$1(null));
                        BufferedReader manifestReader = new BufferedReader(new InputStreamReader(manifestInput));
                        CallSite manifestMeta = IndyInterface.bootstrap("cast", "()", 0, MappingsProvider.getGSON().fromJson((Reader)manifestReader, ManifestMetaFile.class));
                        public final class _closure7
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure7(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Boolean doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)((ManifestMetaFile.VersionMeta)it).getId(), (Object)((MappingsProvider)this.getThisObject()).version);
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite versionMeta = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find(((ManifestMetaFile)((Object)manifestMeta)).getVersions(), (Closure)new _closure7((Object)this, this.getThisObject())));
                        if (!Files.exists(((MappingsProvider)this.getThisObject()).cacheDir, new LinkOption[0])) {
                            Files.createDirectories(((MappingsProvider)this.getThisObject()).cacheDir, new FileAttribute[0]);
                        }
                        MappingsProvider.pfaccess$0(null).info("Found version metadata from piston-meta.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).checkAndUpdateVersionFile((ManifestMetaFile.VersionMeta)((Object)versionMeta));
                        MappingsProvider.pfaccess$0(null).info("version.json is up to date.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).checkAndUpdateOfficialFile();
                        MappingsProvider.pfaccess$0(null).info("Official mappings are up to date.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).checkAndUpdateMCPConfigFile();
                        MappingsProvider.pfaccess$0(null).info("MCPConfig is up to date.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).loadLayeredMappings();
                        MappingsProvider.pfaccess$0(null).info("Finished runtime mappings setup.");
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, null);
                        try {
                            return callSite;
                        }
                        catch (IOException e) {
                            throw (Throwable)e;
                        }
                        catch (NoSuchElementException e) {
                            throw (Throwable)e;
                        }
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Void doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _startMappingsSetup_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Thread mappingsThread = this.setupMappingsThread((Runnable)((Object)new _startMappingsSetup_closure3(this, this)));
                mappingsThread.start();
            }
        }
    }

    /*
     * Loose catch block
     */
    private void loadLayeredMappings() throws IOException {
        block48: {
            Throwable __$$primaryExc1;
            ZipFile zip;
            block47: {
                block46: {
                    zip = new ZipFile(this.zipPath.toFile());
                    __$$primaryExc1 = null;
                    InputStream joined = zip.getInputStream(new ZipEntry(JOINED_PATH));
                    Throwable __$$primaryExc2 = null;
                    try {
                        Reference srgFile = new Reference((Object)IMappingFile.load((InputStream)joined));
                        Reference officialFile = new Reference((Object)IMappingFile.load((InputStream)NioExtensions.newInputStream((Path)this.officialPath)).reverse());
                        Reference methodsMap = new Reference(new LinkedHashMap(8250));
                        Reference fieldsMap = new Reference(new LinkedHashMap(6500));
                        public final class _loadLayeredMappings_closure4
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference srgFile;
                            private /* synthetic */ Reference officialFile;
                            private /* synthetic */ Reference methodsMap;
                            private /* synthetic */ Reference fieldsMap;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _loadLayeredMappings_closure4(Object _outerInstance, Object _thisObject, Reference srgFile, Reference officialFile, Reference methodsMap, Reference fieldsMap) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                this.srgFile = reference4 = srgFile;
                                this.officialFile = reference3 = officialFile;
                                this.methodsMap = reference2 = methodsMap;
                                this.fieldsMap = reference = fieldsMap;
                            }

                            public Map<String, String> doCall(IMappingFile.IClass clazz) {
                                String official = clazz.getMapped();
                                Reference obf = new Reference((Object)clazz.getOriginal());
                                Reference methods = new Reference(new LinkedHashMap());
                                Reference fields = new Reference(new LinkedHashMap());
                                IMappingFile.IClass iClass = IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get()).getClass((String)obf.get());
                                Collection srgMethods = iClass != null ? iClass.getMethods() : null;
                                IMappingFile.IClass iClass2 = IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get()).getClass((String)obf.get());
                                Collection srgFields = iClass2 != null ? iClass2.getFields() : null;
                                if (srgFields == null || srgMethods == null) {
                                    return IndyInterface.bootstrap("cast", "()", 0, null);
                                }
                                String dotSeparatedOfficial = official.replace("/", ".");
                                Collection officialMethods = IndyInterface.bootstrap("cast", "()", 0, this.officialFile.get()).getClass((String)obf.get()).getMethods();
                                if (!officialMethods.isEmpty()) {
                                    public final class _closure8
                                    extends Closure
                                    implements GeneratedClosure {
                                        private /* synthetic */ Reference srgFile;
                                        private /* synthetic */ Reference obf;
                                        private /* synthetic */ Reference methods;
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;

                                        public _closure8(Object _outerInstance, Object _thisObject, Reference srgFile, Reference obf, Reference methods) {
                                            super(_outerInstance, _thisObject);
                                            Reference reference;
                                            Reference reference2;
                                            Reference reference3;
                                            this.srgFile = reference3 = srgFile;
                                            this.obf = reference2 = obf;
                                            this.methods = reference = methods;
                                        }

                                        public Boolean doCall(IMappingFile.IMethod method) {
                                            String mMoj = method.getMapped();
                                            String mObf = method.getOriginal();
                                            String mObfDesc = method.getDescriptor();
                                            IMappingFile.IMethod iMethod = IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get()).getClass((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.obf.get()))).getMethod(mObf, mObfDesc);
                                            String mSrg = iMethod != null ? iMethod.getMapped() : null;
                                            if (mSrg == null || ScriptBytecodeAdapter.compareEqual((Object)mSrg, (Object)mObf)) {
                                                return IndyInterface.bootstrap("cast", "()", 0, null);
                                            }
                                            public final class _closure10
                                            extends Closure
                                            implements GeneratedClosure {
                                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                                public static transient /* synthetic */ boolean __$stMC;

                                                public _closure10(Object _outerInstance, Object _thisObject) {
                                                    super(_outerInstance, _thisObject);
                                                }

                                                public List doCall(Object it) {
                                                    return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                                                }

                                                @Generated
                                                public Object call(Object args) {
                                                    return this.doCall(args);
                                                }

                                                @Generated
                                                public Object call() {
                                                    return this.doCall(null);
                                                }

                                                @Generated
                                                public List doCall() {
                                                    return this.doCall(null);
                                                }

                                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                    if (((Object)((Object)this)).getClass() != _closure10.class) {
                                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                    }
                                                    ClassInfo classInfo = $staticClassInfo;
                                                    if (classInfo == null) {
                                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                    }
                                                    return classInfo.getMetaClass();
                                                }

                                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                    return MethodHandles.lookup();
                                                }
                                            }
                                            CallSite outSrg = IndyInterface.bootstrap("cast", "()", 0, ((HashMap)((Object)IndyInterface.bootstrap("cast", "()", 0, this.methods.get()))).computeIfAbsent(mMoj, IndyInterface.bootstrap("cast", "()", 0, new _closure10((Object)this, this.getThisObject()))));
                                            return outSrg.add(mSrg);
                                        }

                                        @Generated
                                        public Boolean call(IMappingFile.IMethod method) {
                                            return this.doCall(method);
                                        }

                                        @Generated
                                        public IMappingFile getSrgFile() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get());
                                        }

                                        @Generated
                                        public String getObf() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.obf.get());
                                        }

                                        @Generated
                                        public LinkedHashMap getMethods() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.methods.get());
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                            return MethodHandles.lookup();
                                        }
                                    }
                                    DefaultGroovyMethods.each((Collection)officialMethods, (Closure)new _closure8((Object)this, this.getThisObject(), this.srgFile, obf, methods));
                                    if (!((LinkedHashMap)methods.get()).isEmpty()) {
                                        ((HashMap)((Object)IndyInterface.bootstrap("cast", "()", 0, this.methodsMap.get()))).put(dotSeparatedOfficial, (LinkedHashMap)methods.get());
                                    }
                                }
                                Collection officialFields = IndyInterface.bootstrap("cast", "()", 0, this.officialFile.get()).getClass((String)obf.get()).getFields();
                                if (!officialFields.isEmpty()) {
                                    public final class _closure9
                                    extends Closure
                                    implements GeneratedClosure {
                                        private /* synthetic */ Reference srgFile;
                                        private /* synthetic */ Reference obf;
                                        private /* synthetic */ Reference fields;
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;

                                        public _closure9(Object _outerInstance, Object _thisObject, Reference srgFile, Reference obf, Reference fields) {
                                            super(_outerInstance, _thisObject);
                                            Reference reference;
                                            Reference reference2;
                                            Reference reference3;
                                            this.srgFile = reference3 = srgFile;
                                            this.obf = reference2 = obf;
                                            this.fields = reference = fields;
                                        }

                                        public String doCall(IMappingFile.IField field) {
                                            String fMoj = field.getMapped();
                                            IMappingFile.IField iField = IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get()).getClass((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.obf.get()))).getField(field.getOriginal());
                                            String srg = iField != null ? iField.getMapped() : null;
                                            if (srg == null || ScriptBytecodeAdapter.compareEqual((Object)fMoj, (Object)srg)) {
                                                return IndyInterface.bootstrap("cast", "()", 0, null);
                                            }
                                            return IndyInterface.bootstrap("cast", "()", 0, ((HashMap)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fields.get()))).put(fMoj, srg));
                                        }

                                        @Generated
                                        public String call(IMappingFile.IField field) {
                                            return this.doCall(field);
                                        }

                                        @Generated
                                        public IMappingFile getSrgFile() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get());
                                        }

                                        @Generated
                                        public String getObf() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.obf.get());
                                        }

                                        @Generated
                                        public LinkedHashMap getFields() {
                                            return IndyInterface.bootstrap("cast", "()", 0, this.fields.get());
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                            return MethodHandles.lookup();
                                        }
                                    }
                                    DefaultGroovyMethods.each((Collection)officialFields, (Closure)new _closure9((Object)this, this.getThisObject(), this.srgFile, obf, fields));
                                    if (!((LinkedHashMap)fields.get()).isEmpty()) {
                                        return IndyInterface.bootstrap("cast", "()", 0, ((HashMap)((Object)IndyInterface.bootstrap("cast", "()", 0, this.fieldsMap.get()))).put(dotSeparatedOfficial, (LinkedHashMap)fields.get()));
                                    }
                                }
                                return null;
                            }

                            @Generated
                            public Map<String, String> call(IMappingFile.IClass clazz) {
                                return this.doCall(clazz);
                            }

                            @Generated
                            public IMappingFile getSrgFile() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.srgFile.get());
                            }

                            @Generated
                            public IMappingFile getOfficialFile() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.officialFile.get());
                            }

                            @Generated
                            public LinkedHashMap getMethodsMap() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.methodsMap.get());
                            }

                            @Generated
                            public LinkedHashMap getFieldsMap() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.fieldsMap.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _loadLayeredMappings_closure4.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        DefaultGroovyMethods.each((Collection)((IMappingFile)officialFile.get()).getClasses(), (Closure)new _loadLayeredMappings_closure4(this, this, srgFile, officialFile, methodsMap, fieldsMap));
                        this.mappingsProvider.complete((Either<LoadedMappings, Throwable>)Either.left((Object)new LoadedMappings((LinkedHashMap)methodsMap.get(), (LinkedHashMap)fieldsMap.get())));
                    }
                    catch (Throwable __$$t2) {
                        __$$primaryExc2 = __$$t2;
                        throw __$$t2;
                    }
                    try {
                        if (__$$primaryExc2 != null) {
                            try {
                                Object v0;
                                InputStream inputStream = joined;
                                if (inputStream != null) {
                                    inputStream.close();
                                    v0 = null;
                                    break block46;
                                }
                                v0 = null;
                            }
                            catch (Throwable __$$suppressedExc2) {
                                Object v1;
                                Throwable throwable = __$$primaryExc2;
                                if (throwable != null) {
                                    throwable.addSuppressed(__$$suppressedExc2);
                                    v1 = null;
                                    break block46;
                                }
                                v1 = null;
                            }
                            break block46;
                        }
                        InputStream inputStream = joined;
                        if (inputStream != null) {
                            inputStream.close();
                            v2 = null;
                        } else {
                            v2 = null;
                        }
                        break block46;
                        {
                            catch (Throwable throwable) {
                                if (__$$primaryExc2 != null) {
                                    try {
                                        Object v3;
                                        InputStream inputStream2 = joined;
                                        if (inputStream2 != null) {
                                            inputStream2.close();
                                            v3 = null;
                                        }
                                        v3 = null;
                                    }
                                    catch (Throwable __$$suppressedExc2) {
                                        Object v4;
                                        Throwable throwable2 = __$$primaryExc2;
                                        if (throwable2 != null) {
                                            throwable2.addSuppressed(__$$suppressedExc2);
                                            v4 = null;
                                        }
                                        v4 = null;
                                    }
                                } else {
                                    InputStream inputStream3 = joined;
                                    if (inputStream3 != null) {
                                        inputStream3.close();
                                        v5 = null;
                                    } else {
                                        v5 = null;
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable __$$t1) {
                        __$$primaryExc1 = __$$t1;
                        throw __$$t1;
                    }
                }
                if (!(__$$primaryExc1 != null)) break block47;
                try {
                    Object v6;
                    ZipFile zipFile = zip;
                    if (zipFile != null) {
                        zipFile.close();
                        v6 = null;
                    }
                    v6 = null;
                }
                catch (Throwable __$$suppressedExc1) {
                    Object v7;
                    Throwable throwable = __$$primaryExc1;
                    if (throwable != null) {
                        throwable.addSuppressed(__$$suppressedExc1);
                        v7 = null;
                    }
                    v7 = null;
                }
            }
            ZipFile zipFile = zip;
            if (zipFile != null) {
                zipFile.close();
                v8 = null;
            } else {
                v8 = null;
            }
            break block48;
            catch (Throwable throwable) {
                if (__$$primaryExc1 != null) {
                    try {
                        Object v9;
                        ZipFile zipFile2 = zip;
                        if (zipFile2 != null) {
                            zipFile2.close();
                            v9 = null;
                        }
                        v9 = null;
                    }
                    catch (Throwable __$$suppressedExc1) {
                        Object v10;
                        Throwable throwable3 = __$$primaryExc1;
                        if (throwable3 != null) {
                            throwable3.addSuppressed(__$$suppressedExc1);
                            v10 = null;
                        }
                        v10 = null;
                    }
                } else {
                    ZipFile zipFile3 = zip;
                    if (zipFile3 != null) {
                        zipFile3.close();
                        v11 = null;
                    } else {
                        v11 = null;
                    }
                }
                throw throwable;
            }
        }
        LOGGER.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{NumberNumberMinus.minus((Number)System.currentTimeMillis(), (Number)startTime)}, new String[]{"Loaded runtime mappings in ", "ms"}))));
    }

    private void checkAndUpdateVersionFile(ManifestMetaFile.VersionMeta versionMeta) throws IOException {
        InputStream versionStream;
        block24: {
            String sha1 = versionMeta.getSha1();
            if (Files.exists(this.versionJsonPath, new LinkOption[0])) {
                byte[] existingSha1 = MappingsProvider.calcSha1(this.versionJsonPath);
                byte[] knownSha1 = Hex.decodeHex((String)sha1);
                if (Arrays.equals(knownSha1, existingSha1)) {
                    return;
                }
                LOGGER.warn("Checksum mismatch for version.json");
                LOGGER.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{knownSha1}, new String[]{"Expected: ", ""}))));
                LOGGER.warn((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{existingSha1}, new String[]{"Found:    ", ""}))));
            }
            versionStream = MappingsProvider.downloadFile(versionMeta.getUrl());
            Throwable __$$primaryExc3 = null;
            try {
                try {
                    Files.copy(versionStream, this.versionJsonPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable __$$t3) {
                    __$$primaryExc3 = __$$t3;
                    throw __$$t3;
                }
                if (!(__$$primaryExc3 != null)) break block24;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc3 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = versionStream;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc3) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc3;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc3);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = versionStream;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = versionStream;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc3) {
                Object v4;
                Throwable throwable = __$$primaryExc3;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc3);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = versionStream;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private void checkAndUpdateMCPConfigFile() throws IOException {
        InputStream officialStream;
        block23: {
            Path srg = this.cacheDir.resolve(MCPCONFIG_ZIP);
            if (Files.exists(srg, new LinkOption[0])) {
                return;
            }
            officialStream = MappingsProvider.downloadFile((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.mcpConfigURL)));
            Throwable __$$primaryExc4 = null;
            try {
                try {
                    Files.copy(officialStream, srg, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable __$$t4) {
                    __$$primaryExc4 = __$$t4;
                    throw __$$t4;
                }
                if (!(__$$primaryExc4 != null)) break block23;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc4 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = officialStream;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc4) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc4;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc4);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = officialStream;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = officialStream;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc4) {
                Object v4;
                Throwable throwable = __$$primaryExc4;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc4);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = officialStream;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private void checkAndUpdateOfficialFile() throws IOException {
        InputStream officialStream;
        block24: {
            Reference versionMeta = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, MappingsProvider.getGSON().fromJson((Reader)Files.newBufferedReader(this.versionJsonPath), VersionMetaFile.class)));
            public final class _checkAndUpdateOfficialFile_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference versionMeta;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _checkAndUpdateOfficialFile_closure5(Object _outerInstance, Object _thisObject, Reference versionMeta) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.versionMeta = reference = versionMeta;
                }

                public String doCall() {
                    Dist __$$sev0 = FMLLoader.getDist();
                    Dist dist = __$$sev0;
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.CLIENT)) {
                        return ((VersionMetaFile)((Object)IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get()))).getDownloads().getClient_mappings().getSha1();
                    }
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.DEDICATED_SERVER)) {
                        return ((VersionMetaFile)((Object)IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get()))).getDownloads().getServer_mappings().getSha1();
                    }
                    return null;
                }

                @Generated
                public VersionMetaFile getVersionMeta() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkAndUpdateOfficialFile_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite sha1 = IndyInterface.bootstrap("cast", "()", 0, new _checkAndUpdateOfficialFile_closure5(this, this, versionMeta).call());
            public final class _checkAndUpdateOfficialFile_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference versionMeta;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _checkAndUpdateOfficialFile_closure6(Object _outerInstance, Object _thisObject, Reference versionMeta) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.versionMeta = reference = versionMeta;
                }

                public String doCall() {
                    Dist __$$sev1 = FMLLoader.getDist();
                    Dist dist = __$$sev1;
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.CLIENT)) {
                        return ((VersionMetaFile)((Object)IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get()))).getDownloads().getClient_mappings().getUrl();
                    }
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.DEDICATED_SERVER)) {
                        return ((VersionMetaFile)((Object)IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get()))).getDownloads().getServer_mappings().getUrl();
                    }
                    return null;
                }

                @Generated
                public VersionMetaFile getVersionMeta() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkAndUpdateOfficialFile_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite url = IndyInterface.bootstrap("cast", "()", 0, new _checkAndUpdateOfficialFile_closure6(this, this, versionMeta).call());
            if (Files.exists(this.officialPath, new LinkOption[0])) {
                byte[] existingSha1 = MappingsProvider.calcSha1(this.officialPath);
                byte[] knownSha1 = Hex.decodeHex((String)((Object)sha1));
                if (Arrays.equals(knownSha1, existingSha1)) {
                    return;
                }
            }
            officialStream = MappingsProvider.downloadFile((String)((Object)url));
            Throwable __$$primaryExc5 = null;
            try {
                try {
                    Files.copy(officialStream, this.officialPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable __$$t5) {
                    __$$primaryExc5 = __$$t5;
                    throw __$$t5;
                }
                if (!(__$$primaryExc5 != null)) break block24;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc5 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = officialStream;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc5) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc5;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc5);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = officialStream;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = officialStream;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc5) {
                Object v4;
                Throwable throwable = __$$primaryExc5;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc5);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = officialStream;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private static byte[] calcSha1(Path file) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        byte[] byArray;
        Throwable __$$primaryExc6;
        InputStream input;
        block24: {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            input = Files.newInputStream(file, new OpenOption[0]);
            __$$primaryExc6 = null;
            byte[] buffer = new byte[8192];
            int len = input.read(buffer);
            while (len != -1) {
                sha1.update(buffer, 0, len);
                input.read(buffer);
            }
            byArray = sha1.digest();
            if (!(__$$primaryExc6 != null)) break block24;
            try {
                Object v0;
                InputStream inputStream = input;
                if (inputStream != null) {
                    inputStream.close();
                    v0 = null;
                }
                v0 = null;
            }
            catch (Throwable __$$suppressedExc6) {
                Object v1;
                Throwable throwable = __$$primaryExc6;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc6);
                    v1 = null;
                }
                v1 = null;
            }
        }
        InputStream inputStream = input;
        if (inputStream != null) {
            inputStream.close();
            v2 = null;
        } else {
            v2 = null;
        }
        try {
            try {
                return byArray;
            }
            catch (Throwable __$$t6) {
                __$$primaryExc6 = __$$t6;
                throw __$$t6;
            }
        }
        catch (Throwable throwable) {
            if (__$$primaryExc6 != null) {
                try {
                    Object v3;
                    InputStream inputStream2 = input;
                    if (inputStream2 != null) {
                        inputStream2.close();
                        v3 = null;
                    }
                    v3 = null;
                }
                catch (Throwable __$$suppressedExc6) {
                    Object v4;
                    Throwable throwable2 = __$$primaryExc6;
                    if (throwable2 != null) {
                        throwable2.addSuppressed(__$$suppressedExc6);
                        v4 = null;
                    }
                    v4 = null;
                }
            } else {
                InputStream inputStream3 = input;
                if (inputStream3 != null) {
                    inputStream3.close();
                    v5 = null;
                } else {
                    v5 = null;
                }
            }
            throw throwable;
        }
    }

    private static InputStream downloadFile(String url) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder(new URI(url)).setHeader("Accept-Encoding", "gzip").GET().build();
        HttpResponse<InputStream> response = MappingsProvider.getClient().send(request, HttpResponse.BodyHandlers.ofInputStream());
        if (response.statusCode() != 200) {
            throw (Throwable)new IOException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{url, response.statusCode()}, new String[]{"Failed to download file from \"", "\" (", ")"}))));
        }
        boolean isGzipEncoded = ScriptBytecodeAdapter.compareEqual((Object)response.headers().firstValue("Content-Encoding").orElse(""), (Object)"gzip");
        return isGzipEncoded ? new GZIPInputStream((InputStream)((Object)IndyInterface.bootstrap("cast", "()", 0, response.body()))) : IndyInterface.bootstrap("cast", "()", 0, response.body());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MappingsProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    private static final Gson org_groovymc_gml_mappings_MappingsProvider$GsonHolder_GSON_initExpr() {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    }

    @Generated
    public static Gson getGSON() {
        return GsonHolder_GSON.pfaccess$0(null);
    }

    @Generated
    private static final HttpClient org_groovymc_gml_mappings_MappingsProvider$HttpClientHolder_client_initExpr() {
        return HttpClient.newBuilder().build();
    }

    @Generated
    public static HttpClient getClient() {
        return HttpClientHolder_client.pfaccess$0(null);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MappingsProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MappingsProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MappingsProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, MappingsProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(MappingsProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public static /* synthetic */ Logger pfaccess$0(MappingsProvider $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(MappingsProvider.class, MappingsProvider.class, (String)"LOGGER"));
    }

    public static /* synthetic */ String pfaccess$1(MappingsProvider $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(MappingsProvider.class, MappingsProvider.class, (String)"PISTON_META"));
    }

    public static /* synthetic */ CompletableFuture<Either<LoadedMappings, Throwable>> pfaccess$4(MappingsProvider $that) {
        return $that.mappingsProvider;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        AtomicLong atomicLong;
        Logger logger;
        MappingsProvider mappingsProvider;
        INSTANCE = mappingsProvider = new MappingsProvider();
        LOGGER = logger = LogUtils.getLogger();
        startTime = atomicLong = new AtomicLong(0);
    }

    @Generated
    public final CompletableFuture<Either<LoadedMappings, Throwable>> getMappingsProvider() {
        return this.mappingsProvider;
    }

    private static class GsonHolder_GSON
    implements GroovyObject {
        private static final Gson INSTANCE;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public GsonHolder_GSON() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GsonHolder_GSON.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GsonHolder_GSON.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GsonHolder_GSON.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), this.getClass(), notFound.getArguments());
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GsonHolder_GSON.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GsonHolder_GSON.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GsonHolder_GSON.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), GsonHolder_GSON.class, notFound.getArguments());
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), GsonHolder_GSON.class, notFound.getCause());
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GsonHolder_GSON.class, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GsonHolder_GSON.class, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), GsonHolder_GSON.class, notFound.getCause());
            }
        }

        public static /* synthetic */ Gson pfaccess$0(GsonHolder_GSON $that) {
            return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(GsonHolder_GSON.class, GsonHolder_GSON.class, (String)"INSTANCE"));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GsonHolder_GSON.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        static {
            Gson gson;
            INSTANCE = gson = MappingsProvider.org_groovymc_gml_mappings_MappingsProvider$GsonHolder_GSON_initExpr();
        }
    }

    private static class HttpClientHolder_client
    implements GroovyObject {
        private static final HttpClient INSTANCE;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public HttpClientHolder_client() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(HttpClientHolder_client.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(HttpClientHolder_client.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(HttpClientHolder_client.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), this.getClass(), notFound.getArguments());
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(HttpClientHolder_client.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(HttpClientHolder_client.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(HttpClientHolder_client.class, MappingsProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)new MissingMethodException(notFound.getMethod(), HttpClientHolder_client.class, notFound.getArguments());
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), HttpClientHolder_client.class, notFound.getCause());
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(HttpClientHolder_client.class, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), this.getClass(), notFound.getCause());
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(HttpClientHolder_client.class, MappingsProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)new MissingPropertyException(notFound.getProperty(), HttpClientHolder_client.class, notFound.getCause());
            }
        }

        public static /* synthetic */ HttpClient pfaccess$0(HttpClientHolder_client $that) {
            return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(HttpClientHolder_client.class, HttpClientHolder_client.class, (String)"INSTANCE"));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HttpClientHolder_client.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        static {
            HttpClient httpClient;
            INSTANCE = httpClient = MappingsProvider.org_groovymc_gml_mappings_MappingsProvider$HttpClientHolder_client_initExpr();
        }
    }
}

