/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DataHolder {
    Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
    private Entity entity;
    private boolean pendingSync = false;

    public DataHolder setup(Entity entity) {
        if (this.entity == null) {
            this.entity = entity;
        }
        return this;
    }

    <E extends Entity, T> boolean set(SyncedDataKey<?, ?> key, T value) {
        DataEntry entry = this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2));
        if (!entry.getValue().equals(value)) {
            entry.setValue(value);
            return true;
        }
        return false;
    }

    @Nullable
    <E extends Entity, T> T get(SyncedDataKey<E, T> key) {
        return this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2)).getValue();
    }

    boolean canSync() {
        return this.entity != null && !this.entity.m_9236_().m_5776_();
    }

    void markForSync() {
        if (this.canSync()) {
            this.pendingSync = true;
            SyncedEntityData.instance().markForSync(this.entity);
        }
    }

    boolean isPendingSync() {
        return this.pendingSync;
    }

    void clearSync() {
        this.pendingSync = false;
        this.dataMap.forEach((key, entry) -> entry.clearSync());
    }

    List<DataEntry<?, ?>> gatherPendingSyncDataEntries() {
        return this.dataMap.values().stream().filter(DataEntry::isPendingSync).filter(entry -> entry.getKey().syncMode().willSync()).collect(Collectors.toList());
    }

    List<DataEntry<?, ?>> gatherAllTrackingDataEntries() {
        return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode().willSync()).collect(Collectors.toList());
    }

    public ListTag serialize() {
        ListTag list = new ListTag();
        this.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                CompoundTag keyTag = new CompoundTag();
                keyTag.m_128359_("ClassKey", key.classKey().id().toString());
                keyTag.m_128359_("DataKey", key.id().toString());
                keyTag.m_128365_("Value", entry.writeValue());
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    public void deserialize(ListTag listTag) {
        this.dataMap.clear();
        listTag.forEach(entryTag -> {
            CompoundTag keyTag = (CompoundTag)entryTag;
            ResourceLocation classKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("ClassKey"));
            ResourceLocation dataKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("DataKey"));
            Tag value = keyTag.m_128423_("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            Map<ResourceLocation, SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getDataKeys(syncedClassKey);
            if (keys == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = keys.get(dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(this, syncedDataKey);
            entry.readValue(value);
            this.dataMap.put(syncedDataKey, entry);
        });
    }
}

