/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.FiguraConfirmScreen;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.CustomFramebuffer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL30;

public final class UIHelper {
    public static final ResourceLocation OUTLINE_FILL = new FiguraIdentifier("textures/gui/outline_fill.png");
    public static final ResourceLocation OUTLINE = new FiguraIdentifier("textures/gui/outline.png");
    public static final ResourceLocation TOOLTIP = new FiguraIdentifier("textures/gui/tooltip.png");
    public static final ResourceLocation UI_FONT = new FiguraIdentifier("ui");
    public static final ResourceLocation SPECIAL_FONT = new FiguraIdentifier("special");
    public static final Component UP_ARROW = Component.m_237113_((String)"^").m_130948_(Style.f_131099_.m_131150_(UI_FONT));
    public static final Component DOWN_ARROW = Component.m_237113_((String)"V").m_130948_(Style.f_131099_.m_131150_(UI_FONT));
    private static final CustomFramebuffer FIGURA_FRAMEBUFFER = new CustomFramebuffer();
    private static int previousFBO = -1;
    public static boolean paperdoll = false;
    public static float fireRot = 0.0f;
    public static float dollScale = 1.0f;

    private UIHelper() {
    }

    public static void useFiguraGuiFramebuffer() {
        previousFBO = GL30.glGetInteger((int)36006);
        int width = Minecraft.m_91087_().m_91268_().m_85441_();
        int height = Minecraft.m_91087_().m_91268_().m_85442_();
        FIGURA_FRAMEBUFFER.setSize(width, height);
        GL30.glEnable((int)2960);
        GlStateManager._stencilMask((int)255);
        GlStateManager._glBindFramebuffer((int)36160, (int)FIGURA_FRAMEBUFFER.getFbo());
        GlStateManager._clearStencil((int)0);
        GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)17664, (boolean)false);
        Matrix4f mf = RenderSystem.getProjectionMatrix();
        Minecraft.m_91087_().m_91385_().m_83957_(width, height, false);
        RenderSystem.setProjectionMatrix((Matrix4f)mf, (VertexSorting)VertexSorting.f_276633_);
    }

    public static void useVanillaFramebuffer() {
        GlStateManager._enableDepthTest();
        GlStateManager._stencilFunc((int)514, (int)0, (int)255);
        GL30.glDisable((int)2960);
        GlStateManager._glBindFramebuffer((int)36009, (int)previousFBO);
        RenderSystem.disableBlend();
        int windowWidth = Minecraft.m_91087_().m_91268_().m_85441_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        Matrix4f mf = RenderSystem.getProjectionMatrix();
        FIGURA_FRAMEBUFFER.drawToScreen(windowWidth, windowHeight);
        RenderSystem.setProjectionMatrix((Matrix4f)mf, (VertexSorting)VertexSorting.f_276633_);
        RenderSystem.enableBlend();
    }

    public static void drawEntity(float x, float y, float scale, float pitch, float yaw, LivingEntity entity, GuiGraphics gui, EntityRenderMode renderMode) {
        float yRot;
        float xRot;
        float headX = entity.m_146909_();
        float headY = entity.f_20885_;
        boolean invisible = entity.m_20145_();
        float bodyY = entity.f_20883_;
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity2;
            bodyY = l.f_20883_;
        }
        double xPos = 0.0;
        double yPos = 0.0;
        switch (renderMode) {
            case PAPERDOLL: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                yPos -= 1.0;
                if (entity.m_21255_()) {
                    xPos += (double)Mth.m_14156_((float)((float)Math.toRadians(270.0)), (float)((float)Math.PI * 2));
                }
                if (entity.m_21209_() || entity.m_6067_() || entity.m_21255_()) {
                    yPos += 1.0;
                    entity.m_146926_(0.0f);
                }
                Lighting.m_166384_();
                if (!((Boolean)Configs.PAPERDOLL_INVISIBLE.value).booleanValue()) break;
                entity.m_6842_(false);
                break;
            }
            case FIGURA_GUI: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                if (!((Boolean)Configs.PREVIEW_HEAD_ROTATION.value).booleanValue()) {
                    entity.m_146926_(0.0f);
                    entity.f_20885_ = bodyY;
                }
                yPos -= 1.0;
                Lighting.m_84930_();
                RenderSystem.setShaderLights((Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(-0.2f, -1.0f, -1.0f), Vector3f::normalize)), (Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(-0.2f, 0.4f, -0.3f), Vector3f::normalize)));
                entity.m_6842_(false);
                break;
            }
            default: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                entity.m_146926_(-xRot);
                entity.f_20885_ = -yaw + bodyY;
                Lighting.m_166384_();
            }
        }
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        pose.m_85837_((double)x, (double)y, 250.0);
        pose.m_85841_(scale, scale, scale);
        pose.m_85850_().m_252922_().scale(1.0f, 1.0f, -1.0f);
        Avatar avatar = AvatarManager.getAvatar((Entity)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && !avatar.luaRuntime.renderer.getRootRotationAllowed().booleanValue()) {
            yRot = yaw;
        }
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion2 = Axis.f_252436_.m_252977_(yRot);
        Quaternionf quaternion3 = Axis.f_252529_.m_252977_(xRot);
        quaternion3.mul((Quaternionfc)quaternion2);
        quaternion.mul((Quaternionfc)quaternion3);
        pose.m_252781_(quaternion);
        quaternion3.conjugate();
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = minecraft.m_91290_();
        boolean renderHitboxes = dispatcher.m_114377_();
        dispatcher.m_114473_(false);
        dispatcher.m_114468_(false);
        dispatcher.m_252923_(quaternion3);
        MultiBufferSource.BufferSource immediate = minecraft.m_91269_().m_110104_();
        paperdoll = true;
        fireRot = -yRot;
        dollScale = scale;
        if (avatar != null) {
            avatar.renderMode = renderMode;
        }
        double finalXPos = xPos;
        double finalYPos = yPos;
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_((Entity)entity, finalXPos, finalYPos, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)immediate, 0xF000F0));
        immediate.m_109911_();
        paperdoll = false;
        dispatcher.m_114473_(renderHitboxes);
        dispatcher.m_114468_(true);
        pose.m_85849_();
        Lighting.m_84931_();
        entity.m_146926_(headX);
        entity.f_20885_ = headY;
        entity.m_6842_(invisible);
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static void prepareTexture(ResourceLocation texture) {
        UIHelper.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::m_172817_);
    }

    public static void blit(GuiGraphics gui, int x, int y, int width, int height, ResourceLocation texture) {
        gui.m_280411_(texture, x, y, width, height, 0.0f, 0.0f, 1, 1, 1, 1);
    }

    public static void renderAnimatedBackground(GuiGraphics gui, ResourceLocation texture, float x, float y, float width, float height, float textureWidth, float textureHeight, double speed, float delta) {
        if (speed != 0.0) {
            double d = (double)((float)FiguraMod.ticks + delta) * speed;
            x = (float)((double)x - d % (double)textureWidth);
            y = (float)((double)y - d % (double)textureHeight);
        }
        width += textureWidth;
        height += textureHeight;
        if (speed < 0.0) {
            x -= textureWidth;
            y -= textureHeight;
        }
        UIHelper.renderBackgroundTexture(gui, texture, x, y, width, height, textureWidth, textureHeight);
    }

    public static void renderBackgroundTexture(GuiGraphics gui, ResourceLocation texture, float x, float y, float width, float height, float textureWidth, float textureHeight) {
        UIHelper.prepareTexture(texture);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float u1 = width / textureWidth;
        float v1 = height / textureHeight;
        UIHelper.quad(bufferBuilder, gui.m_280168_().m_85850_().m_252922_(), x, y, width, height, -999.0f, 0.0f, u1, 0.0f, v1);
        tessellator.m_85914_();
    }

    public static void fillRounded(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.m_280509_(x + 1, y, x + width - 1, y + 1, color);
        gui.m_280509_(x, y + 1, x + width, y + height - 1, color);
        gui.m_280509_(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    public static void fillOutline(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.m_280509_(x + 1, y, x + width - 1, y + 1, color);
        gui.m_280509_(x, y + 1, x + 1, y + height - 1, color);
        gui.m_280509_(x + width - 1, y + 1, x + width, y + height - 1, color);
        gui.m_280509_(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    public static void blitSliced(GuiGraphics gui, int x, int y, int width, int height, ResourceLocation texture) {
        UIHelper.blitSliced(gui, x, y, width, height, 0.0f, 0.0f, 15, 15, 15, 15, texture);
    }

    public static void blitSliced(GuiGraphics gui, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, ResourceLocation texture) {
        UIHelper.prepareTexture(texture);
        Matrix4f pose = gui.m_280168_().m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float rWidthThird = (float)regionWidth / 3.0f;
        float rHeightThird = (float)regionHeight / 3.0f;
        UIHelper.quad(buffer, pose, x, y, rWidthThird, rHeightThird, u, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, y, (float)width - rWidthThird * 2.0f, rHeightThird, u + rWidthThird, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, y, rWidthThird, rHeightThird, u + rWidthThird * 2.0f, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, x, (float)y + rHeightThird, rWidthThird, (float)height - rHeightThird * 2.0f, u, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, (float)y + rHeightThird, (float)width - rWidthThird * 2.0f, (float)height - rHeightThird * 2.0f, u + rWidthThird, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, (float)y + rHeightThird, rWidthThird, (float)height - rHeightThird * 2.0f, u + rWidthThird * 2.0f, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, x, (float)(y + height) - rHeightThird, rWidthThird, rHeightThird, u, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, (float)(y + height) - rHeightThird, (float)width - rWidthThird * 2.0f, rHeightThird, u + rWidthThird, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, (float)(y + height) - rHeightThird, rWidthThird, rHeightThird, u + rWidthThird * 2.0f, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        tessellator.m_85914_();
    }

    public static void renderHalfTexture(GuiGraphics gui, int x, int y, int width, int height, int textureWidth, ResourceLocation texture) {
        UIHelper.renderHalfTexture(gui, x, y, width, height, 0.0f, 0.0f, textureWidth, 1, textureWidth, 1, texture);
    }

    public static void renderHalfTexture(GuiGraphics gui, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, ResourceLocation texture) {
        UIHelper.enableBlend();
        int w = width / 2;
        gui.m_280411_(texture, x, y, w, height, u, v, w, regionHeight, textureWidth, textureHeight);
        x += w;
        if (width % 2 == 1) {
            ++w;
        }
        gui.m_280411_(texture, x, y, w, height, u + (float)regionWidth - (float)w, v, w, regionHeight, textureWidth, textureHeight);
    }

    public static void renderSprite(GuiGraphics gui, int x, int y, int z, int width, int height, TextureAtlasSprite sprite) {
        UIHelper.prepareTexture(sprite.m_247685_());
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        UIHelper.quad(bufferBuilder, gui.m_280168_().m_85850_().m_252922_(), x, y, width, height, z, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private static void quad(BufferBuilder bufferBuilder, Matrix4f pose, float x, float y, float width, float height, float u, float v, float regionWidth, float regionHeight, int textureWidth, int textureHeight) {
        float u0 = u / (float)textureWidth;
        float v0 = v / (float)textureHeight;
        float u1 = (u + regionWidth) / (float)textureWidth;
        float v1 = (v + regionHeight) / (float)textureHeight;
        UIHelper.quad(bufferBuilder, pose, x, y, width, height, 0.0f, u0, u1, v0, v1);
    }

    private static void quad(BufferBuilder bufferBuilder, Matrix4f pose, float x, float y, float width, float height, float z, float u0, float u1, float v0, float v1) {
        float x1 = x + width;
        float y1 = y + height;
        bufferBuilder.m_252986_(pose, x, y1, z).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(pose, x1, y1, z).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(pose, x1, y, z).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(pose, x, y, z).m_7421_(u0, v0).m_5752_();
    }

    public static void renderWithoutScissors(GuiGraphics gui, Consumer<GuiGraphics> toRun) {
        gui.m_280588_(0, 0, 1, 1);
        RenderSystem.disableScissor();
        toRun.accept(gui);
        gui.m_280618_();
    }

    public static void highlight(GuiGraphics gui, FiguraWidget widget, Component text) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof AbstractPanelScreen)) {
            return;
        }
        AbstractPanelScreen panel = (AbstractPanelScreen)screen;
        int screenW = panel.f_96543_;
        int screenH = panel.f_96544_;
        int x = widget.m_252754_();
        int y = widget.m_252907_();
        int width = widget.m_5711_();
        int height = widget.m_93694_();
        int color = -587202560;
        gui.m_280509_(0, 0, x, y + height, color);
        gui.m_280509_(x + width, y, screenW, screenH, color);
        gui.m_280509_(x, 0, screenW, y, color);
        gui.m_280509_(0, y + height, x + width, screenH, color);
        UIHelper.fillOutline(gui, Math.max(x - 1, 0), Math.max(y - 1, 0), Math.min(width + 2, screenW), Math.min(height + 2, screenH), -1);
        if (text == null) {
            return;
        }
        int bottomDistance = screenH - (y + height);
        int rightDistance = screenW - (x + width);
        int verArea = y * screenW - bottomDistance * screenW;
        int horArea = x * screenH - rightDistance * screenH;
        FiguraVec4 square = new FiguraVec4();
        if (Math.abs(verArea) > Math.abs(horArea)) {
            if (verArea >= 0) {
                square.set(0.0, 0.0, (double)screenW, (double)y);
            } else {
                square.set(0.0, (double)(y + height), (double)screenW, (double)bottomDistance);
            }
        } else if (horArea >= 0) {
            square.set(0.0, 0.0, (double)x, (double)screenH);
        } else {
            square.set(x + width, 0.0, (double)rightDistance, (double)screenH);
        }
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY) {
        return UIHelper.isMouseOver(x, y, width, height, mouseX, mouseY, false);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY, boolean force) {
        ContextMenu context = force ? null : UIHelper.getContext();
        return (context == null || !context.isVisible()) && mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public static void renderOutlineText(GuiGraphics gui, Font textRenderer, Component text, int x, int y, int color, int outline) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        textRenderer.m_168645_(text.m_7532_(), (float)x, (float)y, color, outline, gui.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
    }

    public static void renderTooltip(GuiGraphics gui, Component tooltip, int mouseX, int mouseY, boolean background) {
        Minecraft minecraft = Minecraft.m_91087_();
        int screenX = minecraft.m_91268_().m_85445_();
        int screenY = minecraft.m_91268_().m_85446_();
        boolean reduced = (Boolean)Configs.REDUCED_MOTION.value;
        int x = reduced ? 0 : mouseX;
        int y = reduced ? screenY : mouseY - 12;
        Font font = minecraft.f_91062_;
        List<FormattedCharSequence> text = TextUtils.wrapTooltip((FormattedText)tooltip, font, x, screenX, 12);
        Objects.requireNonNull(font);
        int height = 9 * text.size();
        y = Math.min(Math.max(y, 0), screenY - height);
        int width = TextUtils.getWidth(text, font);
        if ((x += 12) + width > screenX) {
            x = Math.max(x - width - 24, 0);
        }
        if (reduced) {
            x += (screenX - width) / 2;
            if (background) {
                y -= 4;
            }
        }
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_85837_(0.0, 0.0, 999.0);
        if (background) {
            UIHelper.blitSliced(gui, x - 4, y - 4, width + 8, height + 8, TOOLTIP);
        }
        for (int i = 0; i < text.size(); ++i) {
            FormattedCharSequence charSequence = text.get(i);
            Objects.requireNonNull(font);
            gui.m_280648_(font, charSequence, x, y + 9 * i, 0xFFFFFF);
        }
        gui.m_280168_().m_85849_();
    }

    public static void renderScrollingText(GuiGraphics gui, Component text, int x, int y, int width, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92852_((FormattedText)text);
        int textX = x;
        if (textWidth <= width) {
            gui.m_280430_(font, text, textX, y, color);
            return;
        }
        Objects.requireNonNull(font);
        gui.m_280588_(x, y, x + width, y + 9);
        gui.m_280430_(font, text, textX += UIHelper.getTextScrollingOffset(textWidth, width, false), y, color);
        gui.m_280618_();
    }

    public static void renderCenteredScrollingText(GuiGraphics gui, Component text, int x, int y, int width, int height, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92852_((FormattedText)text);
        int textX = x + width / 2;
        int n = y + height / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        if (textWidth <= width) {
            gui.m_280653_(font, text, textX, textY, color);
            return;
        }
        gui.m_280588_(x, y, x + width, y + height);
        gui.m_280653_(font, text, textX += UIHelper.getTextScrollingOffset(textWidth, width, true), textY, color);
        gui.m_280618_();
    }

    private static int getTextScrollingOffset(int textWidth, int width, boolean centered) {
        float speed = ((Float)Configs.TEXT_SCROLL_SPEED.tempValue).floatValue();
        int scrollLen = textWidth - width;
        int startingOffset = (int)Math.ceil((double)scrollLen / 2.0);
        int stopDelay = (int)((float)((Integer)Configs.TEXT_SCROLL_DELAY.tempValue).intValue() * speed);
        int time = scrollLen + stopDelay;
        int totalTime = time * 2;
        int ticks = (int)((float)FiguraMod.ticks * speed);
        int currentTime = ticks % time;
        int dir = ticks % totalTime > time - 1 ? 1 : -1;
        int clamp = Math.min(Math.max(currentTime - stopDelay, 0), scrollLen);
        return (startingOffset - clamp) * dir - (centered ? 0 : startingOffset);
    }

    public static Runnable openURL(String url) {
        Minecraft minecraft = Minecraft.m_91087_();
        return () -> minecraft.m_91152_((Screen)new FiguraConfirmScreen.FiguraConfirmLinkScreen(bl -> {
            if (bl) {
                Util.m_137581_().m_137646_(url);
            }
        }, url, minecraft.f_91080_));
    }

    public static void renderLoading(GuiGraphics gui, int x, int y) {
        MutableComponent text = Component.m_237113_((String)Integer.toHexString(Math.abs(FiguraMod.ticks) % 16)).m_130948_(Style.f_131099_.m_131150_(Badges.FONT));
        Font font = Minecraft.m_91087_().f_91062_;
        int n = x - font.m_92852_((FormattedText)text) / 2;
        Objects.requireNonNull(font);
        gui.m_280614_(font, (Component)text, n, y - 9 / 2, -1, false);
    }

    public static void setContext(ContextMenu context) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)screen;
            panelScreen.contextMenu = context;
        }
    }

    public static ContextMenu getContext() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)screen;
            return panelScreen.contextMenu;
        }
        return null;
    }

    public static void setTooltip(Component text) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)screen;
            panelScreen.tooltip = text;
        }
    }

    public static void setTooltip(Style style) {
        if (style == null || style.m_131186_() == null) {
            return;
        }
        Component text = (Component)style.m_131186_().m_130823_(HoverEvent.Action.f_130831_);
        if (text != null) {
            UIHelper.setTooltip(text);
        }
    }
}

