/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.figuramc.figura.lua.api.json.FiguraJsonSerializer;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.math.vector.FiguraVector;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaUtils {
    public static Object[] parseVec(String methodName, int[] vectorSizes, double[] defaultValues, Class<?>[] expectedReturns, Object ... args) {
        ArrayList<Object> ret = new ArrayList<Object>(args.length);
        int i = 0;
        for (int size : vectorSizes) {
            Object object = args[i];
            if (object instanceof FiguraVector) {
                FiguraVector vec = (FiguraVector)object;
                if (vec.size() != size) {
                    throw new LuaError("Illegal argument at position " + (i + 1) + " to " + methodName + "(): Expected Vector" + size + ", recieved Vector" + vec.size());
                }
                ret.add(vec);
                ++i;
                continue;
            }
            if (args[i] == null || args[i] instanceof Number) {
                double[] vec = new double[size];
                for (int o = 0; o < size; ++o) {
                    Object object2 = args[i + o];
                    if (object2 instanceof Number) {
                        Number n = (Number)object2;
                        vec[o] = n.doubleValue();
                        continue;
                    }
                    if (args[i + o] == null) {
                        vec[o] = defaultValues[o];
                        continue;
                    }
                    throw new LuaError("Illegal argument at position " + (i + o + 1) + " to " + methodName + "(): Expected Number, recieved " + args[i + o].getClass().getSimpleName() + " (" + args[i + o] + ")");
                }
                ret.add(switch (size) {
                    case 2 -> FiguraVec2.of(vec[0], vec[1]);
                    case 3 -> FiguraVec3.of(vec[0], vec[1], vec[2]);
                    case 4 -> FiguraVec4.of(vec[0], vec[1], vec[2], vec[3]);
                    default -> throw new IllegalArgumentException("Illegal vector size: " + size);
                });
                i += size;
                continue;
            }
            if (args[i] == null) {
                ret.add(switch (size) {
                    case 2 -> FiguraVec2.of(defaultValues[0], defaultValues[1]);
                    case 3 -> FiguraVec3.of(defaultValues[0], defaultValues[1], defaultValues[2]);
                    case 4 -> FiguraVec4.of(defaultValues[0], defaultValues[1], defaultValues[2], defaultValues[3]);
                    default -> throw new IllegalArgumentException("Illegal vector size: " + size);
                });
                ++i;
                continue;
            }
            throw new LuaError("Illegal argument at position " + (i + 1) + " to " + methodName + "(): Expected Vector" + size + " or Number, recieved " + args[i].getClass().getSimpleName() + " (" + args[i] + ")");
        }
        for (int o = i; o < args.length; ++o) {
            if (args[o] != null && o - i < expectedReturns.length && !expectedReturns[o - i].isAssignableFrom(args[o].getClass())) {
                throw new LuaError("Illegal argument at position " + (o + 1) + " to " + methodName + "(): Expected " + expectedReturns[o - i].getSimpleName() + ", recieved " + args[o].getClass().getSimpleName() + " (" + args[o] + ")");
            }
            ret.add(args[o]);
        }
        return ret.toArray();
    }

    public static Object[] parseVec(String methodName, int[] vectorSizes, Class<?>[] expectedReturns, Object ... args) {
        return LuaUtils.parseVec(methodName, vectorSizes, new double[]{0.0, 0.0, 0.0, 0.0}, expectedReturns, args);
    }

    public static FiguraVec2 parseVec2(String methodName, Object x, Number y) {
        return LuaUtils.parseVec2(methodName, x, y, 0.0, 0.0);
    }

    public static FiguraVec2 parseVec2(String methodName, Object x, Number y, double defaultX, double defaultY) {
        if (x instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            return FiguraVec2.of(((Number)x).doubleValue(), y.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static FiguraVec3 parseVec3(String methodName, Object x, Number y, Number z) {
        return LuaUtils.parseVec3(methodName, x, y, z, 0.0, 0.0, 0.0);
    }

    public static FiguraVec3 parseVec3(String methodName, Object x, Number y, Number z, double defaultX, double defaultY, double defaultZ) {
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            if (z == null) {
                z = defaultZ;
            }
            return FiguraVec3.of(((Number)x).doubleValue(), y.doubleValue(), z.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static FiguraVec3 parseOneArgVec(String methodName, Object x, Number y, Number z, double defaultArg) {
        double d;
        if (x instanceof Number) {
            Number n = (Number)x;
            d = n.doubleValue();
        } else {
            d = defaultArg;
        }
        double d2 = d;
        return LuaUtils.parseVec3(methodName, x, y, z, d2, d2, d2);
    }

    public static FiguraVec3 nullableVec3(String methodName, Object x, Number y, Number z) {
        return x == null ? null : LuaUtils.parseVec3(methodName, x, y, z);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<FiguraVec3, FiguraVec3> parse2Vec3(String methodName, Object x, Object y, Number z, Object w, Number t, Number h, int xIndex) {
        FiguraVec3 b;
        FiguraVec3 a;
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec1 = (FiguraVec3)x;
            a = vec1.copy();
            if (y instanceof FiguraVec3) {
                FiguraVec3 vec2 = (FiguraVec3)y;
                b = vec2.copy();
                return Pair.of((Object)a, (Object)b);
            } else {
                if (y != null && !(y instanceof Number)) throw new LuaError("Illegal argument at position " + xIndex + "1 to " + methodName + "(): " + y);
                if (w != null && !(w instanceof Number)) throw new LuaError("Illegal argument at position" + xIndex + "3to " + methodName + "(): " + w);
                b = LuaUtils.parseVec3(methodName, y, z, (Number)w);
            }
            return Pair.of((Object)a, (Object)b);
        } else {
            if ((!(x instanceof Number) || y != null) && !(y instanceof Number)) throw new LuaError("Illegal argument at position " + xIndex + " to " + methodName + "(): " + x);
            a = LuaUtils.parseVec3(methodName, x, (Number)y, z);
            if (w instanceof FiguraVec3) {
                FiguraVec3 vec1 = (FiguraVec3)w;
                b = vec1.copy();
                return Pair.of((Object)a, (Object)b);
            } else {
                if (w != null && !(w instanceof Number)) throw new LuaError("Illegal argument at position " + xIndex + "3 to " + methodName + "(): " + w);
                b = LuaUtils.parseVec3(methodName, w, t, h);
            }
        }
        return Pair.of((Object)a, (Object)b);
    }

    public static Pair<FiguraVec3, Object[]> parseVec3(String methodName, Class<?>[] expectedReturns, Object ... args) {
        Object[] parsed = LuaUtils.parseVec(methodName, new int[]{3}, expectedReturns, args);
        return Pair.of((Object)((FiguraVec3)parsed[0]), (Object)Arrays.copyOfRange(parsed, 1, parsed.length));
    }

    public static Pair<Pair<FiguraVec3, FiguraVec3>, Object[]> parse2Vec3(String methodName, Class<?>[] expectedReturns, Object ... args) {
        Object[] parsed = LuaUtils.parseVec(methodName, new int[]{3, 3}, expectedReturns, args);
        return Pair.of((Object)Pair.of((Object)((FiguraVec3)parsed[0]), (Object)((FiguraVec3)parsed[1])), (Object)Arrays.copyOfRange(parsed, 2, parsed.length));
    }

    public static FiguraVec4 parseVec4(String methodName, Object x, Number y, Number z, Number w, double defaultX, double defaultY, double defaultZ, double defaultW) {
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)x;
            return FiguraVec4.of(vec.x, vec.y, vec.z, defaultW);
        }
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            if (z == null) {
                z = defaultZ;
            }
            if (w == null) {
                w = defaultW;
            }
            return FiguraVec4.of(((Number)x).doubleValue(), y.doubleValue(), z.doubleValue(), w.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static ItemStack parseItemStack(String methodName, Object item) {
        if (item == null) {
            return ItemStack.f_41583_;
        }
        if (item instanceof ItemStackAPI) {
            ItemStackAPI wrapper = (ItemStackAPI)item;
            return wrapper.itemStack;
        }
        if (item instanceof String) {
            String string = (String)item;
            try {
                Level level = WorldAPI.getCurrentWorld();
                return ItemArgument.m_235279_((CommandBuildContext)CommandBuildContext.m_255418_((HolderLookup.Provider)level.m_9598_(), (FeatureFlagSet)level.m_246046_())).parse(new StringReader(string)).m_120980_(1, false);
            }
            catch (Exception e) {
                throw new LuaError("Could not parse item stack from string: " + string);
            }
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + item);
    }

    public static BlockState parseBlockState(String methodName, Object block) {
        if (block == null) {
            return Blocks.f_50016_.m_49966_();
        }
        if (block instanceof BlockStateAPI) {
            BlockStateAPI wrapper = (BlockStateAPI)block;
            return wrapper.blockState;
        }
        if (block instanceof String) {
            String string = (String)block;
            try {
                Level level = WorldAPI.getCurrentWorld();
                return BlockStateArgument.m_234650_((CommandBuildContext)CommandBuildContext.m_255418_((HolderLookup.Provider)level.m_9598_(), (FeatureFlagSet)level.m_246046_())).parse(new StringReader(string)).m_114669_();
            }
            catch (Exception e) {
                throw new LuaError("Could not parse block state from string: " + string);
            }
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + block);
    }

    public static ResourceLocation parsePath(String path) {
        try {
            return new ResourceLocation(path);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    public static Object[] parseBlockHitResult(HitResult hitResult) {
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.m_82425_();
            return new Object[]{new BlockStateAPI(WorldAPI.getCurrentWorld().m_8055_(pos), pos), FiguraVec3.fromVec3(blockHit.m_82450_()), blockHit.m_82434_().m_122433_()};
        }
        return null;
    }

    public static int parseSlot(Object slot, Inventory inventory) {
        if (slot instanceof String) {
            String s = (String)slot;
            try {
                return SlotArgument.m_111276_().parse(new StringReader(s));
            }
            catch (Exception e) {
                throw new LuaError("Unable to get slot \"" + slot + "\"");
            }
        }
        if (slot instanceof Integer) {
            Integer i = (Integer)slot;
            if (i == -1 && inventory != null) {
                return inventory.m_36062_();
            }
            return i;
        }
        throw new LuaError("Invalid type for getSlot: " + slot.getClass().getSimpleName());
    }

    public static JsonElement asJsonValue(LuaValue value) {
        Object object;
        if (value.isnil()) {
            return JsonNull.INSTANCE;
        }
        if (value.isboolean()) {
            return new JsonPrimitive(Boolean.valueOf(value.checkboolean()));
        }
        if (value instanceof LuaString) {
            LuaString s = (LuaString)value;
            return new JsonPrimitive(s.checkjstring());
        }
        if (value.isint()) {
            return new JsonPrimitive((Number)value.checkint());
        }
        if (value.isnumber()) {
            return new JsonPrimitive((Number)value.checkdouble());
        }
        if (value.istable()) {
            LuaTable table = value.checktable();
            if (LuaUtils.checkTableArray(table)) {
                JsonArray arr = new JsonArray();
                LuaValue[] keys = table.keys();
                int arrayLength = keys[keys.length - 1].checkint();
                for (int i = 1; i <= arrayLength; ++i) {
                    arr.add(LuaUtils.asJsonValue(table.get(i)));
                }
                return arr;
            }
            JsonObject object2 = new JsonObject();
            for (LuaValue key : table.keys()) {
                object2.add(key.tojstring(), LuaUtils.asJsonValue(table.get(key)));
            }
            return object2;
        }
        if (value.isuserdata() && (object = value.checkuserdata()) instanceof FiguraJsonSerializer.JsonValue) {
            FiguraJsonSerializer.JsonValue val = (FiguraJsonSerializer.JsonValue)object;
            return val.getElement();
        }
        return null;
    }

    public static boolean checkTableArray(LuaTable table) {
        for (LuaValue key : table.keys()) {
            if (key.isnumber()) continue;
            return false;
        }
        return true;
    }
}

