/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.permissions;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.entries.FiguraPermissions;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.IOUtils;

public class PermissionManager {
    public static final Map<Permissions.Category, PermissionPack.CategoryPermissionPack> CATEGORIES = new LinkedHashMap<Permissions.Category, PermissionPack.CategoryPermissionPack>();
    private static final Map<UUID, PermissionPack.PlayerPermissionPack> PLAYERS = new HashMap<UUID, PermissionPack.PlayerPermissionPack>();
    private static final Set<UUID> BACKEND_CHECKED = new HashSet<UUID>();
    public static final Map<String, Collection<Permissions>> CUSTOM_PERMISSIONS = new HashMap<String, Collection<Permissions>>();

    public static void init() {
        for (Permissions.Category category : Permissions.Category.values()) {
            PermissionPack.CategoryPermissionPack container = new PermissionPack.CategoryPermissionPack(category);
            CATEGORIES.put(category, container);
        }
        IOUtils.readCacheFile("permissions", PermissionManager::readNbt);
    }

    public static void reinit() {
        BACKEND_CHECKED.clear();
        CATEGORIES.clear();
        PLAYERS.clear();
        PermissionManager.init();
    }

    public static void initEntryPoints(Set<FiguraPermissions> set) {
        for (FiguraPermissions figuraPermissions : set) {
            CUSTOM_PERMISSIONS.put(figuraPermissions.getTitle(), figuraPermissions.getPermissions());
        }
    }

    private static void readNbt(CompoundTag nbt) {
        String name;
        CompoundTag compound;
        ListTag groupList = nbt.m_128437_("groups", 10);
        ListTag playerList = nbt.m_128437_("players", 10);
        for (Tag nbtElement : groupList) {
            compound = (CompoundTag)nbtElement;
            name = compound.m_128461_("name");
            try {
                Permissions.Category category = Permissions.Category.valueOf(name);
                PermissionPack pack = CATEGORIES.get((Object)category);
                pack.loadNbt(compound);
            }
            catch (Exception ignored) {
                FiguraMod.LOGGER.warn("Failed to load permissions for \"{}\"", (Object)name);
            }
        }
        for (Tag value : playerList) {
            compound = (CompoundTag)value;
            name = compound.m_128461_("name");
            try {
                UUID uuid = UUID.fromString(name);
                String parent = compound.m_128461_("category");
                Permissions.Category category = Permissions.Category.valueOf(parent);
                PermissionPack.CategoryPermissionPack parentPack = CATEGORIES.get((Object)category);
                PermissionPack.PlayerPermissionPack pack = new PermissionPack.PlayerPermissionPack(parentPack, name);
                pack.loadNbt(compound);
                PLAYERS.put(uuid, pack);
            }
            catch (Exception ignored) {
                FiguraMod.LOGGER.warn("Failed to load permissions for \"{}\"", (Object)name);
            }
        }
    }

    public static void saveToDisk() {
        IOUtils.saveCacheFile("permissions", nbt -> {
            ListTag groupList = new ListTag();
            ListTag playerList = new ListTag();
            for (PermissionPack permissionPack : CATEGORIES.values()) {
                if (!permissionPack.hasChanges()) continue;
                CompoundTag container = new CompoundTag();
                permissionPack.writeNbt(container);
                groupList.add((Object)container);
            }
            for (PermissionPack.PlayerPermissionPack playerPermissionPack : PLAYERS.values()) {
                Permissions.Category category = PermissionManager.getDefaultCategory();
                if (category == null) {
                    category = Permissions.Category.DEFAULT;
                }
                if (!playerPermissionPack.hasChanges() && playerPermissionPack.getCategory() == category) continue;
                CompoundTag container = new CompoundTag();
                playerPermissionPack.writeNbt(container);
                playerList.add((Object)container);
            }
            nbt.m_128365_("groups", (Tag)groupList);
            nbt.m_128365_("players", (Tag)playerList);
            FiguraMod.debug("Saved Permissions", new Object[0]);
        });
    }

    public static PermissionPack.PlayerPermissionPack get(UUID id) {
        if (PLAYERS.containsKey(id)) {
            return PLAYERS.get(id);
        }
        Permissions.Category category = PermissionManager.getDefaultCategory();
        if (FiguraMod.isLocal(id)) {
            category = Permissions.Category.MAX;
        } else if (category == null) {
            category = Permissions.Category.DEFAULT;
        }
        PermissionPack.PlayerPermissionPack pack = new PermissionPack.PlayerPermissionPack(CATEGORIES.get((Object)category), id.toString());
        PLAYERS.put(id, pack);
        FiguraMod.debug("Created Permissions for: " + id, new Object[0]);
        return pack;
    }

    public static PermissionPack.PlayerPermissionPack getMobPermissions(UUID id) {
        PermissionPack.PlayerPermissionPack pack = new PermissionPack.PlayerPermissionPack(CATEGORIES.get((Object)Permissions.Category.MAX), id.toString());
        pack.insert(Permissions.OFFSCREEN_RENDERING, 0, "figura");
        return pack;
    }

    public static boolean increaseCategory(PermissionPack container) {
        return PermissionManager.changeCategory(container, container.getCategory().index + 1);
    }

    public static boolean decreaseCategory(PermissionPack container) {
        return PermissionManager.changeCategory(container, container.getCategory().index - 1);
    }

    private static boolean changeCategory(PermissionPack container, int index) {
        Permissions.Category newCategory = Permissions.Category.indexOf(index);
        if (newCategory == null) {
            return false;
        }
        container.setCategory(CATEGORIES.get((Object)newCategory));
        PermissionManager.saveToDisk();
        return true;
    }

    public static void setDefaultFor(UUID id, Permissions.Category defaultCat) {
        PermissionPack.PlayerPermissionPack pack;
        boolean canAdd;
        if (BACKEND_CHECKED.contains(id)) {
            return;
        }
        if (!PLAYERS.containsKey(id)) {
            canAdd = true;
        } else {
            pack = PLAYERS.get(id);
            Permissions.Category def = PermissionManager.getDefaultCategory();
            if (def == null) {
                def = Permissions.Category.DEFAULT;
            }
            boolean bl = canAdd = !pack.hasChanges() && pack.getCategory() == def;
        }
        if (canAdd) {
            pack = new PermissionPack.PlayerPermissionPack(CATEGORIES.get((Object)defaultCat), id.toString());
            PLAYERS.put(id, pack);
            FiguraMod.debug("Set permissions of {} to {} based on backend userdata", id, defaultCat.name());
        }
        BACKEND_CHECKED.add(id);
    }

    public static Permissions.Category getDefaultCategory() {
        return Permissions.Category.indexOf((Integer)Configs.DEFAULT_PERMISSION_LEVEL.value);
    }
}

