/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.permissions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.lists.PlayerList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerStatusWidget;
import org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PlayerPermPackElement
extends AbstractPermPackElement {
    public static final ResourceLocation UNKNOWN = new FiguraIdentifier("textures/gui/unknown_portrait.png");
    private static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/player_permissions.png");
    private static final Component DC_TEXT = FiguraText.of("gui.permissions.disconnected").m_130940_(ChatFormatting.RED);
    private final String name;
    private final ResourceLocation skin;
    private final UUID owner;
    private final ContextMenu context;
    private final Label nameLabel;
    private final PlayerStatusWidget status;
    public boolean disconnected = false;
    public boolean dragged = false;
    public int anchorX;
    public int anchorY;
    public int initialY;
    public int index;

    public PlayerPermPackElement(int width, String name, PermissionPack pack, ResourceLocation skin, UUID owner, PlayerList parent) {
        super(width, 40, pack, parent);
        this.name = name;
        this.skin = skin;
        this.owner = owner;
        this.context = new ContextMenu((GuiEventListener)this);
        this.nameLabel = new Label((Object)name, 0, 0, 0);
        this.status = new PlayerStatusWidget(0, 0, 70, owner);
        this.generateContext();
    }

    private void generateContext() {
        this.context.addAction((Component)FiguraText.of("gui.context.copy_name"), null, button -> {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getName());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
        this.context.addAction((Component)FiguraText.of("gui.context.copy_uuid"), null, button -> {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getOwner().toString());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
        this.context.addAction((Component)FiguraText.of("gui.context.reload"), null, button -> {
            AvatarManager.reloadAvatar(this.owner);
            FiguraToast.sendToast(FiguraText.of("toast.reload"));
        });
        ContextMenu permissionsContext = new ContextMenu();
        for (Permissions.Category category : Permissions.Category.values()) {
            PermissionPack.CategoryPermissionPack categoryPack = PermissionManager.CATEGORIES.get((Object)category);
            permissionsContext.addAction((Component)categoryPack.getCategoryName(), null, button -> {
                this.pack.setCategory(categoryPack);
                if (this.parent.selectedEntry == this) {
                    this.parent.parent.updatePermissions(this.pack);
                }
            });
        }
        this.context.addTab((Component)FiguraText.of("gui.context.set_permissions"), null, permissionsContext);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (this.dragged) {
            UIHelper.fillRounded(gui, this.m_252754_() - 1, this.m_252907_() - 1, this.m_5711_() + 2, this.m_93694_() + 2, 0x40FFFFFF);
        } else {
            super.m_88315_(gui, mouseX, mouseY, delta);
        }
    }

    public void renderDragged(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int oX = this.m_252754_();
        int oY = this.m_252907_();
        this.m_252865_(mouseX - (this.anchorX - oX));
        this.m_253211_(mouseY - (this.anchorY - oY) + (this.initialY - oY));
        super.m_88315_(gui, mouseX, mouseY, delta);
        this.m_252865_(oX);
        this.m_253211_(oY);
    }

    @Override
    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        PoseStack pose = gui.m_280168_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        pose.m_85836_();
        float tx = (float)this.m_252754_() + (float)width / 2.0f;
        float ty = (float)this.m_252907_() + (float)height / 2.0f;
        pose.m_252880_(tx, ty, 100.0f);
        pose.m_85841_(this.scale, this.scale, 1.0f);
        this.animate(delta, UIHelper.getContext() == this.context && this.context.isVisible() || this.m_5953_(mouseX, mouseY) || this.m_93696_());
        int x = -width / 2;
        int y = -height / 2;
        mouseX = (int)(((float)mouseX - tx) / this.scale);
        mouseY = (int)(((float)mouseY - ty) / this.scale);
        if (this.parent.selectedEntry == this) {
            ArrayList<PermissionPack.CategoryPermissionPack> list = new ArrayList<PermissionPack.CategoryPermissionPack>(PermissionManager.CATEGORIES.values());
            int color = (this.dragged ? (PermissionPack)list.get(Math.min(this.index, list.size() - 1)) : this.pack).getColor();
            UIHelper.fillRounded(gui, x - 1, y - 1, width + 2, height + 2, color + -16777216);
        }
        UIHelper.renderHalfTexture(gui, x, y, width, height, 174, BACKGROUND);
        MutableComponent name = null;
        boolean head = false;
        Avatar avatar = AvatarManager.getAvatarForPlayer(this.owner);
        if (avatar != null) {
            LivingEntity entity;
            Entity e;
            NameplateCustomization custom;
            NameplateCustomization nameplateCustomization = custom = avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.LIST;
            if (custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1) {
                name = custom.getJson().m_6881_();
            }
            boolean upsideDown = (e = EntityUtils.getEntityByUUID(this.owner)) instanceof LivingEntity && LivingEntityRenderer.m_194453_((LivingEntity)(entity = (LivingEntity)e));
            head = avatar.renderPortrait(gui, x + 4, y + 4, Math.round(32.0f * this.scale), 64.0f, upsideDown);
        }
        if (!head) {
            if (this.skin != null) {
                UIHelper.enableBlend();
                gui.m_280411_(this.skin, x + 4, y + 4, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.enableBlend();
                gui.m_280411_(this.skin, x + 4, y + 4, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.disableBlend();
            } else {
                UIHelper.blit(gui, x + 4, y + 4, 32, 32, UNKNOWN);
            }
        }
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent ogName = Component.m_237113_((String)this.name);
        if (name == null) {
            name = ogName;
        }
        name = TextUtils.replaceInText((FormattedText)name, "\\$\\{name\\}", ogName);
        name = TextUtils.splitText((FormattedText)name, "\n").get(0);
        name = Component.m_237119_().m_7220_((Component)name.m_6881_().m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(this.name + "\n" + this.owner))))));
        name = Badges.appendBadges((Component)name, this.owner, false);
        Component badges = Badges.fetchBadges(this.owner);
        if (!badges.getString().isEmpty()) {
            badges = Component.m_237113_((String)" ").m_7220_(badges);
        }
        this.nameLabel.setText((Component)TextUtils.trimToWidthEllipsis(font, (Component)name, width - 44 - font.m_92852_((FormattedText)badges), TextUtils.ELLIPSIS).m_6881_().m_7220_(badges));
        this.nameLabel.m_252865_(x + 40);
        this.nameLabel.m_253211_(y + 4);
        this.nameLabel.m_88315_(gui, mouseX, mouseY, delta);
        if (avatar != null && avatar.nbt != null) {
            this.status.tick();
            this.status.m_252865_(x + 40);
            Objects.requireNonNull(font);
            this.status.m_253211_(y + 6 + 9);
            this.status.m_88315_(gui, mouseX, mouseY, delta);
        }
        Objects.requireNonNull(font);
        int textY = y + height - 9 - 4;
        gui.m_280430_(font, (Component)this.pack.getCategoryName().m_130946_(this.pack.hasChanges() ? "*" : ""), x + 40, textY, 0xFFFFFF);
        if (this.disconnected) {
            gui.m_280430_(font, DC_TEXT, x + width - font.m_92852_((FormattedText)DC_TEXT) - 4, textY, 0xFFFFFF);
        }
        pose.m_85849_();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (button == 1) {
            this.context.m_252865_((int)mouseX);
            this.context.m_253211_((int)mouseY);
            this.context.setVisible(true);
            UIHelper.setContext(this.context);
            return true;
        }
        if (UIHelper.getContext() == this.context) {
            this.context.setVisible(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return !this.dragged && super.m_5953_(mouseX, mouseY);
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.pack.isVisible();
    }
}

