/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.avatar;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.avatar.AbstractAvatarWidget;
import org.figuramc.figura.gui.widgets.lists.AvatarList;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FileTexture;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class AvatarWidget
extends AbstractAvatarWidget {
    public static final ResourceLocation MISSING_ICON = new FiguraIdentifier("textures/gui/unknown_icon.png");

    public AvatarWidget(final int depth, int width, final LocalAvatarFetcher.AvatarPath avatar, AvatarList parent) {
        super(depth, width, 24, avatar, parent);
        final AvatarWidget instance = this;
        MutableComponent description = Emojis.applyEmojis((Component)Component.m_237113_((String)avatar.getDescription()));
        this.button = new Button(this.m_252754_(), this.m_252907_(), width, 24, this.getName(), null, button -> {
            AvatarManager.loadLocalAvatar(avatar.getPath());
            AvatarList.selectedEntry = avatar.getTheActualPathForThis();
        }, (Component)description, parent){
            final /* synthetic */ Component val$description;
            final /* synthetic */ AvatarList val$parent;
            {
                this.val$description = component;
                this.val$parent = avatarList;
                super(x, y, width, height, text, tooltip, pressAction);
            }

            @Override
            public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
                super.m_87963_(gui, mouseX, mouseY, delta);
                if (instance.isOf(AvatarList.selectedEntry)) {
                    UIHelper.fillOutline(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), -1);
                }
            }

            @Override
            protected void renderText(GuiGraphics gui, float delta) {
                Font font = Minecraft.m_91087_().f_91062_;
                int space = 6 * depth;
                int width = this.m_5711_() - 26 - space;
                int x = this.m_252754_() + 2 + space;
                int y = this.m_252907_() + 2;
                FileTexture texture = avatar.getIcon();
                ResourceLocation icon = texture == null ? MISSING_ICON : texture.getLocation();
                UIHelper.blit(gui, x, y, 20, 20, icon);
                Component parsedName = TextUtils.trimToWidthEllipsis(font, this.m_6035_(), width, (Component)TextUtils.ELLIPSIS.m_6881_().m_130948_(this.m_6035_().m_7383_()));
                gui.m_280430_(font, parsedName, x + 22, y, -1);
                Component parsedDescription = TextUtils.trimToWidthEllipsis(font, this.val$description, width, (Component)TextUtils.ELLIPSIS.m_6881_().m_130948_(this.val$description.m_7383_()));
                Objects.requireNonNull(font);
                gui.m_280430_(font, parsedDescription, x + 22, y + 9 + 1, ChatFormatting.GRAY.m_126665_().intValue());
                if (parsedName != this.m_6035_() || parsedDescription != this.val$description) {
                    Component tooltip = instance.getName();
                    if (!this.val$description.getString().isBlank()) {
                        tooltip = tooltip.m_6881_().m_130946_("\n\n").m_7220_(this.val$description);
                    }
                    this.setTooltip(tooltip);
                }
            }

            @Override
            public boolean m_5953_(double mouseX, double mouseY) {
                return this.val$parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
            }

            @Override
            public void setHovered(boolean hovered) {
                if (!hovered && UIHelper.getContext() == AvatarWidget.this.context && AvatarWidget.this.context.isVisible()) {
                    hovered = true;
                }
                super.setHovered(hovered);
            }
        };
        this.button.shouldHaveBackground(false);
        this.children.add(this.button);
    }
}

