/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.avatar.UserData;
import org.figuramc.figura.avatar.local.LocalAvatarLoader;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.widgets.lists.AvatarList;
import org.figuramc.figura.lua.api.particle.ParticleAPI;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.FiguraClientCommandSource;
import org.figuramc.figura.utils.FiguraResourceListener;
import org.figuramc.figura.utils.FiguraText;

public class AvatarManager {
    private static final Map<UUID, UserData> LOADED_USERS = new ConcurrentHashMap<UUID, UserData>();
    private static final Set<UUID> FETCHED_USERS = new HashSet<UUID>();
    private static final Map<Entity, Avatar> LOADED_CEM = new ConcurrentHashMap<Entity, Avatar>();
    public static final FiguraResourceListener RESOURCE_RELOAD_EVENT = FiguraResourceListener.createResourceListener("resource_reload_event", manager -> AvatarManager.executeAll("resourceReloadEvent", Avatar::resourceReloadEvent));
    public static boolean localUploaded = true;
    public static boolean panic = false;

    public static void togglePanic() {
        panic = !panic;
        FiguraToast.sendToast((Object)FiguraText.of(panic ? "toast.panic_enabled" : "toast.panic_disabled"), FiguraToast.ToastType.WARNING);
        SoundAPI.getSoundEngine().figura$stopAllSounds();
        ParticleAPI.getParticleEngine().figura$clearParticles(null);
    }

    public static void tickLoadedAvatars() {
        if (panic) {
            return;
        }
        for (UserData user : LOADED_USERS.values()) {
            Avatar avatar = user.getMainAvatar();
            if (avatar == null) continue;
            FiguraMod.pushProfiler(avatar);
            avatar.tick();
            FiguraMod.popProfiler();
        }
        if (LOADED_CEM.isEmpty()) {
            return;
        }
        HashSet<Entity> toBeRemoved = new HashSet<Entity>();
        for (Entity entity : LOADED_CEM.keySet()) {
            if (!entity.m_213877_()) continue;
            toBeRemoved.add(entity);
        }
        for (Entity entity : toBeRemoved) {
            LOADED_CEM.remove(entity);
        }
        for (Avatar avatar : LOADED_CEM.values()) {
            if (avatar == null) continue;
            FiguraMod.pushProfiler(avatar);
            avatar.tick();
            FiguraMod.popProfiler();
        }
    }

    public static void executeAll(String src, Consumer<Avatar> consumer) {
        if (panic) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(src);
        for (UserData user : LOADED_USERS.values()) {
            Avatar avatar = user.getMainAvatar();
            if (avatar == null) continue;
            FiguraMod.pushProfiler(avatar);
            consumer.accept(avatar);
            FiguraMod.popProfiler();
        }
        for (Avatar avatar : LOADED_CEM.values()) {
            if (avatar == null) continue;
            FiguraMod.pushProfiler(avatar);
            consumer.accept(avatar);
            FiguraMod.popProfiler();
        }
        FiguraMod.popProfiler(2);
    }

    public static Avatar getAvatarForPlayer(UUID player) {
        if (panic || Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        AvatarManager.fetchBackend(player);
        UserData user = LOADED_USERS.get(player);
        return user == null ? null : user.getMainAvatar();
    }

    private static Avatar getAvatarForEntity(Entity entity) {
        Avatar loaded = LOADED_CEM.get(entity);
        if (loaded != null) {
            return loaded;
        }
        ResourceLocation type = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        CompoundTag nbt = LocalAvatarLoader.CEM_AVATARS.get(type);
        return nbt == null ? null : AvatarManager.loadEntityAvatar(entity, nbt);
    }

    public static Avatar getAvatar(Entity entity) {
        Avatar avatar;
        if (panic || Minecraft.m_91087_().f_91073_ == null || entity == null) {
            return null;
        }
        UUID uuid = entity.m_20148_();
        if (entity instanceof Player && (avatar = AvatarManager.getAvatarForPlayer(uuid)) != null) {
            return avatar;
        }
        return AvatarManager.getAvatarForEntity(entity);
    }

    public static Avatar getLoadedAvatar(UUID owner) {
        if (panic || Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        UserData user = LOADED_USERS.get(owner);
        return user == null ? null : user.getMainAvatar();
    }

    public static List<Avatar> getLoadedAvatars() {
        ArrayList<Avatar> list = new ArrayList<Avatar>();
        for (UserData user : LOADED_USERS.values()) {
            Avatar avatar = user.getMainAvatar();
            if (avatar == null || avatar.nbt == null) continue;
            list.add(avatar);
        }
        return list;
    }

    public static void clearAvatars(UUID id) {
        FETCHED_USERS.remove(id);
        UserData user = LOADED_USERS.get(id);
        if (user != null) {
            user.clear();
        }
        NetworkStuff.clear(id);
        FiguraMod.debug("Cleared avatars of " + id, new Object[0]);
    }

    public static void clearCEMAvatars() {
        for (Avatar avatar : LOADED_CEM.values()) {
            avatar.clean();
        }
        LOADED_CEM.clear();
    }

    public static void clearAllAvatars() {
        for (UUID id : LOADED_USERS.keySet()) {
            AvatarManager.clearAvatars(id);
        }
        LOADED_USERS.clear();
        FETCHED_USERS.clear();
        AvatarManager.clearCEMAvatars();
        localUploaded = true;
        AvatarList.selectedEntry = null;
        LocalAvatarLoader.loadAvatar(null, null);
        FiguraMod.LOGGER.info("Cleared all avatars");
    }

    public static void reloadAvatar(UUID id) {
        if (!localUploaded && FiguraMod.isLocal(id)) {
            AvatarManager.loadLocalAvatar(LocalAvatarLoader.getLastLoadedPath());
        } else {
            AvatarManager.clearAvatars(id);
        }
    }

    public static void loadLocalAvatar(Path path) {
        UUID id = FiguraMod.getLocalPlayerUUID();
        AvatarManager.clearAvatars(id);
        FETCHED_USERS.add(id);
        UserData user = LOADED_USERS.computeIfAbsent(id, UserData::new);
        LocalAvatarLoader.loadAvatar(path, user);
        localUploaded = false;
    }

    public static Avatar loadEntityAvatar(Entity entity, CompoundTag nbt) {
        Avatar targetAvatar = new Avatar(entity);
        targetAvatar.load(nbt);
        LOADED_CEM.put(entity, targetAvatar);
        return targetAvatar;
    }

    public static void setAvatar(UUID id, CompoundTag nbt) {
        try {
            UserData user = LOADED_USERS.computeIfAbsent(id, UserData::new);
            AvatarManager.clearAvatars(id);
            user.loadAvatar(nbt);
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to set avatar for " + id, (Throwable)e);
        }
    }

    private static void fetchBackend(UUID id) {
        if (FETCHED_USERS.contains(id)) {
            return;
        }
        FETCHED_USERS.add(id);
        if (EntityUtils.checkInvalidPlayer(id)) {
            FiguraMod.debug("Voiding userdata for " + id, new Object[0]);
            return;
        }
        UserData user = LOADED_USERS.computeIfAbsent(id, UserData::new);
        FiguraMod.debug("Getting userdata for " + id, new Object[0]);
        NetworkStuff.getUser(user);
    }

    public static Pair<BitSet, BitSet> getBadges(UUID id) {
        UserData user = LOADED_USERS.get(id);
        if (user == null) {
            return null;
        }
        Pair<BitSet, BitSet> badges = user.getBadges();
        if (badges != null) {
            return badges;
        }
        badges = Badges.emptyBadges();
        user.loadBadges(badges);
        return badges;
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"set_avatar");
        RequiredArgumentBuilder target = RequiredArgumentBuilder.argument((String)"target", (ArgumentType)StringArgumentType.word());
        RequiredArgumentBuilder source = RequiredArgumentBuilder.argument((String)"source", (ArgumentType)StringArgumentType.word());
        source.executes(context -> {
            Avatar avatar;
            UUID targetUUID;
            UUID sourceUUID;
            String s = StringArgumentType.getString((CommandContext)context, (String)"source");
            String t = StringArgumentType.getString((CommandContext)context, (String)"target");
            try {
                sourceUUID = UUID.fromString(s);
                targetUUID = UUID.fromString(t);
            }
            catch (Exception e) {
                ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)Component.m_237113_((String)"Failed to parse uuids"));
                return 0;
            }
            UserData user = LOADED_USERS.get(sourceUUID);
            Avatar avatar2 = avatar = user == null ? null : user.getMainAvatar();
            if (avatar == null || avatar.nbt == null) {
                ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)Component.m_237113_((String)"No source Avatar found"));
                return 0;
            }
            if (LOADED_USERS.get(targetUUID) != null) {
                AvatarManager.setAvatar(targetUUID, avatar.nbt);
                if (FiguraMod.isLocal(targetUUID)) {
                    localUploaded = true;
                }
                ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)Component.m_237113_((String)("Set avatar for " + t)));
                return 1;
            }
            Entity targetEntity = EntityUtils.getEntityByUUID(targetUUID);
            if (targetEntity == null) {
                ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)Component.m_237113_((String)"Target entity not found"));
                return 0;
            }
            AvatarManager.loadEntityAvatar(targetEntity, avatar.nbt);
            return 1;
        });
        target.then((ArgumentBuilder)source);
        root.then((ArgumentBuilder)target);
        return root;
    }
}

