/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.feathers.event;

import com.elenai.feathers.api.FeathersHelper;
import com.elenai.feathers.attributes.FeathersAttributes;
import com.elenai.feathers.capability.PlayerFeathers;
import com.elenai.feathers.capability.PlayerFeathersProvider;
import com.elenai.feathers.config.FeathersCommonConfig;
import com.elenai.feathers.effect.FeathersEffects;
import com.elenai.feathers.networking.FeathersMessages;
import com.elenai.feathers.networking.packet.ColdSyncSTCPacket;
import com.elenai.feathers.networking.packet.EnergizedSyncSTCPacket;
import com.elenai.feathers.networking.packet.FeatherSyncSTCPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="feathers")
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        Level level = event.getLevel();
        if (!level.f_46443_ && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
                FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player);
                FeathersMessages.sendToPlayer(new ColdSyncSTCPacket(f.isCold()), player);
                FeathersMessages.sendToPlayer(new EnergizedSyncSTCPacket(player.m_21023_((MobEffect)FeathersEffects.ENERGIZED.get())), player);
            });
        }
    }

    private static void handleFrostEffect(TickEvent.PlayerTickEvent event) {
        if (((Boolean)FeathersCommonConfig.ENABLE_FROST_EFFECTS.get()).booleanValue()) {
            Level level = event.player.m_9236_();
            if (event.player.f_146808_ || event.player.f_146809_ || ((Biome)level.m_204166_(event.player.m_20183_()).get()).m_198904_(event.player.m_20183_())) {
                if (!event.player.m_21023_((MobEffect)FeathersEffects.COLD.get()) || ((MobEffectInstance)event.player.m_21221_().get(FeathersEffects.COLD.get())).m_19557_() < 1000) {
                    event.player.m_7292_(new MobEffectInstance((MobEffect)FeathersEffects.COLD.get(), 999999, 0, false, true));
                }
            } else if (event.player.m_21023_((MobEffect)FeathersEffects.COLD.get()) && ((MobEffectInstance)event.player.m_21221_().get(FeathersEffects.COLD.get())).m_19557_() > 201) {
                event.player.m_21195_((MobEffect)FeathersEffects.COLD.get());
                event.player.m_7292_(new MobEffectInstance((MobEffect)FeathersEffects.COLD.get(), 200, 0, false, true));
            }
        }
    }

    private static void handleEnduranceEffect(TickEvent.PlayerTickEvent event) {
        if (event.player.m_21023_((MobEffect)FeathersEffects.ENDURANCE.get()) && FeathersHelper.getEndurance((ServerPlayer)event.player) == 0) {
            event.player.m_21195_((MobEffect)FeathersEffects.ENDURANCE.get());
        }
    }

    private static void regenerateFeathers(TickEvent.PlayerTickEvent event) {
        event.player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> {
            CommonEvents.syncFeatherAttributes((ServerPlayer)event.player);
            if (f.getFeathers() < f.getMaxFeathers() && !f.isCold()) {
                if (!event.player.m_21023_((MobEffect)FeathersEffects.ENERGIZED.get())) {
                    f.addCooldown(f.getRegen());
                } else {
                    f.addCooldown(((MobEffectInstance)event.player.m_21221_().get(FeathersEffects.ENERGIZED.get())).m_19564_() + 1 + f.getRegen());
                }
            }
            if (f.getCooldown() >= (Integer)FeathersCommonConfig.COOLDOWN.get()) {
                FeathersHelper.addFeathers((ServerPlayer)event.player, 1);
            }
        });
    }

    private static void syncFeatherAttributes(ServerPlayer player) {
        int maxFeathers = (int)player.m_21133_((Attribute)FeathersAttributes.MAX_FEATHERS.get());
        int regen = (int)player.m_21133_((Attribute)FeathersAttributes.FEATHER_REGEN.get());
        FeathersHelper.setMaxFeathers(player, maxFeathers);
        FeathersHelper.setFeatherRegen(player, regen);
    }

    @SubscribeEvent
    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            CommonEvents.regenerateFeathers(event);
            CommonEvents.handleFrostEffect(event);
            CommonEvents.handleEnduranceEffect(event);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeArmor(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
                player.getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(f -> FeathersMessages.sendToPlayer(new FeatherSyncSTCPacket(f.getFeathers(), f.getMaxFeathers(), f.getRegen(), FeathersHelper.getPlayerWeight(player), f.getEnduranceFeathers()), player));
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).isPresent()) {
            event.addCapability(new ResourceLocation("feathers", "properties"), (ICapabilityProvider)new PlayerFeathersProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerFeathersProvider.PLAYER_FEATHERS).ifPresent(newStore -> newStore.copyFrom((PlayerFeathers)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerFeathers.class);
    }
}

