/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.blockentity;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class AlbumJukeboxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private int playingIndex = -1;
    private int track = 0;
    private ItemStack playingStack = ItemStack.f_41583_;
    private boolean loaded;

    public AlbumJukeboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EtchedBlocks.ALBUM_JUKEBOX_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AlbumJukeboxBlockEntity entity) {
        if (level == null || !level.m_5776_()) {
            return;
        }
        if (!entity.loaded) {
            entity.loaded = true;
            SoundTracker.playAlbum(entity, state, (ClientLevel)level, pos, false);
        }
        if (entity.isPlaying()) {
            AABB range = new AABB(pos).m_82400_(3.45);
            List livingEntities = level.m_45976_(LivingEntity.class, range);
            livingEntities.forEach(living -> living.m_6818_(pos, true));
        }
    }

    private void updateState() {
        if (this.f_58857_ != null) {
            boolean hasRecord;
            boolean hasItem = false;
            for (ItemStack stack : this.m_7086_()) {
                if (stack == ItemStack.f_41583_) continue;
                hasItem = true;
                break;
            }
            if (hasItem != (hasRecord = ((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)AlbumJukeboxBlock.HAS_RECORD)).booleanValue())) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)AlbumJukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasItem)), 3);
                this.m_6596_();
            }
        }
    }

    private void updatePlaying() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
        if (this.loaded) {
            SoundTracker.playAlbum(this, this.m_58900_(), (ClientLevel)this.f_58857_, this.m_58899_(), false);
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int[] m_7071_(Direction direction) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return PlayableRecord.isPlayableRecord(stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int m_6643_() {
        return 9;
    }

    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack = super.m_7407_(index, amount);
        this.updateState();
        if (!stack.m_41619_()) {
            this.updatePlaying();
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = super.m_8016_(index);
        this.updateState();
        if (!stack.m_41619_()) {
            this.updatePlaying();
        }
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        this.updateState();
        this.updatePlaying();
    }

    public void m_6211_() {
        super.m_6211_();
        this.updateState();
        this.updatePlaying();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.etched.album_jukebox");
    }

    protected AbstractContainerMenu m_6555_(int menuId, Inventory inventory) {
        return new AlbumJukeboxMenu(menuId, inventory, (Container)this, this.m_58899_());
    }

    public int m_6893_() {
        return 1;
    }

    public int getPlayingIndex() {
        return this.playingIndex;
    }

    public int getTrack() {
        return this.track;
    }

    public boolean setPlayingIndex(int playingIndex, int track) {
        this.playingIndex = playingIndex;
        this.track = track;
        if (this.recalculatePlayingIndex(false)) {
            int tracks = PlayableRecord.getStackTrackCount(this.playingStack);
            if (this.track >= tracks) {
                this.track = 0;
            }
            return true;
        }
        return false;
    }

    public void stopPlaying() {
        this.playingIndex = -1;
        this.track = 0;
        this.playingStack = ItemStack.f_41583_;
    }

    public void previous() {
        if (this.track > 0) {
            --this.track;
        } else {
            --this.playingIndex;
            if (this.playingIndex < 0) {
                this.playingIndex = this.m_6643_() - 1;
            }
            this.nextPlayingIndex(true);
            this.track = Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.m_6643_() ? 0 : PlayableRecord.getStackTrackCount(this.m_8020_(this.playingIndex)) - 1);
            this.playingStack = ItemStack.f_41583_;
        }
    }

    public void next() {
        int tracks;
        int n = tracks = this.playingIndex < 0 || this.playingIndex >= this.m_6643_() ? 1 : PlayableRecord.getStackTrackCount(this.m_8020_(this.playingIndex));
        if (this.track < tracks - 1) {
            ++this.track;
        } else {
            ++this.playingIndex;
            this.playingIndex %= this.m_6643_();
            this.nextPlayingIndex(false);
            this.track = 0;
            this.playingStack = ItemStack.f_41583_;
        }
    }

    public void nextPlayingIndex(boolean reverse) {
        boolean wrap = false;
        this.playingIndex = Mth.m_14045_((int)this.playingIndex, (int)0, (int)(this.m_6643_() - 1));
        while (!PlayableRecord.isPlayableRecord(this.m_8020_(this.playingIndex))) {
            if (reverse) {
                --this.playingIndex;
                if (this.playingIndex >= 0) continue;
                this.playingIndex = this.m_6643_() - 1;
                if (wrap) {
                    this.playingIndex = -1;
                    this.track = 0;
                    this.playingStack = ItemStack.f_41583_;
                    return;
                }
                wrap = true;
                continue;
            }
            ++this.playingIndex;
            if (this.playingIndex < this.m_6643_()) continue;
            this.playingIndex = 0;
            if (wrap) {
                this.playingIndex = -1;
                this.track = 0;
                this.playingStack = ItemStack.f_41583_;
                return;
            }
            wrap = true;
        }
        this.playingStack = this.m_8020_(this.playingIndex).m_41777_();
    }

    public boolean recalculatePlayingIndex(boolean reverse) {
        if (this.m_7983_()) {
            if (this.playingIndex == -1) {
                return false;
            }
            this.playingIndex = -1;
            this.track = 0;
            return true;
        }
        int oldIndex = this.playingIndex;
        ItemStack oldStack = this.playingStack.m_41777_();
        this.nextPlayingIndex(reverse);
        if (oldIndex != this.playingIndex || !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)this.playingStack)) {
            this.track = reverse ? Math.max(0, this.playingIndex < 0 || this.playingIndex >= this.m_6643_() ? 0 : PlayableRecord.getStackTrackCount(this.m_8020_(this.playingIndex)) - 1) : 0;
            return true;
        }
        return false;
    }

    public boolean isPlaying() {
        BlockState state = this.m_58900_();
        return (!state.m_61138_((Property)AlbumJukeboxBlock.POWERED) || (Boolean)state.m_61143_((Property)AlbumJukeboxBlock.POWERED) == false) && !this.m_7983_();
    }
}

