/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AlbumJukeboxScreen
extends AbstractContainerScreen<AlbumJukeboxMenu> {
    private static final ResourceLocation CONTAINER_LOCATION = new ResourceLocation("textures/gui/container/dispenser.png");
    private static final Component NOW_PLAYING = Component.m_237115_((String)"screen.etched.album_jukebox.now_playing").m_130940_(ChatFormatting.YELLOW);
    private int playingIndex;
    private int playingTrack;

    public AlbumJukeboxScreen(AlbumJukeboxMenu dispenserMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)dispenserMenu, inventory, component);
    }

    private void update(boolean next) {
        AlbumJukeboxBlockEntity albumJukebox;
        ClientLevel level;
        block8: {
            block7: {
                level = this.f_96541_.f_91073_;
                if (level == null || !((AlbumJukeboxMenu)this.f_97732_).isInitialized()) {
                    return;
                }
                BlockEntity blockEntity = level.m_7702_(((AlbumJukeboxMenu)this.f_97732_).getPos());
                if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) break block7;
                albumJukebox = (AlbumJukeboxBlockEntity)blockEntity;
                if (((AlbumJukeboxBlockEntity)blockEntity).isPlaying()) break block8;
            }
            return;
        }
        int oldIndex = albumJukebox.getPlayingIndex();
        int oldTrack = albumJukebox.getTrack();
        if (next) {
            albumJukebox.next();
        } else {
            albumJukebox.previous();
        }
        if ((albumJukebox.getPlayingIndex() == oldIndex && albumJukebox.getTrack() != oldTrack || albumJukebox.recalculatePlayingIndex(!next)) && albumJukebox.getPlayingIndex() != -1) {
            SoundTracker.playAlbum(albumJukebox, albumJukebox.m_58900_(), level, ((AlbumJukeboxMenu)this.f_97732_).getPos(), true);
            EtchedMessages.PLAY.sendToServer((Object)new SetAlbumJukeboxTrackPacket(albumJukebox.getPlayingIndex(), albumJukebox.getTrack()));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonPadding = 6;
        MutableComponent last = Component.m_237113_((String)"\u041d\u0430\u0437\u0430\u0434");
        MutableComponent next = Component.m_237113_((String)"\u0421\u043b\u0435\u0434.");
        Font font = Minecraft.m_91087_().f_91062_;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)last, b -> this.update(false)).m_252987_(this.f_97735_ + 7 + (54 - font.m_92852_((FormattedText)last)) / 2 - buttonPadding, this.f_97736_ + 33, font.m_92852_((FormattedText)last) + 2 * buttonPadding, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)next, b -> this.update(true)).m_252987_(this.f_97735_ + 115 + (54 - font.m_92852_((FormattedText)last)) / 2 - buttonPadding, this.f_97736_ + 33, font.m_92852_((FormattedText)next) + 2 * buttonPadding, 20).m_253136_());
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiLeft = (this.f_96543_ - this.f_97726_) / 2;
        int guiTop = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(CONTAINER_LOCATION, guiLeft, guiTop, 0, 0, this.f_97726_, this.f_97727_);
        this.playingIndex = -1;
        this.playingTrack = 0;
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null || !((AlbumJukeboxMenu)this.f_97732_).isInitialized()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(((AlbumJukeboxMenu)this.f_97732_).getPos());
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        this.playingIndex = ((AlbumJukeboxBlockEntity)blockEntity).getPlayingIndex();
        this.playingTrack = ((AlbumJukeboxBlockEntity)blockEntity).getTrack();
        if (this.playingIndex != -1) {
            int x = this.playingIndex % 3;
            int y = this.playingIndex / 3;
            guiGraphics.m_280024_(guiLeft + 62 + x * 18, guiTop + 17 + y * 18, guiLeft + 78 + x * 18, guiTop + 33 + y * 18, 1022820096, 1022820096);
        }
    }

    protected List<Component> m_280553_(ItemStack stack) {
        List tooltip = super.m_280553_(stack);
        if (this.f_97734_ != null && this.f_97734_.f_40219_ == this.playingIndex) {
            if (this.playingTrack >= 0 && PlayableRecord.getStackTrackCount(stack) > 0) {
                Optional<TrackData[]> optional = PlayableRecord.getStackMusic(stack).filter(tracks -> this.playingTrack < ((TrackData[])tracks).length);
                if (optional.isPresent()) {
                    TrackData track = optional.get()[this.playingTrack];
                    tooltip.add(NOW_PLAYING.m_6881_().m_130946_(": ").m_7220_(track.getDisplayName()).m_130946_(" (" + (this.playingTrack + 1) + "/" + optional.get().length + ")"));
                } else {
                    tooltip.add(NOW_PLAYING);
                }
            } else {
                tooltip.add(NOW_PLAYING);
            }
        }
        return tooltip;
    }
}

